/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.digest;

import com.boom.netty.digest.GeneralDigest;
import com.boom.netty.digest.HashFile;
import com.boom.netty.digest.HashWriter;
import com.google.gson.Gson;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class HashFileWriter {
    private static BlockingQueue<HashFile> hashQueue = new LinkedBlockingQueue<HashFile>();
    private static Gson gson = new Gson();

    public static void writeDigestToFile(GeneralDigest digest, String filePath) throws InterruptedException {
        HashFile hf = new HashFile(digest.getSerializedString(), filePath + ".@@sha256", digest.getAlgorithmName());
        hashQueue.removeIf(hashFile -> hashFile.fileName.equals(hf.fileName));
        hashQueue.put(hf);
    }

    public static void writeDigestAndClearQueue(GeneralDigest digest, String filePath) throws IOException {
        HashFile hf = new HashFile(digest.getSerializedString(), filePath + ".@@sha256", digest.getAlgorithmName());
        hashQueue.removeIf(hashFile -> hashFile.fileName.equals(hf.fileName));
        try (FileWriter writer = new FileWriter(hf.fileName);){
            writer.append(gson.toJson((Object)hf, (Type)((Object)HashFile.class)));
            writer.flush();
        }
    }

    static {
        new Thread(new HashWriter(hashQueue)).start();
    }
}

