/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.server;

import com.boom.netty.server.IncomingConnectionVerifier;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Set;

public class InetSocketAddressVerifier
implements IncomingConnectionVerifier {
    private Set<String> allowedHosts;

    public InetSocketAddressVerifier(Set<String> allowedHosts) {
        this.allowedHosts = allowedHosts;
    }

    @Override
    public boolean connectionAccepted(Channel channel) {
        if (channel.remoteAddress() instanceof InetSocketAddress) {
            InetAddress address = ((InetSocketAddress)channel.remoteAddress()).getAddress();
            String ipIncoming = address.getHostAddress();
            String hostnameIncoming = address.getHostName().toLowerCase();
            return this.allowedHosts.contains(ipIncoming) || this.allowedHosts.contains(hostnameIncoming);
        }
        return false;
    }
}

