/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.server;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutingTable.class);
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<String, Channel> deviceIdToChannelMap = new HashMap<String, Channel>();
    private Map<Channel, String> channelToDeviceIdMap = new HashMap<Channel, String>();
    private Map<String, Channel> masterIdToChannelMap = new HashMap<String, Channel>();
    private Map<Channel, String> channelToMasterIdMap = new HashMap<Channel, String>();
    private Map<String, Channel> slaveIdToChannelMap = new HashMap<String, Channel>();
    private Map<Channel, String> channelToSlaveIdMap = new HashMap<Channel, String>();
    private Map<String, Channel> remoteServerIdToChannelMap = new HashMap<String, Channel>();
    private Map<Channel, List<String>> channelToRemoteServerIdsMap = new HashMap<Channel, List<String>>();

    public void addMappingDevice(String deviceId, Channel channel) {
        this.lock.writeLock().lock();
        try {
            this.deviceIdToChannelMap.put(deviceId, channel);
            this.channelToDeviceIdMap.put(channel, deviceId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addMappingMaster(String deviceId, Channel channel) {
        this.lock.writeLock().lock();
        try {
            this.masterIdToChannelMap.put(deviceId, channel);
            this.channelToMasterIdMap.put(channel, deviceId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addMappingSlave(String deviceId, Channel channel) {
        this.lock.writeLock().lock();
        try {
            this.slaveIdToChannelMap.put(deviceId, channel);
            this.channelToSlaveIdMap.put(channel, deviceId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMappingRemoteServer(String deviceId, Channel channel) {
        this.lock.writeLock().lock();
        try {
            this.remoteServerIdToChannelMap.put(deviceId, channel);
            List remoteIds = this.channelToRemoteServerIdsMap.computeIfAbsent(channel, channel1 -> new ArrayList());
            remoteIds.add(deviceId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Optional<Channel> getChannel(String id) {
        Optional<Channel> chanel1 = this.getChannelOtherServers(id);
        if (chanel1.isPresent()) {
            return chanel1;
        }
        return this.getChannelDevice(id);
    }

    public Optional<Channel> getChannelDevice(String deviceId) {
        this.lock.readLock().lock();
        try {
            Optional<Channel> optional = Optional.ofNullable(this.deviceIdToChannelMap.get(deviceId));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Optional<Channel> getRemoteDeviceChannel(String serverId) {
        this.lock.readLock().lock();
        try {
            Optional<Channel> optional = Optional.ofNullable(this.remoteServerIdToChannelMap.get(serverId));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<String> getRemoteDevices(Channel channel) {
        this.lock.readLock().lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.channelToRemoteServerIdsMap.getOrDefault(channel, Collections.emptyList()));
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Channel> getChannelOtherServers(String serverId) {
        this.lock.readLock().lock();
        try {
            Optional<Channel> channel = Optional.ofNullable(this.masterIdToChannelMap.get(serverId));
            if (channel.isPresent()) {
                Optional<Channel> optional = channel;
                return optional;
            }
            channel = Optional.ofNullable(this.slaveIdToChannelMap.get(serverId));
            if (channel.isPresent()) {
                Optional<Channel> optional = channel;
                return optional;
            }
            Optional<Channel> optional = Optional.ofNullable(this.remoteServerIdToChannelMap.get(serverId));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Optional<String> getDeviceId(Channel channel) {
        this.lock.readLock().lock();
        try {
            Optional<String> optional = Optional.ofNullable(this.channelToDeviceIdMap.get(channel));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Optional<String> getMasterId(Channel channel) {
        this.lock.readLock().lock();
        try {
            Optional<String> optional = Optional.ofNullable(this.channelToMasterIdMap.get(channel));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Optional<String> getSlaveId(Channel channel) {
        this.lock.readLock().lock();
        try {
            Optional<String> optional = Optional.ofNullable(this.channelToSlaveIdMap.get(channel));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapping(String deviceId) {
        this.lock.writeLock().lock();
        try {
            if (this.masterIdToChannelMap.containsKey(deviceId)) {
                Channel ch = this.masterIdToChannelMap.remove(deviceId);
                if (ch != null) {
                    this.channelToMasterIdMap.remove(ch);
                }
            } else if (this.slaveIdToChannelMap.containsKey(deviceId)) {
                Channel ch = this.slaveIdToChannelMap.remove(deviceId);
                if (ch != null) {
                    this.channelToSlaveIdMap.remove(ch);
                }
            } else if (this.remoteServerIdToChannelMap.containsKey(deviceId)) {
                Channel ch = this.remoteServerIdToChannelMap.remove(deviceId);
                if (ch != null) {
                    List ids = this.channelToRemoteServerIdsMap.getOrDefault(ch, Collections.emptyList());
                    ids.remove(deviceId);
                }
            } else if (this.deviceIdToChannelMap.containsKey(deviceId)) {
                Channel ch = this.deviceIdToChannelMap.remove(deviceId);
                if (ch != null) {
                    this.channelToDeviceIdMap.remove(ch);
                }
            } else {
                LOGGER.debug("failed to remove mapping. ID not found {}", (Object)deviceId);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapping(Channel channel) {
        this.lock.writeLock().lock();
        try {
            String id2;
            boolean removed = false;
            if (this.channelToMasterIdMap.containsKey(channel)) {
                id2 = this.channelToMasterIdMap.remove(channel);
                if (id2 != null) {
                    this.masterIdToChannelMap.remove(id2);
                }
                removed = true;
            } else if (this.channelToSlaveIdMap.containsKey(channel)) {
                id2 = this.channelToSlaveIdMap.remove(channel);
                if (id2 != null) {
                    this.slaveIdToChannelMap.remove(id2);
                }
                removed = true;
            } else if (this.channelToDeviceIdMap.containsKey(channel)) {
                id2 = this.channelToDeviceIdMap.remove(channel);
                if (id2 != null) {
                    this.deviceIdToChannelMap.remove(id2);
                }
                removed = true;
            }
            if (this.channelToRemoteServerIdsMap.containsKey(channel)) {
                List<String> removedIds = this.channelToRemoteServerIdsMap.remove(channel);
                if (removedIds != null) {
                    removedIds.forEach(id -> this.remoteServerIdToChannelMap.remove(id));
                }
                removed = true;
            }
            if (!removed) {
                LOGGER.debug("failed to remove mapping. Channel not found {}", (Object)channel);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<String> getMasterIds() {
        this.lock.readLock().lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.masterIdToChannelMap.keySet());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<String> getSlaveIds() {
        this.lock.readLock().lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.slaveIdToChannelMap.keySet());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<String> getRemoteIds() {
        this.lock.readLock().lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.remoteServerIdToChannelMap.keySet());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<String> getDeviceIds() {
        this.lock.readLock().lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.deviceIdToChannelMap.keySet());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getDump() {
        this.lock.readLock().lock();
        try {
            String dump = "Devices: " + this.deviceIdToChannelMap.keySet().stream().sorted().collect(Collectors.joining(", ")) + '\n';
            dump = dump + "Masters: " + this.masterIdToChannelMap.keySet().stream().sorted().collect(Collectors.joining(", ")) + '\n';
            dump = dump + "Slaves: " + this.slaveIdToChannelMap.keySet().stream().sorted().collect(Collectors.joining(", ")) + '\n';
            String string = dump = dump + "Remote: " + this.remoteServerIdToChannelMap.keySet().stream().sorted().collect(Collectors.joining(", "));
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

