/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.server;

import com.boom.netty.client.Client;
import com.boom.netty.client.ClientConfigurationException;
import com.boom.netty.common.AgentIdConflictHandler;
import com.boom.netty.common.ChannelUtils;
import com.boom.netty.common.DeviceConnectivityListener;
import com.boom.netty.common.MasterConnectivityListener;
import com.boom.netty.common.MessageSender;
import com.boom.netty.common.SlaveConnectivityListener;
import com.boom.netty.server.ClientVerifier;
import com.boom.netty.server.IncomingConnectionVerifier;
import com.boom.netty.server.MasterPassport;
import com.boom.netty.server.RoutingTable;
import com.boom.netty.server.ServerConfiguration;
import com.boom.netty.server.ServerConnectionSettings;
import com.boom.netty.server.ServerDevicesRegistry;
import com.boom.netty.service.basic.msg.BasicMessageTypes;
import com.boom.netty.service.basic.msg.ConnectionRejectedMsg;
import com.boom.netty.service.basic.msg.HelloMsg;
import com.boom.netty.service.basic.msg.MessageProcessingFailedMsg;
import com.boom.netty.service.basic.msg.PingMsg;
import com.boom.netty.service.basic.msg.ReachableServersRequestMsg;
import com.boom.netty.service.basic.msg.ReachableServersResponseMsg;
import com.boom.netty.service.basic.msg.ServersLeftNetworkMsg;
import com.boom.netty.service.util.PingPongMessageHandler;
import com.boom.netty.service.util.TraceMessageHandler;
import com.boom.netty.service.util.msg.TraceRouteMsg;
import com.boom.netty.ws.common.NettyChannelStateListener;
import com.boom.netty.ws.common.WebSocketMessageHandler;
import com.boom.netty.ws.mhf.MessageTypeHandler;
import com.boom.netty.ws.mhf.MessageTypeRegistrationException;
import com.boom.netty.ws.mhf.MessageTypesRepository;
import com.boom.netty.ws.mhf.annotation.MessageHandlerMethod;
import com.boom.netty.ws.mhf.msg.MessageBase;
import com.boom.netty.ws.server.WebSocketInitializationException;
import com.boom.netty.ws.server.WebSocketServer;
import com.boom.netty.ws.server.WebSocketServerEventHandler;
import com.boom.netty.ws.server.stats.TrafficStatistics;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements WebSocketServerEventHandler,
NettyChannelStateListener,
MessageSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(Server.class);
    private static final AttributeKey<Boolean> ALLOW_APP_LAYER_ACCESS_ATTRIBUTE = AttributeKey.valueOf("app_layer_allowed");
    private static final String RECEIVED_HELLO_MSG_LOG = "Received HelloMsg from {}, remoteAddr: {}";
    private static final String SENDING_MESSAGE_LOG = "{} | Sending message {}";
    private final long messageProcessingFailedMsgId;
    private String serverDeviceId;
    private final RoutingTable routingTable = new RoutingTable();
    private final MessageTypeHandler routingLayerMessageHandler;
    private final MessageTypeHandler sandboxMessageHandler;
    private final MessageTypeHandler applicationLayerMessageHandler;
    private Set<DeviceConnectivityListener> deviceConnectivityListeners = new HashSet<DeviceConnectivityListener>();
    private Set<MasterConnectivityListener> masterConnectivityListeners = new HashSet<MasterConnectivityListener>();
    private Set<SlaveConnectivityListener> slaveConnectivityListeners = new HashSet<SlaveConnectivityListener>();
    private final WebSocketMessageHandler webSocketMessageHandler;
    private Predicate<MasterPassport> masterServerChecker = masterPassport -> true;
    private int port;
    private String address;
    private int maxClientSendQueueSizes;
    private ServerDevicesRegistry serverDevicesRegistry = null;
    private ExecutorService asynchronousMessageSendQueue;
    private WebSocketServer wsServer;
    private Map<String, ServerConnectionSettings> slavesConnectionSettingsMap = new HashMap<String, ServerConnectionSettings>();
    private Map<String, Client> clientsToSlavesMap = new HashMap<String, Client>();
    private String logTag;
    private KeyStore trustStore;
    private ClientVerifier clientVerifier = null;
    private KeyManagerFactory keyMgrFactory;
    private IncomingConnectionVerifier incomingConnectionVerifier = null;
    private ConcurrentHashMap<Channel, Long> channelToConnectedTimestampMap = new ConcurrentHashMap(1000);
    private AgentIdConflictHandler conflictHandler = new AgentIdConflictHandler();

    public Server(ServerConnectionSettings serverConnectionSettings, KeyManagerFactory keyMgrFactory, KeyStore trustStore, Consumer<TrafficStatistics> trafficStatisticsConsumer) {
        this(serverConnectionSettings, keyMgrFactory, trustStore, false, 50000, 10000, trafficStatisticsConsumer);
    }

    public Server(ServerConfiguration conf, Consumer<TrafficStatistics> trafficStatisticsConsumer) {
        this(conf.getServerConnectionSettings(), conf.getKeyMgrFactory(), conf.getTrustStore(), conf.isRequireClientCertificates(), conf.getMaxSendQueueSize(), conf.getMaxClientSendQueueSizes(), trafficStatisticsConsumer);
    }

    public Server(ServerConnectionSettings serverConnectionSettings, KeyManagerFactory keyMgrFactory, KeyStore trustStore, boolean requireClientCertificates, int maxSendQueueSize, int maxClientSendQueueSizes, Consumer<TrafficStatistics> trafficStatisticsConsumer) {
        this.serverDeviceId = serverConnectionSettings.getDeviceId();
        this.keyMgrFactory = keyMgrFactory;
        try {
            this.registerMessageTypes(BasicMessageTypes.BASIC_MESSAGE_TYPES);
        }
        catch (MessageTypeRegistrationException e) {
            throw new RuntimeException("Could not register basic message types", e);
        }
        this.messageProcessingFailedMsgId = new MessageProcessingFailedMsg(null, null, 0, null).getMessageTypeId();
        this.trustStore = trustStore;
        this.address = serverConnectionSettings.getAddress();
        this.port = serverConnectionSettings.getPort();
        this.maxClientSendQueueSizes = maxClientSendQueueSizes;
        this.routingLayerMessageHandler = new MessageTypeHandler(this.serverDeviceId + " routing layer");
        this.applicationLayerMessageHandler = new MessageTypeHandler(this.serverDeviceId + " application layer");
        this.sandboxMessageHandler = new MessageTypeHandler(this.serverDeviceId + " sandbox layer");
        this.webSocketMessageHandler = new WebSocketMessageHandler(this.routingLayerMessageHandler);
        this.logTag = "ServerId: " + this.serverDeviceId;
        this.routingLayerMessageHandler.registerHandler(this);
        this.routingLayerMessageHandler.registerHandler(new TraceMessageHandler(this.serverDeviceId, this));
        this.routingLayerMessageHandler.registerHandler(new PingPongMessageHandler(this.serverDeviceId, this));
        this.asynchronousMessageSendQueue = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxSendQueueSize));
        this.wsServer = new WebSocketServer(this.address, this.port, serverConnectionSettings.getAllowedRegions(), this, StandardCharsets.UTF_8, trustStore, keyMgrFactory, true, requireClientCertificates, trafficStatisticsConsumer);
    }

    public void registerSandboxLayerHandler(Object messageHandler) {
        this.sandboxMessageHandler.registerHandler(messageHandler);
        this.clientsToSlavesMap.values().forEach(client -> client.registerHandler(this.sandboxMessageHandler));
    }

    @Override
    public void registerHandler(Object messageHandler) {
        this.applicationLayerMessageHandler.registerHandler(messageHandler);
        this.clientsToSlavesMap.values().forEach(client -> client.registerHandler(this.applicationLayerMessageHandler));
    }

    public void registerRoutingLayerHandler(Object messageHandler) {
        this.routingLayerMessageHandler.registerHandler(messageHandler);
        this.clientsToSlavesMap.values().forEach(client -> client.registerHandler(this.routingLayerMessageHandler));
    }

    public void setMasterServerChecker(Predicate<MasterPassport> masterServerChecker) {
        this.masterServerChecker = masterServerChecker;
    }

    public void setSlavesConnectionSettings(List<ServerConnectionSettings> slavesConnectionSettings) {
        this.stopClients();
        this.clientsToSlavesMap.clear();
        this.slavesConnectionSettingsMap.clear();
        for (ServerConnectionSettings slaveConfig : slavesConnectionSettings) {
            try {
                this.addSlave(slaveConfig);
            }
            catch (ClientConfigurationException e) {
                LOGGER.warn("Error adding slave {}", (Object)slaveConfig, (Object)e);
            }
        }
    }

    public AgentIdConflictHandler getConflictHandler() {
        return this.conflictHandler;
    }

    public void setConflictHandler(AgentIdConflictHandler conflictHandler) {
        this.conflictHandler = conflictHandler;
    }

    private void stopClients() {
        this.clientsToSlavesMap.values().forEach(client -> {
            try {
                client.shutdown();
            }
            catch (Exception e) {
                LOGGER.debug("", e);
            }
        });
    }

    public Client addSlave(ServerConnectionSettings slaveConfig) throws ClientConfigurationException {
        Client client = new Client(this.serverDeviceId, Collections.singletonList(slaveConfig.getAddress()), slaveConfig.getPort(), 30000, slaveConfig.isAllowUntrustedCertificates(), slaveConfig.isUseWss(), this.trustStore, this.keyMgrFactory, this.maxClientSendQueueSizes, true);
        client.registerConsumers(this.routingLayerMessageHandler);
        client.addNettyChannelStateListener(this);
        this.clientsToSlavesMap.put(slaveConfig.getDeviceId(), client);
        this.slavesConnectionSettingsMap.put(slaveConfig.getDeviceId(), slaveConfig);
        LOGGER.info("Slave added. {}", (Object)slaveConfig);
        return client;
    }

    public void removeSlave(ServerConnectionSettings slaveConfig) {
        Client client1 = this.clientsToSlavesMap.get(slaveConfig.getDeviceId());
        if (client1 != null) {
            client1.shutdown();
        }
        this.clientsToSlavesMap.remove(slaveConfig.getDeviceId());
        this.slavesConnectionSettingsMap.remove(slaveConfig.getDeviceId());
        LOGGER.info("Slave removed. {}", (Object)slaveConfig);
    }

    public List<ServerConnectionSettings> getSlavesConnectionSettings() {
        return new ArrayList<ServerConnectionSettings>(this.slavesConnectionSettingsMap.values());
    }

    @Override
    public void registerMessageTypes(Map<Integer, Class<?>> messageTypeIdToClassMap) throws MessageTypeRegistrationException {
        MessageTypesRepository.getInstance().registerMessageTypes(messageTypeIdToClassMap);
    }

    public void start() throws WebSocketInitializationException, InterruptedException {
        this.wsServer.runServer();
        Runtime.getRuntime().addShutdownHook(new Thread(this::onShutDown));
        LOGGER.info("WebServer started. PORT: {}", (Object)this.port);
        this.clientsToSlavesMap.values().forEach(client -> {
            LOGGER.info("Starting client: {}", client);
            client.start();
        });
    }

    public void shutdown() {
        this.onShutDown();
    }

    public void shutdownNow() {
        try {
            this.stopClients();
            if (this.wsServer != null) {
                this.wsServer.shutdownNow();
            }
            if (this.asynchronousMessageSendQueue != null) {
                this.asynchronousMessageSendQueue.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.debug("wsServer", e);
            Thread.currentThread().interrupt();
        }
    }

    private void onShutDown() {
        LOGGER.info("Shutting down server " + this.serverDeviceId);
        this.stopClients();
        if (this.wsServer != null) {
            this.wsServer.shutdownGracefully();
        }
        if (this.asynchronousMessageSendQueue != null) {
            this.asynchronousMessageSendQueue.shutdown();
        }
    }

    @Override
    public void connectionOpened(Channel channel) {
        if (this.incomingConnectionVerifier != null && !this.incomingConnectionVerifier.connectionAccepted(channel)) {
            LOGGER.warn("Unauthorized connection {} has been closed.", (Object)channel);
            channel.close();
        }
        this.channelToConnectedTimestampMap.put(channel, System.currentTimeMillis());
    }

    @Override
    public void handshakeFinished(Channel channel) {
        channel.pipeline().addLast(this.webSocketMessageHandler);
    }

    @Override
    public void connectionClosed(Channel channel) {
        if (channel != null) {
            try {
                channel.close();
                this.channelClosed(channel);
            }
            catch (Exception e) {
                LOGGER.debug("", e);
            }
        }
    }

    @MessageHandlerMethod
    public void handleHelloMessage(HelloMsg helloMsg, Channel channel) {
        this.channelToConnectedTimestampMap.remove(channel);
        String clientId = helloMsg.getSource();
        if (helloMsg.isMaster()) {
            this.processHelloFromMasterServer(channel, helloMsg);
        } else {
            ServerConnectionSettings settingsFound = this.slavesConnectionSettingsMap.get(clientId);
            if (settingsFound != null) {
                this.processHelloFromSlaveServer(channel, clientId);
            } else {
                this.processHelloFromAgent(channel, clientId);
            }
        }
    }

    private void processHelloFromMasterServer(Channel channel, HelloMsg helloMsg) {
        String clientId = helloMsg.getSource();
        if (this.masterServerChecker.test(new MasterPassport(clientId, this.getRemoteAddress(channel), null))) {
            this.allowAppLayerAccess(channel, true);
            this.routingTable.addMappingMaster(clientId, channel);
            LOGGER.debug(RECEIVED_HELLO_MSG_LOG, (Object)clientId, (Object)channel.remoteAddress());
            HelloMsg helloBackMsg = new HelloMsg(this.serverDeviceId);
            this.sendMessageViaChannel(helloBackMsg, channel);
            this.requestKnownServers(clientId);
            this.masterConnectivityListeners.forEach(l -> l.masterConnected(clientId));
        } else {
            this.allowAppLayerAccess(channel, false);
            ConnectionRejectedMsg rejectedMsg = new ConnectionRejectedMsg(clientId, helloMsg.getOperationId(), 4, "Master not authorized");
            this.sendMessageViaChannel(rejectedMsg, channel);
            try {
                channel.close().sync();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Could not force close connection for unauthorized master {}", (Object)clientId, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void processHelloFromSlaveServer(Channel channel, String clientId) {
        this.allowAppLayerAccess(channel, true);
        this.routingTable.addMappingSlave(clientId, channel);
        LOGGER.debug(RECEIVED_HELLO_MSG_LOG, (Object)clientId, (Object)channel.remoteAddress());
        this.requestKnownServers(clientId);
        this.slaveConnectivityListeners.forEach(l -> l.slaveConnected(clientId));
    }

    private void processHelloFromAgent(Channel channel, String clientId) {
        Certificate[] certificates = ChannelUtils.getPeerCertificates(channel);
        boolean allowAppLayerAccess = this.clientVerifier == null || this.clientVerifier.verify(clientId, certificates);
        this.allowAppLayerAccess(channel, allowAppLayerAccess);
        Optional<Channel> existingChannel = this.routingTable.getChannelDevice(clientId);
        boolean newChannel = true;
        if (existingChannel.isPresent()) {
            if (existingChannel.get().equals(channel)) {
                LOGGER.debug("Received HelloMsg from {}, remoteAddr: {} duplicate", (Object)clientId, (Object)channel.remoteAddress());
                newChannel = false;
            } else {
                Channel oldChannel = existingChannel.get();
                try {
                    this.routingTable.removeMapping(oldChannel);
                    this.routingTable.removeMapping(clientId);
                    this.conflictHandler.kickedByAnotherDevice(clientId, oldChannel, channel);
                    LOGGER.debug("Closed previous channel {} from device {}", (Object)oldChannel, (Object)clientId);
                }
                catch (Exception e) {
                    LOGGER.debug("Error by closing previous channel {} from device {}", oldChannel, clientId, e);
                }
            }
        }
        if (newChannel) {
            this.routingTable.addMappingDevice(clientId, channel);
            LOGGER.debug(RECEIVED_HELLO_MSG_LOG, (Object)clientId, (Object)channel.remoteAddress());
            HelloMsg helloBackMsg = new HelloMsg(this.serverDeviceId);
            this.sendMessageViaChannel(helloBackMsg, channel);
            this.deviceConnectivityListeners.forEach(l -> l.deviceConnected(clientId, certificates));
        }
    }

    private void allowAppLayerAccess(Channel channel, boolean allowAppLayerAccess) {
        channel.attr(ALLOW_APP_LAYER_ACCESS_ATTRIBUTE).set(allowAppLayerAccess);
    }

    private void requestKnownServers(String clientId) {
        this.sendMessageServer(new ReachableServersRequestMsg(clientId));
    }

    @MessageHandlerMethod
    public void handleReachableServersRequestMessage(ReachableServersRequestMsg msg, Channel channel) {
        List<String> result = this.calculateReachableServers(msg.getSource(), channel);
        ReachableServersResponseMsg responseMsg = new ReachableServersResponseMsg(msg.getSource(), msg.getOperationId(), result);
        this.sendMessageServer(responseMsg);
    }

    private List<String> calculateReachableServers(String sourceDeviceId, Channel sourceChannel) {
        List reachableMasterIds = this.routingTable.getMasterIds().stream().filter(id -> !id.equals(sourceDeviceId)).filter(id -> !id.equals(this.serverDeviceId)).collect(Collectors.toList());
        List reachableSlaveIds = this.routingTable.getSlaveIds().stream().filter(id -> !id.equals(sourceDeviceId)).filter(id -> !id.equals(this.serverDeviceId)).collect(Collectors.toList());
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(reachableMasterIds);
        result.addAll(reachableSlaveIds);
        List<String> remoteIds = this.routingTable.getRemoteIds();
        for (String remoteId : remoteIds) {
            Optional<Channel> remoteDeviceChannel = this.routingTable.getRemoteDeviceChannel(remoteId);
            if (!remoteDeviceChannel.isPresent() || remoteDeviceChannel.get().equals(sourceChannel)) continue;
            result.add(remoteId);
        }
        return result;
    }

    @MessageHandlerMethod
    public void handleReachableServersResponseMessage(ReachableServersResponseMsg msg, Channel channel) {
        HashSet<String> remoteIds = new HashSet<String>(msg.getServerIds());
        remoteIds.removeAll(this.routingTable.getSlaveIds());
        remoteIds.removeAll(this.routingTable.getMasterIds());
        remoteIds.remove(this.serverDeviceId);
        boolean addedToOthers = false;
        for (String id : remoteIds) {
            Optional<Channel> foundChannel = this.routingTable.getChannelOtherServers(id);
            if (foundChannel.isPresent() && foundChannel.get().equals(channel)) continue;
            this.routingTable.addMappingRemoteServer(id, channel);
            addedToOthers = true;
        }
        String sourceDeviceId = msg.getSource();
        if (addedToOthers || this.routingTable.getSlaveIds().contains(sourceDeviceId) || this.routingTable.getMasterIds().contains(sourceDeviceId)) {
            this.forwardReachableServersToOtherServers(sourceDeviceId, msg.getOperationId());
        }
    }

    private void forwardReachableServersToOtherServers(String sourceDeviceId, String operationId) {
        List reachableMasterIds = this.routingTable.getMasterIds().stream().filter(id -> !id.equals(sourceDeviceId) && !id.equals(this.serverDeviceId)).collect(Collectors.toList());
        List reachableSlaveIds = this.routingTable.getSlaveIds().stream().filter(id -> !id.equals(sourceDeviceId) && !id.equals(this.serverDeviceId)).collect(Collectors.toList());
        Stream.of(reachableMasterIds, reachableSlaveIds).flatMap(Collection::stream).forEach(serverId -> {
            Optional<Channel> channelOtherServers = this.routingTable.getChannelOtherServers((String)serverId);
            if (channelOtherServers.isPresent()) {
                List<String> result = this.calculateReachableServers((String)serverId, channelOtherServers.get());
                ReachableServersResponseMsg responseMsg = new ReachableServersResponseMsg((String)serverId, operationId, result);
                this.sendMessageServer(responseMsg);
            }
        });
    }

    public String getRemoteAddress(Channel channel) {
        return channel.remoteAddress().toString().replace("/", "").replaceAll(":\\d+", "");
    }

    private String getClientAddress(Channel channel) {
        String result = "";
        SocketAddress socketAddress = channel.remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            result = inetSocketAddress.getAddress().getHostAddress();
        }
        return result;
    }

    @Override
    public Optional<ChannelFuture> sendMessageNow(MessageBase messageBase) {
        Optional<Channel> channel;
        ChannelFuture channelFuture = null;
        if (messageBase.getSource() == null) {
            messageBase.setSource(this.serverDeviceId);
        }
        if ((channel = this.getChannelForDevice(messageBase.getTarget())).isPresent()) {
            channelFuture = this.sendMessageViaChannel(messageBase, channel.get());
        } else {
            channel = this.getChannelForServer(messageBase.getTarget());
            if (channel.isPresent()) {
                channelFuture = this.sendMessageViaChannel(messageBase, channel.get());
            } else {
                this.handleCaseChannelNotFound(messageBase);
            }
        }
        return Optional.ofNullable(channelFuture);
    }

    private ChannelFuture sendMessageViaChannel(MessageBase msg, Channel channel) {
        ChannelFuture channelFuture;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(SENDING_MESSAGE_LOG, this.logTag, this.logTag, msg);
        }
        if ((channelFuture = channel.writeAndFlush(msg)) != null) {
            this.addFutureListenerForErrors(msg, channelFuture);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("sent op: {}", (Object)msg.getOperationId());
        }
        return channelFuture;
    }

    private void handleCaseChannelNotFound(MessageBase messageBase) {
        if (messageBase instanceof MessageProcessingFailedMsg) {
            LOGGER.warn("{} | Channel for server {} not found. Message dropped {}", this.logTag, messageBase.getTarget(), messageBase);
        } else {
            LOGGER.warn("{} | Channel for server {} not found. Message {}. Sending MessageProcessingFailedMsg back", this.logTag, messageBase.getTarget(), messageBase);
            MessageProcessingFailedMsg msg = new MessageProcessingFailedMsg(messageBase.getSource(), messageBase.getOperationId(), 1, "Could not find route " + this.serverDeviceId + " to " + messageBase.getTarget(), messageBase.toString());
            msg.setOriginalTargetId(messageBase.getTarget());
            if (this.serverDeviceId.equals(msg.getTarget())) {
                msg.setSource(this.serverDeviceId);
                this.applicationLayerMessageHandler.handle(msg, null);
            } else {
                this.sendMessageNow(msg);
            }
        }
    }

    @Override
    public Optional<ChannelFuture> sendMessageServerNow(MessageBase messageBase) {
        Optional<Channel> channel;
        ChannelFuture channelFuture = null;
        if (messageBase.getSource() == null) {
            messageBase.setSource(this.serverDeviceId);
        }
        if ((channel = this.getChannelForServer(messageBase.getTarget())).isPresent()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(SENDING_MESSAGE_LOG, (Object)this.logTag, (Object)messageBase);
            }
            channelFuture = this.sendMessageViaChannel(messageBase, channel.get());
        } else {
            this.handleCaseChannelNotFound(messageBase);
        }
        return Optional.ofNullable(channelFuture);
    }

    private void addFutureListenerForErrors(MessageBase messageBase, ChannelFuture channelFuture) {
        channelFuture.addListener(future -> {
            block9: {
                try {
                    if (!future.isCancelled() && (!future.isDone() || future.isSuccess())) break block9;
                    try {
                        if (future.isDone() && future.get() instanceof Exception) {
                            Exception exception = (Exception)future.get();
                            LOGGER.warn("{} | Could not send message {}. Sending MessageProcessingFailedMsg back for {}", this.logTag, messageBase.getTarget(), messageBase, exception);
                        } else {
                            LOGGER.warn("{} | Could not send message {}. Sending MessageProcessingFailedMsg back for {}", this.logTag, messageBase.getTarget(), messageBase);
                        }
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (ExecutionException e) {
                        LOGGER.warn("{} | Could not send message {} to {}. Ex: {} ", this.logTag, messageBase.getTarget(), messageBase, e.getMessage());
                    }
                    MessageProcessingFailedMsg msg = new MessageProcessingFailedMsg(messageBase.getSource(), messageBase.getOperationId(), 2, "Send failed from " + this.serverDeviceId + " to " + messageBase.getTarget(), messageBase.toString());
                    if (this.serverDeviceId.equals(msg.getTarget())) {
                        msg.setSource(this.serverDeviceId);
                        this.applicationLayerMessageHandler.handle(msg, null);
                    } else {
                        this.sendMessageNow(msg);
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Error listener failed to process error on msg: {}", (Object)messageBase, (Object)e);
                }
            }
        });
    }

    @Override
    public void sendMessage(MessageBase message) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("enqueue {}", (Object)message);
        }
        this.asynchronousMessageSendQueue.submit(() -> this.sendMessageNow(message));
    }

    @Override
    public void sendMessageServer(MessageBase message) {
        this.asynchronousMessageSendQueue.submit(() -> this.sendMessageServerNow(message));
    }

    @Override
    public void executeInDeviceWorkerThread(String deviceId, Runnable runnable) {
        this.routingTable.getChannel(deviceId).ifPresent(channel -> channel.eventLoop().schedule(runnable, 0L, TimeUnit.SECONDS));
    }

    private Optional<Channel> getChannelForDevice(String targetDeviceId) {
        Optional<Channel> channel = this.routingTable.getChannelDevice(targetDeviceId);
        if (!channel.isPresent()) {
            String responsibleServerId = null;
            if (this.serverDevicesRegistry != null && (responsibleServerId = this.serverDevicesRegistry.getResponsibleServer(targetDeviceId)) != null) {
                channel = this.routingTable.getChannelOtherServers(responsibleServerId);
            }
        }
        return channel;
    }

    public Optional<Channel> getChannelForServer(String serverId) {
        return this.routingTable.getChannelOtherServers(serverId);
    }

    public void addDeviceConnectivityListener(DeviceConnectivityListener listener) {
        this.deviceConnectivityListeners.add(listener);
    }

    public void removeDeviceConnectivityListener(DeviceConnectivityListener listener) {
        this.deviceConnectivityListeners.remove(listener);
    }

    public void addMasterConnectivityListener(MasterConnectivityListener listener) {
        this.masterConnectivityListeners.add(listener);
    }

    public void removeMasterConnectivityListener(MasterConnectivityListener listener) {
        this.masterConnectivityListeners.remove(listener);
    }

    public void addSlaveConnectivityListener(SlaveConnectivityListener listener) {
        this.slaveConnectivityListeners.add(listener);
    }

    public void removeSlaveConnectivityListener(SlaveConnectivityListener listener) {
        this.slaveConnectivityListeners.remove(listener);
    }

    @Override
    public void channelActive(Channel channel) {
        LOGGER.debug("Channel active {}", (Object)channel);
    }

    @Override
    public void channelClosed(Channel channel) {
        this.channelToConnectedTimestampMap.remove(channel);
        if (this.incomingConnectionVerifier != null && !this.incomingConnectionVerifier.connectionAccepted(channel)) {
            return;
        }
        LOGGER.debug("Channel closed {}", (Object)channel);
        Optional<String> masterId = this.routingTable.getMasterId(channel);
        if (masterId.isPresent()) {
            this.masterConnectivityListeners.forEach(l -> l.masterDisconnected((String)masterId.get()));
            this.notifyOtherServersServerLeftNetwork(masterId.get(), channel);
        } else {
            Optional<String> slaveId = this.routingTable.getSlaveId(channel);
            if (slaveId.isPresent()) {
                this.slaveConnectivityListeners.forEach(l -> l.slaveDisconnected((String)slaveId.get()));
                this.notifyOtherServersServerLeftNetwork(slaveId.get(), channel);
            } else {
                Optional<String> deviceId = this.routingTable.getDeviceId(channel);
                if (deviceId.isPresent()) {
                    this.deviceConnectivityListeners.forEach(l -> l.deviceDisconnected((String)deviceId.get()));
                } else {
                    LOGGER.debug("Closed channel without associated ID {}", (Object)channel);
                }
            }
        }
        this.routingTable.removeMapping(channel);
    }

    private void notifyOtherServersServerLeftNetwork(String offlineServerId, Channel channel) {
        List<String> affectedDevices = this.routingTable.getRemoteDevices(channel);
        affectedDevices.add(offlineServerId);
        Stream.of(this.routingTable.getMasterIds(), this.routingTable.getSlaveIds()).flatMap(Collection::stream).filter(id -> !id.equals(offlineServerId)).forEach(id -> this.sendMessageServer(new ServersLeftNetworkMsg((String)id, affectedDevices)));
    }

    @MessageHandlerMethod
    public void handleServerLeftNetworkMessage(ServersLeftNetworkMsg msg, Channel channel) {
        List<String> affectedDevices = msg.getOfflineServerIds();
        affectedDevices.forEach(this.routingTable::removeMapping);
        Stream.of(this.routingTable.getMasterIds(), this.routingTable.getSlaveIds()).flatMap(Collection::stream).filter(id -> !id.equals(msg.getSource())).forEach(id -> this.sendMessageServer(new ServersLeftNetworkMsg((String)id, affectedDevices, msg.getOperationId())));
    }

    @MessageHandlerMethod
    public void handleProxyMessages(MessageBase msg, Channel channel) {
        String target = msg.getTarget();
        if (!target.isEmpty()) {
            boolean messageForThisServer = this.serverDeviceId.equals(target);
            boolean routingMessage = this.routingLayerMessageHandler.isMessageHandledExplicitly(msg);
            boolean messageHandled = false;
            if (messageForThisServer) {
                messageHandled = this.handleMessageForThisServer(msg, channel);
            }
            if (!routingMessage && messageForThisServer && !messageHandled && (long)msg.getMessageTypeId() != this.messageProcessingFailedMsgId) {
                LOGGER.debug("{} | Application message handler not found Message: Sending MessageProcessingFailedMsg back for {}", (Object)this.logTag, (Object)msg);
                MessageProcessingFailedMsg responseMessage = new MessageProcessingFailedMsg(msg.getSource(), msg.getOperationId(), 3, "Could not find message handler on " + this.serverDeviceId, msg.toString());
                responseMessage.setSource(this.serverDeviceId);
                this.sendMessageViaChannel(responseMessage, channel);
            }
            if (!routingMessage && !messageForThisServer) {
                this.sendMessageServer(msg);
            }
        }
    }

    private boolean canAccessApplicationLayer(Channel channel) {
        Attribute<Boolean> attr = channel.attr(ALLOW_APP_LAYER_ACCESS_ATTRIBUTE);
        return Boolean.TRUE.equals(attr.get());
    }

    private boolean handleMessageForThisServer(MessageBase msg, Channel channel) {
        boolean messageHandled = this.clientVerifier == null ? this.applicationLayerMessageHandler.handle(msg, channel) : (this.canAccessApplicationLayer(channel) ? this.applicationLayerMessageHandler.handle(msg, channel) : this.sandboxMessageHandler.handle(msg, channel));
        return messageHandled;
    }

    public String getServerDeviceId() {
        return this.serverDeviceId;
    }

    @Override
    public void sendTraceMessage(String deviceId, String operationId) {
        TraceRouteMsg traceMsg = new TraceRouteMsg(deviceId, operationId);
        traceMsg.addHop(this.serverDeviceId);
        this.sendMessage(traceMsg);
    }

    public void sendTraceMessage(String deviceId) {
        this.sendTraceMessage(deviceId, UUID.randomUUID().toString());
    }

    @Override
    public void sendPingMessage(String deviceId, String operationId) {
        PingMsg message = new PingMsg(deviceId, operationId);
        message.setPingInitiatedTimestamp(System.currentTimeMillis());
        this.sendMessageNow(message);
    }

    public void disconnectDevice(String deviceId) {
        Channel channel = this.routingTable.getChannel(deviceId).orElse(this.getChannelForServer(deviceId).orElse(null));
        if (channel == null) {
            LOGGER.debug("Could not force close connection for device {}, channel not found.", (Object)deviceId);
        } else {
            try {
                channel.close();
            }
            catch (Exception e) {
                LOGGER.debug("Could not force close connection for device. {}", (Object)deviceId, (Object)e);
            }
        }
    }

    public ServerDevicesRegistry getServerDevicesRegistry() {
        return this.serverDevicesRegistry;
    }

    public void setServerDevicesRegistry(ServerDevicesRegistry serverDevicesRegistry) {
        this.serverDevicesRegistry = serverDevicesRegistry;
    }

    public String getRoutingTableDump() {
        return this.routingTable.getDump();
    }

    @Override
    public String getCurrentDeviceId() {
        return this.getServerDeviceId();
    }

    public void setClientVerifier(ClientVerifier clientVerifier) {
        this.clientVerifier = clientVerifier;
    }

    public String getAddress() {
        return this.address;
    }

    public void setIncomingConnectionVerifier(IncomingConnectionVerifier verifier) {
        this.incomingConnectionVerifier = verifier;
    }

    public List<String> getSandboxedDeviceIds() {
        ArrayList<String> sandboxedIds = new ArrayList<String>();
        for (String deviceId : this.routingTable.getDeviceIds()) {
            Channel channel;
            Optional<Channel> channelForDevice = this.routingTable.getChannelDevice(deviceId);
            if (!channelForDevice.isPresent() || !(channel = channelForDevice.get()).hasAttr(ALLOW_APP_LAYER_ACCESS_ATTRIBUTE) || this.canAccessApplicationLayer(channel)) continue;
            sandboxedIds.add(deviceId);
        }
        return sandboxedIds;
    }

    public ConcurrentHashMap<Channel, Long> getChannelToConnectedTimestampMap() {
        return this.channelToConnectedTimestampMap;
    }
}

