/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.server;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ServerConnectionSettings {
    private String address;
    private int port;
    private String deviceId;
    private boolean useWss = true;
    private boolean allowUntrustedCertificates = true;
    private Set<String> allowedRegions;

    public ServerConnectionSettings(String deviceId, String address, int port) {
        this.address = address;
        this.port = port;
        this.deviceId = deviceId;
        this.allowedRegions = new HashSet<String>();
        this.allowedRegions.add("central");
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public boolean isUseWss() {
        return this.useWss;
    }

    public void setUseWss(boolean useWss) {
        this.useWss = useWss;
    }

    public boolean isAllowUntrustedCertificates() {
        return this.allowUntrustedCertificates;
    }

    public void setAllowUntrustedCertificates(boolean allowUntrustedCertificates) {
        this.allowUntrustedCertificates = allowUntrustedCertificates;
    }

    public Set<String> getAllowedRegions() {
        return this.allowedRegions;
    }

    public void setAllowedRegions(Set<String> allowedRegions) {
        this.allowedRegions = allowedRegions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConnectionSettings that = (ServerConnectionSettings)o;
        return this.port == that.port && Objects.equals(this.address, that.address);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.port);
    }

    public String toString() {
        return "ServerConnectionSettings{address='" + this.address + '\'' + ", port=" + this.port + ", deviceId='" + this.deviceId + '\'' + ", useWss=" + this.useWss + ", allowUntrustedCertificates=" + this.allowUntrustedCertificates + ", allowedRegions=" + this.allowedRegions + '}';
    }
}

