/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.server;

import com.boom.netty.client.Client;
import com.boom.netty.client.ClientConfiguration;
import com.boom.netty.client.ClientConfigurationException;
import com.boom.netty.common.DeviceConnectivityListener;
import com.boom.netty.server.Server;
import com.boom.netty.server.ServerConnectionSettings;
import com.boom.netty.ws.server.stats.TrafficStatistics;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.net.ssl.KeyManagerFactory;

public class TwoWayServer
extends Server {
    private Map<String, Client> deviceIdToClient = new ConcurrentHashMap<String, Client>();
    private EventLoopGroup eventLoopGroup;

    public TwoWayServer(ServerConnectionSettings serverConnectionSettings, KeyManagerFactory keyMgrFactory, KeyStore trustStore, boolean requireClientCertificates, int maxSendQueueSize, int maxClientSendQueueSizes, int threadCount, Consumer<TrafficStatistics> trafficStatisticsConsumer) {
        super(serverConnectionSettings, keyMgrFactory, trustStore, requireClientCertificates, maxSendQueueSize, maxClientSendQueueSizes, trafficStatisticsConsumer);
        this.eventLoopGroup = new NioEventLoopGroup(threadCount);
    }

    public void addClient(ClientConfiguration conf) throws ClientConfigurationException {
        Client client = new Client(this.getServerDeviceId(), conf.getAddresses(), conf.getPort(), conf.getConnectTimeoutMs(), conf.isAllowUntrustedCertificates(), conf.isUseWss(), conf.getTrustStore(), conf.getKeyManagerFactory(), this.eventLoopGroup, 0, conf.isMaster());
        Client removed = this.deviceIdToClient.remove(conf.getDeviceId());
        if (removed != null) {
            removed.shutdown();
        }
        this.deviceIdToClient.put(conf.getDeviceId(), client);
        client.registerHandler(this);
        client.start();
    }

    @Override
    public void disconnectDevice(String deviceId) {
        super.disconnectDevice(deviceId);
        this.removeClient(deviceId);
    }

    public void removeClient(String deviceId) {
        Client removedClient = this.deviceIdToClient.remove(deviceId);
        if (removedClient != null) {
            removedClient.shutdown();
        }
    }

    @Override
    public void addDeviceConnectivityListener(DeviceConnectivityListener listener) {
        super.addDeviceConnectivityListener(listener);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.deviceIdToClient.values().forEach(Client::shutdown);
        this.deviceIdToClient.clear();
    }

    @Override
    public void shutdownNow() {
        super.shutdownNow();
        this.deviceIdToClient.values().forEach(Client::shutdown);
        this.deviceIdToClient.clear();
    }
}

