/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.service.events;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class PerfAgt {
    public static final String TYPE_VARCHAR = "VARCHAR";
    public static final String TYPE_DOUBLE = "DOUBLE";
    public static final String TYPE_BIGINT = "BIGINT";
    public static final String TIME = "_TIME";
    public static final String TIME_AS_FIELD = "_TIME/*BIGINT|20*/";
    private final String perfClassName;
    private final long time;
    private final Map<String, PerfValue> recordSet = new LinkedHashMap<String, PerfValue>();

    public PerfAgt(String className, long time) {
        this.perfClassName = className;
        this.time = time;
    }

    public String getPerfClassName() {
        return this.perfClassName;
    }

    public long getTime() {
        return this.time;
    }

    public Map<String, PerfValue> getRecordSet() {
        return this.recordSet;
    }

    public String toString() {
        if (this.recordSet == null || this.recordSet.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TIME_AS_FIELD).append(',');
        Iterator<PerfValue> it = this.recordSet.values().iterator();
        while (it.hasNext()) {
            sb.append(it.next().getFieldAndTypeAsString());
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        sb.append(" ");
        sb.append(this.getTime());
        sb.append(" \"IPerfMetric\" ");
        sb.append(this.getPerfClassName());
        for (PerfValue pv : this.recordSet.values()) {
            if (TYPE_VARCHAR.equals(pv.type)) {
                sb.append(" \"").append(pv.getValue()).append("\"");
                continue;
            }
            sb.append(" ").append(pv.getValue());
        }
        return sb.toString();
    }

    public static class PerfValue {
        private String fieldName;
        private String type;
        private int length;
        private String value;

        public PerfValue() {
        }

        public PerfValue(String fieldName, String type, int length, String value) {
            this.fieldName = fieldName;
            this.type = type;
            this.length = length;
            this.value = value;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String getFieldAndTypeAsString() {
            return this.getFieldName() + "/*" + this.getType() + "|" + this.getLength() + "*/";
        }
    }
}

