/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.service.file;

import com.boom.netty.digest.GeneralDigest;
import java.nio.file.Path;

public class FileDigestCached {
    public final GeneralDigest digest;
    public final long fileSize;
    public final long fileLastModTime;
    public final long createdMs = System.currentTimeMillis();

    public FileDigestCached(GeneralDigest digest, long fileSize, long fileLastModTime) throws IllegalArgumentException {
        if (digest == null) {
            throw new IllegalArgumentException("Digest can't be null");
        }
        this.digest = digest;
        this.fileSize = fileSize;
        this.fileLastModTime = fileLastModTime;
    }

    public GeneralDigest getSHA256(Path path) {
        if (this.fileSize == path.toFile().length() && this.fileLastModTime == path.toFile().lastModified()) {
            return this.digest;
        }
        return null;
    }
}

