/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.service.file;

import com.boom.netty.common.DataChunkFinishedListener;
import com.boom.netty.common.MessageSender;
import com.boom.netty.digest.DigestManager;
import com.boom.netty.digest.FileDigestInfo;
import com.boom.netty.digest.GeneralDigest;
import com.boom.netty.service.file.DownloadFileResult;
import com.boom.netty.service.file.FileChunkMismatchException;
import com.boom.netty.service.file.FileTransfer;
import com.boom.netty.service.file.FileTransferPriorityManager;
import com.boom.netty.service.file.FileTransferState;
import com.boom.netty.service.file.FileUtils;
import com.boom.netty.service.file.OperationCompletion;
import com.boom.netty.service.file.msg.FileChunkMsg;
import com.boom.netty.service.file.msg.FileFooterMsg;
import com.boom.netty.service.file.msg.FileHeaderMsg;
import com.boom.netty.service.file.msg.FileTransferAckMsg;
import com.boom.netty.service.file.msg.FileTransferFailedMsg;
import com.boom.netty.service.file.msg.GetNextFileChunkMsg;
import com.boom.netty.service.file.msg.SendFileMsg;
import com.boom.netty.ws.mhf.annotation.MessageHandlerMethod;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReceiveHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileReceiveHandler.class);
    private int defaultBytesOverlap = 2;
    private String baseDir;
    private Map<String, FileTransfer> operationIdToFileTransferMap = new ConcurrentHashMap<String, FileTransfer>();
    private Map<String, Consumer<OperationCompletion>> operationIdToCompletionConsumerMap = new ConcurrentHashMap<String, Consumer<OperationCompletion>>();
    private FileTransferPriorityManager fileTransferPriorityManager = null;
    private DataChunkFinishedListener dataChunkFinishedListener;
    private ScheduledExecutorService timeoutCheckScheduler = null;
    private long ftTimeoutMillis;
    private long timeoutCheckCycleMillis;
    private MessageSender messageSender;
    private boolean isDevice = false;

    public FileReceiveHandler(MessageSender messageSender, String baseDir, long timeoutMillis, long timeoutCheckCycleMillis) {
        this(messageSender, baseDir, timeoutMillis, timeoutCheckCycleMillis, false);
    }

    public FileReceiveHandler(MessageSender messageSender, String baseDir, long timeoutMillis, long timeoutCheckCycleMillis, boolean manageFilePriorities) {
        this.messageSender = messageSender;
        this.baseDir = baseDir;
        this.ftTimeoutMillis = timeoutMillis;
        if (manageFilePriorities) {
            this.fileTransferPriorityManager = new FileTransferPriorityManager();
        }
        this.timeoutCheckCycleMillis = timeoutCheckCycleMillis;
        this.startTimeoutChecks();
    }

    public void downloadFile(String deviceId, String fileName, String relPathOnDevice, String downloadDirectory, int priority, String operationId, long fileSize, String fileHash) {
        this.downloadFile(deviceId, fileName, relPathOnDevice, downloadDirectory, operationId, priority, fileSize, fileHash, null);
    }

    public DownloadFileResult downloadFile(String deviceId, String fileName, String relPathOnDevice, String downloadDirectory, String operationId, int priority, long fileSize, String fileHash, Consumer<OperationCompletion> completionConsumer) {
        return this.downloadFile(deviceId, fileName, relPathOnDevice, downloadDirectory, operationId, priority, fileSize, fileHash, FileTransfer.DEFAULT_CHUNK_SIZE, completionConsumer);
    }

    public DownloadFileResult downloadFile(String deviceId, String fileName, String relPathOnDevice, String downloadDirectory, String operationId, int priority, long fileSize, String fileHash, int chunkSize, Consumer<OperationCompletion> completionConsumer) {
        File deviceDir = this.getDeviceDir(deviceId, this.baseDir, downloadDirectory);
        if (!deviceDir.exists()) {
            deviceDir.mkdirs();
        }
        long offset = 0L;
        try {
            if (completionConsumer != null) {
                this.operationIdToCompletionConsumerMap.put(operationId, completionConsumer);
            }
            FileDigestInfo info = this.getFileDigestInfo(deviceDir, fileName, "SHA-256", fileHash, fileSize);
            GeneralDigest digest = info.getDigest();
            fileName = info.getFileName();
            offset = info.getOffset();
            File targetFile = new File(deviceDir, fileName);
            FileTransfer transfer = new FileTransfer(targetFile, deviceId, operationId, false, this.defaultBytesOverlap, offset);
            transfer.setPriority(priority);
            transfer.setDigest(digest);
            transfer.setFileSize(fileSize);
            transfer.setFileHash(fileHash);
            transfer.setChunkSize(chunkSize);
            Optional<FileTransfer> previousFTForSameFile = this.findFileTransferByFileNameAndDeviceId(operationId, deviceId, targetFile.toPath());
            if (previousFTForSameFile.isPresent()) {
                FileTransfer previousFT = previousFTForSameFile.get();
                FileTransferFailedMsg ackMsg = new FileTransferFailedMsg(previousFT.getDeviceId(), previousFT.getOperationId(), 268, "Canceled due to new file transfer. New operationId=" + operationId);
                this.messageSender.sendMessage(ackMsg);
                this.dropFileTransfer(previousFT.getDeviceId(), previousFT.getOperationId(), false, 268, "Another transfer for the same file is running.");
            }
            this.operationIdToFileTransferMap.put(transfer.getOperationId(), transfer);
            if (this.fileTransferPriorityManager != null) {
                this.fileTransferPriorityManager.addFileTransfer(deviceId, transfer);
            }
            if (this.messageSender != null) {
                SendFileMsg msg = new SendFileMsg(deviceId, operationId, relPathOnDevice, downloadDirectory, offset, this.defaultBytesOverlap);
                msg.setPriority(priority);
                this.messageSender.sendMessage(msg);
            }
        }
        catch (AlreadyDownloadedException e) {
            LOGGER.info("Skipping file transfer for {}", (Object)fileName);
            this.notifyCompletionConsumer(deviceId, operationId, true, 0, "Already downloaded");
            return new DownloadFileResult(true);
        }
        catch (Exception e) {
            LOGGER.warn("Could not prepare file transfer : {}, deviceId {}, operationId {}", fileName, deviceId, operationId, e);
            this.dropFileTransfer(deviceId, operationId, false, 261, "Could not prepare file transfer " + fileName + " " + e.getMessage());
        }
        return new DownloadFileResult(false);
    }

    public void cancelFileTransfer(String operationId) {
        FileTransfer fileTransfer = this.operationIdToFileTransferMap.get(operationId);
        if (fileTransfer != null) {
            LOGGER.info("File transfer has been canceled operationId {}", (Object)operationId);
            if (this.messageSender != null) {
                FileTransferFailedMsg ackMsg = new FileTransferFailedMsg(fileTransfer.getDeviceId(), operationId, 266, "Canceled");
                this.messageSender.sendMessage(ackMsg);
            }
            this.dropFileTransfer(fileTransfer.getDeviceId(), operationId, false, 266, "Canceled locally");
        }
    }

    @MessageHandlerMethod
    public void handle(FileTransferFailedMsg msg) {
        FileTransfer fileTransfer;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)msg);
        }
        if ((fileTransfer = this.operationIdToFileTransferMap.get(msg.getOperationId())) != null) {
            LOGGER.info("File transfer has been canceled operationId {}", (Object)msg.getOperationId());
            this.dropFileTransfer(fileTransfer.getDeviceId(), fileTransfer.getOperationId(), false, msg.getCode(), msg.getReason());
        }
    }

    @MessageHandlerMethod
    public void handle(FileHeaderMsg msg) {
        LOGGER.info("Received FileHeader operationId {}, fileName {}", (Object)msg.getOperationId(), (Object)msg.getFileName());
        try {
            if (this.isPathTraversalAttempt(msg.getSource(), msg.getFileName(), msg.getDirectory())) {
                LOGGER.error("Path traversal attempt operationId: {}, deviceId: {}, fileName: {}, dir: {}", msg.getOperationId(), msg.getSource(), msg.getFileName(), msg.getDirectory());
                FileTransferFailedMsg ackMsg = new FileTransferFailedMsg(msg.getSource(), msg.getOperationId(), 264, "Path traversal not supported");
                this.messageSender.sendMessage(ackMsg);
                this.dropFileTransfer(ackMsg.getTarget(), ackMsg.getOperationId(), false, ackMsg.getCode(), ackMsg.getReason());
            } else {
                FileTransfer transfer = this.createFileTransfer(msg);
                transfer.setProcessing(false);
                LOGGER.debug("FileTransfer started operationId {}. offset={}, size={}", msg.getOperationId(), transfer.getOffset(), transfer.getFileSize());
                if (this.fileTransferPriorityManager == null) {
                    transfer.setProcessing(true);
                    GetNextFileChunkMsg ackMsg = new GetNextFileChunkMsg(transfer.getDeviceId(), transfer.getOperationId(), transfer.getOffset(), transfer.getChunkSize(), transfer.getPriority());
                    this.messageSender.sendMessage(ackMsg);
                } else {
                    Optional<FileTransfer> topPriorityFileTransfer = this.fileTransferPriorityManager.getTopPriorityFileTransfer(transfer.getDeviceId());
                    if (topPriorityFileTransfer.isPresent()) {
                        FileTransfer topPrioTransfer = topPriorityFileTransfer.get();
                        if (transfer.equals(topPrioTransfer)) {
                            transfer.setProcessing(true);
                            GetNextFileChunkMsg ackMsg = new GetNextFileChunkMsg(topPrioTransfer.getDeviceId(), topPrioTransfer.getOperationId(), topPrioTransfer.getOffset(), topPrioTransfer.getChunkSize(), topPrioTransfer.getPriority());
                            this.messageSender.sendMessage(ackMsg);
                        } else {
                            LOGGER.debug("Skipping fileChunkRequest due to priority transfer : {}", (Object)topPrioTransfer.getOperationId());
                        }
                    }
                }
            }
        }
        catch (AlreadyDownloadedException e) {
            FileTransferAckMsg ackMsg = new FileTransferAckMsg(msg.getSource(), msg.getOperationId());
            this.messageSender.sendMessage(ackMsg);
            this.dropFileTransfer(ackMsg.getTarget(), ackMsg.getOperationId(), true, 0, "Already downloaded");
        }
        catch (Exception e) {
            LOGGER.warn("Could not open file {}", (Object)new File(this.baseDir, msg.getFileName()).getAbsolutePath(), (Object)e);
            FileTransferFailedMsg ackMsg = new FileTransferFailedMsg(msg.getSource(), msg.getOperationId(), 261, "Could not open file");
            this.messageSender.sendMessage(ackMsg);
            this.dropFileTransfer(ackMsg.getTarget(), ackMsg.getOperationId(), false, ackMsg.getCode(), ackMsg.getReason());
        }
    }

    private FileTransfer createFileTransfer(FileHeaderMsg msg) throws IOException, AlreadyDownloadedException {
        FileTransfer tr;
        File deviceDir = this.getDeviceDir(msg.getSource(), this.baseDir, msg.getDirectory());
        File targetFile = new File(deviceDir, msg.getFileName());
        Optional<FileTransfer> previousFTForSameFile = this.findFileTransferByFileNameAndDeviceId(msg.getOperationId(), msg.getSource(), targetFile.toPath());
        if (previousFTForSameFile.isPresent()) {
            FileTransfer previousFT = previousFTForSameFile.get();
            FileTransferFailedMsg ackMsg = new FileTransferFailedMsg(previousFT.getDeviceId(), previousFT.getOperationId(), 268, "Canceled due to new file transfer. New operationId=" + msg.getOperationId());
            this.messageSender.sendMessage(ackMsg);
            this.dropFileTransfer(previousFT.getDeviceId(), previousFT.getOperationId(), false, 268, "Another transfer for the same file is running.");
        }
        if (!deviceDir.exists()) {
            Files.createDirectories(deviceDir.toPath(), new FileAttribute[0]);
        }
        if ((tr = this.operationIdToFileTransferMap.get(msg.getOperationId())) == null) {
            FileDigestInfo digestInfo = this.getFileDigestInfo(deviceDir, msg.getFileName(), msg.getHashAlgorithm(), msg.getFileHash(), msg.getFileSize());
            FileTransfer transfer = new FileTransfer(targetFile, msg.getSource(), msg.getOperationId(), false, msg.getBytesOverlap(), digestInfo);
            transfer.setFileSize(msg.getFileSize());
            transfer.setFileHash(msg.getFileHash());
            this.operationIdToFileTransferMap.put(transfer.getOperationId(), transfer);
            if (this.fileTransferPriorityManager != null) {
                this.fileTransferPriorityManager.addFileTransfer(msg.getSource(), transfer);
            }
            return transfer;
        }
        return tr;
    }

    public File getDeviceDir(String deviceId, String baseDir, String downloadDirectory) {
        Path basePath = Paths.get(baseDir, new String[0]).toAbsolutePath();
        if (downloadDirectory == null) {
            return basePath.toFile();
        }
        if (this.isDevice() || downloadDirectory.contains(deviceId)) {
            Path ddPath = Paths.get(downloadDirectory, new String[0]).toAbsolutePath();
            if (ddPath.startsWith(baseDir)) {
                return ddPath.toFile();
            }
            return Paths.get(baseDir, downloadDirectory).toAbsolutePath().toFile();
        }
        Path ddPath = Paths.get(downloadDirectory, new String[0]).toAbsolutePath();
        if (ddPath.startsWith(baseDir)) {
            return Paths.get(downloadDirectory, deviceId).toAbsolutePath().toFile();
        }
        return Paths.get(baseDir, downloadDirectory, deviceId).toAbsolutePath().toFile();
    }

    private Optional<FileTransfer> findFileTransferByFileNameAndDeviceId(String operationId, String deviceId, Path path) {
        return this.operationIdToFileTransferMap.values().stream().filter(ft -> ft.getDeviceId().equals(deviceId)).filter(ft -> ft.getFile().toPath().equals(path)).filter(ft -> !ft.getOperationId().equals(operationId)).findAny();
    }

    private boolean checkFileTransfersForSameFile(FileTransfer transfer, FileHeaderMsg msg) {
        boolean shouldContinue = true;
        String directory = msg.getDirectory() == null ? "." : msg.getDirectory();
        Path targetFilePath = Paths.get(this.baseDir, directory, msg.getSource(), msg.getFileName());
        List transfersByFileName = this.operationIdToFileTransferMap.values().stream().filter(f -> this.isChildPath(f.getFile().toPath(), targetFilePath)).filter(f -> f.getDeviceId().equals(msg.getSource())).collect(Collectors.toList());
        if (transfer == null) {
            if (!transfersByFileName.isEmpty()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Another transfer for file : {} is running with operation Id(s) : {}", (Object)msg.getFileName(), (Object)transfersByFileName.stream().map(FileTransfer::getOperationId).collect(Collectors.joining(",")));
                }
                shouldContinue = false;
            }
        } else {
            transfersByFileName.remove(transfer);
            if (!transfersByFileName.isEmpty()) {
                FileTransfer highestOffsetTransfer = Collections.max(transfersByFileName, Comparator.comparing(FileTransfer::getOffset));
                if (!highestOffsetTransfer.getOperationId().equalsIgnoreCase(transfer.getOperationId())) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Another transfer for file : {} is running with operation Id(s) : {}", (Object)msg.getFileName(), (Object)transfersByFileName.stream().map(FileTransfer::getOperationId).collect(Collectors.joining(",")));
                    }
                    shouldContinue = false;
                    transfersByFileName.remove(highestOffsetTransfer);
                    this.dropFileTransfer(transfer.getDeviceId(), transfer.getOperationId(), false, 268, "Another transfer is running for file");
                }
                for (FileTransfer ft : transfersByFileName) {
                    this.dropFileTransfer(ft.getDeviceId(), ft.getOperationId(), false, 268, "Another transfer is running for file");
                }
            }
        }
        return shouldContinue;
    }

    private FileDigestInfo getFileDigestInfo(File deviceDir, String fileName, String algorithm, String hash, long expectedFileSize) throws IOException, AlreadyDownloadedException {
        File targetFile = new File(deviceDir, fileName);
        File tempFile = new File(deviceDir, fileName + ".tmp");
        File hashFile = new File(deviceDir, fileName + ".@@sha256");
        if (targetFile.exists() && this.isDownloadedFileMatching(targetFile, expectedFileSize, algorithm, hash)) {
            Files.deleteIfExists(tempFile.toPath());
            Files.deleteIfExists(hashFile.toPath());
            throw new AlreadyDownloadedException();
        }
        if (tempFile.exists()) {
            GeneralDigest resumedDigest = this.resumeDigest(hashFile, algorithm);
            if (resumedDigest == null) {
                GeneralDigest digest = FileUtils.getDigestOfFile(tempFile.toPath(), algorithm);
                return new FileDigestInfo(digest, digest.getByteCount(), fileName);
            }
            if (resumedDigest.getByteCount() == tempFile.length()) {
                return new FileDigestInfo(resumedDigest, resumedDigest.getByteCount(), fileName);
            }
            Files.delete(tempFile.toPath());
            Files.deleteIfExists(hashFile.toPath());
            return new FileDigestInfo(DigestManager.getDigest(algorithm), 0L, fileName);
        }
        Files.deleteIfExists(hashFile.toPath());
        return new FileDigestInfo(DigestManager.getDigest(algorithm), 0L, fileName);
    }

    private GeneralDigest resumeDigest(File hashFile, String algorithm) throws IOException {
        GeneralDigest digest = null;
        if (hashFile.exists() && ((digest = DigestManager.loadDigestFromFile(hashFile)) == null || !digest.getAlgorithmName().equals(algorithm))) {
            Files.deleteIfExists(hashFile.toPath());
            digest = null;
        }
        return digest;
    }

    private boolean isDownloadedFileMatching(File downloadedFile, long expectedFileSize, String algorithm, String hash) throws IOException {
        if (expectedFileSize == downloadedFile.length()) {
            GeneralDigest digest = FileUtils.getDigestOfFile(downloadedFile.toPath(), algorithm);
            return hash.equals(digest.copy().asString());
        }
        return false;
    }

    private boolean isPathTraversalAttempt(String deviceId, String fileName, String downloadDirectory) throws IOException {
        if (this.baseDir == null || this.baseDir.isEmpty()) {
            return false;
        }
        try {
            File deviceDir = this.getDeviceDir(deviceId, this.baseDir, downloadDirectory);
            File file = new File(deviceDir, fileName);
            String deviceDirPath = deviceDir.getCanonicalPath();
            String filePath = file.getCanonicalPath();
            File baseDirFile = new File(this.baseDir);
            String baseDirFilePath = baseDirFile.getCanonicalPath();
            LOGGER.trace("check traversal. basepath: {}, filepath: {}, deviceDirPath: {}", baseDirFilePath, filePath, deviceDirPath);
            return !filePath.startsWith(baseDirFilePath) || !filePath.startsWith(deviceDirPath);
        }
        catch (Exception e) {
            LOGGER.debug("check traversal failed {} {} {}", deviceId, fileName, downloadDirectory, e);
            return true;
        }
    }

    @MessageHandlerMethod
    public void handle(FileChunkMsg msg) {
        block15: {
            FileTransfer transfer;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("{}", (Object)msg);
            }
            if ((transfer = this.operationIdToFileTransferMap.get(msg.getOperationId())) == null) {
                LOGGER.warn("Could not find transfer for operationId {}", (Object)msg.getOperationId());
                FileTransferFailedMsg ackMsg = new FileTransferFailedMsg(msg.getSource(), msg.getOperationId(), 263, "Unknown operation id");
                this.messageSender.sendMessage(ackMsg);
            } else {
                try {
                    transfer.setProcessing(false);
                    if (transfer.getOffset() == msg.getOffset()) {
                        transfer.write(msg.getBytesPayload());
                        if (this.dataChunkFinishedListener != null) {
                            this.dataChunkFinishedListener.onDataChunkFinished(transfer.getDigest(), transfer.getFile().getAbsolutePath());
                        }
                        if (this.fileTransferPriorityManager == null) {
                            transfer.setProcessing(true);
                            int chunkSize = transfer.getChunkSize();
                            GetNextFileChunkMsg ackMsg = new GetNextFileChunkMsg(transfer.getDeviceId(), transfer.getOperationId(), transfer.getOffset(), chunkSize, transfer.getPriority());
                            this.messageSender.sendMessage(ackMsg);
                        } else {
                            Optional<FileTransfer> topPriorityFileTransfer = this.fileTransferPriorityManager.getTopPriorityFileTransfer(transfer.getDeviceId());
                            if (topPriorityFileTransfer.isPresent()) {
                                FileTransfer topPrioTransfer = topPriorityFileTransfer.get();
                                if (transfer.equals(topPrioTransfer)) {
                                    transfer.setProcessing(true);
                                    int chunkSize = topPrioTransfer.getChunkSize();
                                    GetNextFileChunkMsg ackMsg = new GetNextFileChunkMsg(topPrioTransfer.getDeviceId(), topPrioTransfer.getOperationId(), topPrioTransfer.getOffset(), chunkSize, topPrioTransfer.getPriority());
                                    this.messageSender.sendMessage(ackMsg);
                                } else {
                                    LOGGER.debug("Skipping fileChunkRequest due to priority transfer : {}", (Object)topPrioTransfer.getOperationId());
                                }
                            }
                        }
                        break block15;
                    }
                    if (msg.getOffset() + (long)transfer.getChunkSize() - (long)transfer.getBytesOverlap() == transfer.getOffset() || msg.getOffset() + (long)transfer.getChunkSize() == transfer.getOffset() && msg.getOffset() == 0L) {
                        LOGGER.debug("Chunk already processed skipping iteration for : {}, actual offset : {}, received offset : {}", msg.getOperationId(), transfer.getOffset(), msg.getOffset());
                        break block15;
                    }
                    throw new FileChunkMismatchException("Wrong offset");
                }
                catch (IOException e) {
                    LOGGER.warn("Could not write file {}, operationId {}", transfer.getFile() == null ? "null" : transfer.getFile().getAbsolutePath(), msg.getOperationId(), e);
                    FileTransferFailedMsg ackMsg1 = new FileTransferFailedMsg(msg.getSource(), msg.getOperationId(), 261, "Could not write file");
                    this.messageSender.sendMessage(ackMsg1);
                    this.dropFileTransfer(ackMsg1.getTarget(), ackMsg1.getOperationId(), false, ackMsg1.getCode(), ackMsg1.getReason());
                }
                catch (FileChunkMismatchException e) {
                    LOGGER.warn("Chunks do not match {} operationId {}", transfer.getFile() == null ? "null" : transfer.getFile().getAbsolutePath(), msg.getOperationId(), e);
                    FileTransferFailedMsg ackMsg1 = new FileTransferFailedMsg(msg.getSource(), msg.getOperationId(), 262, e.getMessage());
                    this.messageSender.sendMessage(ackMsg1);
                    this.dropFileTransfer(ackMsg1.getTarget(), ackMsg1.getOperationId(), false, ackMsg1.getCode(), ackMsg1.getReason());
                }
                catch (Exception e) {
                    LOGGER.warn("Could not process file chunk {}, operationId {}", transfer.getFile() == null ? "null" : transfer.getFile().getAbsolutePath(), msg.getOperationId(), e);
                    FileTransferFailedMsg ackMsg1 = new FileTransferFailedMsg(msg.getSource(), msg.getOperationId(), 261, "Could not write file");
                    this.messageSender.sendMessage(ackMsg1);
                    this.dropFileTransfer(ackMsg1.getTarget(), ackMsg1.getOperationId(), false, ackMsg1.getCode(), ackMsg1.getReason());
                }
            }
        }
    }

    @MessageHandlerMethod
    public void handle(FileFooterMsg msg) {
        FileTransfer transfer;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)msg);
        }
        if ((transfer = this.operationIdToFileTransferMap.get(msg.getOperationId())) != null) {
            FileTransferAckMsg ackMsg;
            try {
                transfer.close();
                long realFileSize = 0L;
                if (transfer.getTmpFileForWriting().exists() && transfer.getTmpFileForWriting().length() > 0L) {
                    realFileSize = transfer.getTmpFileForWriting().length();
                    LOGGER.debug("file size {} from temp file", (Object)realFileSize);
                } else if (transfer.getFile().exists()) {
                    realFileSize = transfer.getFile().length();
                    LOGGER.debug("file size {} from main file", (Object)realFileSize);
                } else {
                    LOGGER.debug("Neither file nor tmpFile exists {}", (Object)transfer.getFile());
                }
                long expectedFileSize = transfer.getFileSize();
                if (expectedFileSize == -1L || expectedFileSize == realFileSize) {
                    String expectedHash = transfer.getFileHash();
                    String fileHash = transfer.getDigest().asString();
                    if (expectedHash == null || expectedHash.isEmpty() || fileHash.equalsIgnoreCase(expectedHash)) {
                        ackMsg = new FileTransferAckMsg(transfer.getDeviceId(), msg.getOperationId());
                        transfer.markComplete(true);
                    } else {
                        String errorDescription = "Hash mismatch got " + fileHash + " expected " + expectedHash;
                        ackMsg = new FileTransferAckMsg(transfer.getDeviceId(), msg.getOperationId(), 258, errorDescription);
                        LOGGER.warn("{} operationId {}", (Object)errorDescription, (Object)transfer.getOperationId());
                        transfer.cleanupTempFiles(true);
                    }
                } else {
                    String errorDescription = "File size mismatch got " + realFileSize + " expected " + expectedFileSize;
                    ackMsg = new FileTransferAckMsg(transfer.getDeviceId(), msg.getOperationId(), 257, errorDescription);
                    LOGGER.warn("{} operationId {}", (Object)errorDescription, (Object)transfer.getOperationId());
                    transfer.cleanupTempFiles(true);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Could not process file footer. OperationId {}", (Object)msg.getOperationId(), (Object)e);
                ackMsg = new FileTransferAckMsg(transfer.getDeviceId(), msg.getOperationId(), 261, "Could not write file.");
            }
            this.messageSender.sendMessage(ackMsg);
            this.dropFileTransfer(ackMsg.getTarget(), ackMsg.getOperationId(), ackMsg.isSuccessful(), ackMsg.getCode(), ackMsg.getErrorDescription());
        }
    }

    private void notifyCompletionConsumer(String deviceId, String operationId, boolean successful, int code, String description) {
        Consumer<OperationCompletion> operationCompletionConsumer = this.operationIdToCompletionConsumerMap.get(operationId);
        if (operationCompletionConsumer != null) {
            operationCompletionConsumer.accept(new OperationCompletion(deviceId, operationId, successful, code, description));
        }
        this.operationIdToCompletionConsumerMap.remove(operationId);
    }

    public void dropFileTransfer(String deviceId, String operationId, boolean successful, int code, String description) {
        this.dropFileTransfer(deviceId, operationId, successful, code, description, true);
    }

    public void dropAllFileTransfers() {
        ArrayList<String> operationIds = new ArrayList<String>(this.operationIdToFileTransferMap.keySet());
        for (String operationId : operationIds) {
            FileTransfer fileTransfer = this.operationIdToFileTransferMap.get(operationId);
            if (fileTransfer == null) continue;
            this.dropFileTransfer(fileTransfer.getDeviceId(), operationId, false, 266, "Cancel all", false);
        }
    }

    private void dropFileTransfer(String deviceId, String operationId, boolean successful, int code, String description, boolean continueNextFt) {
        LOGGER.debug("Dropping FileTransfer operationId {}, errorCode: {}, description: {}", operationId, code, description);
        FileTransfer toRemove = this.operationIdToFileTransferMap.remove(operationId);
        if (toRemove != null) {
            if (this.fileTransferPriorityManager != null) {
                this.fileTransferPriorityManager.removeFileTransfer(deviceId, toRemove);
            }
            try {
                toRemove.close();
            }
            catch (Exception e) {
                LOGGER.warn("Could not close file deviceId {} operationId {}, file {}", deviceId, operationId, toRemove.getFile().getAbsolutePath());
            }
            if (continueNextFt) {
                this.continueFileTransfersForDevice(deviceId);
            }
        }
        this.notifyCompletionConsumer(deviceId, operationId, successful, code, description);
    }

    private void continueFileTransfersForDevice(String deviceId) {
        FileTransfer topPrioTransfer;
        Optional<FileTransfer> topPriorityFileTransfer;
        if (this.fileTransferPriorityManager != null && (topPriorityFileTransfer = this.fileTransferPriorityManager.getTopPriorityFileTransfer(deviceId)).isPresent() && !(topPrioTransfer = topPriorityFileTransfer.get()).isProcessing()) {
            GetNextFileChunkMsg ackMsg = new GetNextFileChunkMsg(topPrioTransfer.getDeviceId(), topPrioTransfer.getOperationId(), topPrioTransfer.getOffset(), topPrioTransfer.getChunkSize(), topPrioTransfer.getPriority());
            this.messageSender.sendMessage(ackMsg);
        }
    }

    public void setDataChunkFinishedListener(DataChunkFinishedListener dataTransferFinished) {
        this.dataChunkFinishedListener = dataTransferFinished;
    }

    private void checkTimeouts() {
        long currentMillis = System.currentTimeMillis();
        List timedOutOperationIds = this.operationIdToFileTransferMap.entrySet().stream().filter(e -> ((FileTransfer)e.getValue()).getState() != FileTransferState.TIME_OUT && ((FileTransfer)e.getValue()).getLastUpdateTimestamp() + this.ftTimeoutMillis < currentMillis).map(Map.Entry::getKey).collect(Collectors.toList());
        for (String timedOutOperationId : timedOutOperationIds) {
            FileTransfer fileTransfer = this.operationIdToFileTransferMap.get(timedOutOperationId);
            if (fileTransfer == null) continue;
            fileTransfer.setState(FileTransferState.TIME_OUT);
            this.messageSender.executeInDeviceWorkerThread(fileTransfer.getDeviceId(), () -> {
                LOGGER.info("Operation timed out operationId {}", (Object)timedOutOperationId);
                this.dropFileTransfer(fileTransfer.getDeviceId(), fileTransfer.getOperationId(), false, 265, "Operation timed out. file=" + fileTransfer.getFile() == null ? "null?" : fileTransfer.getFile().getName() + " lastupdate=" + fileTransfer.getLastUpdateTimestamp() + " size=" + fileTransfer.getFileSize() + " offset=" + fileTransfer.getOffset() + " hash=" + fileTransfer.getFileHash());
            });
        }
    }

    public void clearOperationsByDeviceId(String deviceId) {
        List<String> operationIds = this.getOperationIdsByAgentId(deviceId);
        for (String opId : operationIds) {
            this.dropFileTransfer(deviceId, opId, false, 267, "Device " + deviceId + " disconnected");
        }
    }

    public List<String> getOperationIdsByAgentId(String agentId) {
        return this.operationIdToFileTransferMap.entrySet().stream().filter(t -> ((FileTransfer)t.getValue()).getDeviceId().equals(agentId)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public List<FileTransfer> getOperationsByAgentId(String agentId) {
        return this.operationIdToFileTransferMap.values().stream().filter(fileTransfer -> fileTransfer.getDeviceId().equals(agentId)).collect(Collectors.toList());
    }

    public String getOperationIdByAgentIdAndFileName(String agentId, String fileName) {
        return this.operationIdToFileTransferMap.entrySet().stream().filter(t -> ((FileTransfer)t.getValue()).getDeviceId().equals(agentId) && fileName.equals(((FileTransfer)t.getValue()).getFile().getName())).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    boolean isChildPath(Path parent, Path child) {
        Path pn = parent.normalize();
        Path cn = child.normalize();
        return pn.endsWith(cn);
    }

    public boolean isDevice() {
        return this.isDevice;
    }

    public void setDevice(boolean device) {
        this.isDevice = device;
    }

    public void stopTimeoutChecks() {
        if (this.timeoutCheckScheduler != null && !this.timeoutCheckScheduler.isShutdown()) {
            this.timeoutCheckScheduler.shutdown();
        }
    }

    public void startTimeoutChecks() {
        if (this.timeoutCheckScheduler == null || this.timeoutCheckScheduler.isShutdown()) {
            this.timeoutCheckScheduler = Executors.newScheduledThreadPool(1);
            this.timeoutCheckScheduler.scheduleAtFixedRate(this::checkTimeouts, this.timeoutCheckCycleMillis, this.timeoutCheckCycleMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void clean() {
        HashSet<String> operationIds = new HashSet<String>(this.operationIdToFileTransferMap.keySet());
        for (String operationId : operationIds) {
            FileTransfer fileTransfer = this.operationIdToFileTransferMap.get(operationId);
            this.dropFileTransfer(fileTransfer.getDeviceId(), fileTransfer.getOperationId(), false, 0, "Test Cleanup");
        }
    }

    public int getDefaultBytesOverlap() {
        return this.defaultBytesOverlap;
    }

    public void setDefaultBytesOverlap(int defaultBytesOverlap) {
        this.defaultBytesOverlap = defaultBytesOverlap;
    }

    private class AlreadyDownloadedException
    extends Exception {
        private AlreadyDownloadedException() {
        }
    }
}

