/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.service.file;

import com.boom.netty.service.file.FileTransfer;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;

public class FileTransferPriorityManager {
    private Map<String, PriorityQueue<FileTransfer>> deviceIdToFileTransfersMap = new ConcurrentHashMap<String, PriorityQueue<FileTransfer>>();

    public void addFileTransfer(String deviceId, FileTransfer fileTransfer) {
        this.deviceIdToFileTransfersMap.computeIfAbsent(deviceId, device -> new PriorityQueue<FileTransfer>(Comparator.comparing(FileTransfer::getPriority))).add(fileTransfer);
    }

    public void removeFileTransfer(String deviceId, FileTransfer fileTransfer) {
        PriorityQueue<FileTransfer> fileTransfers = this.deviceIdToFileTransfersMap.get(deviceId);
        if (fileTransfers != null) {
            fileTransfers.remove(fileTransfer);
        }
    }

    public Optional<FileTransfer> getTopPriorityFileTransfer(String deviceId) {
        PriorityQueue<FileTransfer> fileTransfers = this.deviceIdToFileTransfersMap.get(deviceId);
        Optional<FileTransfer> result = fileTransfers == null ? Optional.empty() : Optional.ofNullable(fileTransfers.stream().filter(t -> !t.isProcessing()).findFirst().orElse(null));
        return result;
    }
}

