/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.service.file;

import com.boom.netty.digest.DigestManager;
import com.boom.netty.digest.GeneralDigest;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class FileUtils {
    public static final int CHUNK_SIZE = 131072;

    private FileUtils() {
    }

    public static GeneralDigest getDigestOfFile(Path path, String algorithm) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            int read;
            GeneralDigest digest = DigestManager.getDigest(algorithm);
            byte[] buffer = new byte[131072];
            while ((read = inputStream.read(buffer)) != -1) {
                digest.update(buffer, 0, read);
            }
            GeneralDigest generalDigest = digest;
            return generalDigest;
        }
    }

    public static String getChecksumString(byte[] digest) {
        return String.format("%032X", new BigInteger(1, digest));
    }
}

