/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.service.file.io;

import com.boom.netty.service.file.io.FileWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamFileWriter
implements FileWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamFileWriter.class);
    private OutputStream outputStream;
    private File file;

    public StreamFileWriter(File file, boolean append) throws FileNotFoundException {
        this.file = file;
        this.outputStream = new BufferedOutputStream(new FileOutputStream(file, append));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Opening file {}", (Object)file.getAbsolutePath());
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.outputStream.write(bytes);
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Closing file {}", (Object)this.file.getAbsolutePath());
        }
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Closing failed", e);
            }
            throw e;
        }
    }
}

