/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.service.tl;

import com.boom.netty.service.tl.TStatusChangeException;
import java.util.Objects;

public class TAbstractConfig {
    public static final String DRAFT = "draft";
    public static final String ACTIVE = "active";
    public static final String PAUSED = "paused";
    public static final String CANCELED = "canceled";
    public static final String COMPLETED = "completed";
    private String state = "draft";

    public boolean isActive() {
        return ACTIVE.equals(this.state);
    }

    public boolean isPaused() {
        return PAUSED.equals(this.state);
    }

    public boolean isDraft() {
        return DRAFT.equals(this.state);
    }

    public boolean isCompleted() {
        return COMPLETED.equals(this.state);
    }

    public boolean isCanceled() {
        return CANCELED.equals(this.state);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) throws TStatusChangeException {
        if (state == null || state.equals(this.state)) {
            return;
        }
        switch (state) {
            case "draft": {
                break;
            }
            case "active": {
                if (!CANCELED.equals(this.state) && !COMPLETED.equals(this.state)) break;
                throw new TStatusChangeException("can't change state '" + this.state + "' to 'active'");
            }
            case "paused": {
                if (ACTIVE.equals(this.state)) break;
                throw new TStatusChangeException("can't change state '" + this.state + "' to 'paused'");
            }
            case "canceled": {
                if (!COMPLETED.equals(this.state) && !DRAFT.equals(this.state)) break;
                throw new TStatusChangeException("can't change state '" + this.state + "' to 'canceled'");
            }
            case "completed": {
                if (ACTIVE.equals(this.state)) break;
                throw new TStatusChangeException("can't change state '" + this.state + "' to 'completed'");
            }
            default: {
                throw new TStatusChangeException("Unknown state '" + state + "' to 'draft'");
            }
        }
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TAbstractConfig)) {
            return false;
        }
        TAbstractConfig that = (TAbstractConfig)o;
        return Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return this.state != null ? this.state.hashCode() : 0;
    }
}

