/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.service.tl;

import com.boom.netty.service.tl.TAbstractElement;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TAbstractElementTypeAdapter
extends TypeAdapter<TAbstractElement> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TAbstractElementTypeAdapter.class);
    protected Gson gson = new Gson();

    @Override
    public void write(JsonWriter writer, TAbstractElement element) throws IOException {
        writer.beginObject();
        writer.name("objectClass");
        if (element != null) {
            writer.value(element.getClass().getName());
        } else {
            writer.value("");
        }
        writer.name("objectJson");
        if (element != null) {
            writer.value(this.gson.toJson((Object)element, element.getClass()));
        } else {
            writer.value("");
        }
        writer.endObject();
    }

    @Override
    public TAbstractElement read(JsonReader reader) throws IOException {
        TAbstractElement element = null;
        reader.beginObject();
        String fieldName = null;
        Class<?> clazz = null;
        while (reader.hasNext()) {
            JsonToken token = reader.peek();
            if (token.equals((Object)JsonToken.NAME)) {
                fieldName = reader.nextName();
            }
            if ("objectClass".equals(fieldName)) {
                String className = reader.nextString();
                if (className == null || className.isEmpty()) continue;
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warn("Class not found exception", e);
                }
                continue;
            }
            if ("objectJson".equals(fieldName)) {
                String json = reader.nextString();
                if (json == null || json.isEmpty() || clazz == null) continue;
                element = (TAbstractElement)this.gson.fromJson(json, clazz);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return element;
    }
}

