/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.service.util;

import com.boom.netty.common.MessageSender;
import com.boom.netty.service.basic.msg.PingMsg;
import com.boom.netty.service.basic.msg.PongMsg;
import com.boom.netty.ws.mhf.annotation.MessageHandlerMethod;

public class PingPongMessageHandler {
    private final String deviceId;
    private final MessageSender messageSender;

    public PingPongMessageHandler(String deviceId, MessageSender messageSender) {
        this.deviceId = deviceId;
        this.messageSender = messageSender;
    }

    @MessageHandlerMethod
    public void handle(PingMsg msg) {
        if (msg.getTarget().equals(this.deviceId)) {
            PongMsg pongMsg = new PongMsg(msg.getSource(), msg.getOperationId());
            pongMsg.setPingInitiatedTimestamp(msg.getPingInitiatedTimestamp());
            this.messageSender.sendMessage(pongMsg);
        } else {
            this.messageSender.sendMessage(msg);
        }
    }

    @MessageHandlerMethod
    public void handle(PongMsg msg) {
        if (msg.getTarget().equals(this.deviceId)) {
            msg.setPongReceivedTimestamp(System.currentTimeMillis());
        } else {
            this.messageSender.sendMessage(msg);
        }
    }
}

