/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.service.util;

import com.boom.netty.common.MessageSender;
import com.boom.netty.service.util.msg.TraceRouteMsg;
import com.boom.netty.service.util.msg.TraceRouteResponseMsg;
import com.boom.netty.ws.mhf.annotation.MessageHandlerMethod;
import io.netty.channel.ChannelFuture;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraceMessageHandler.class);
    private String deviceId;
    private MessageSender messageSender;

    public TraceMessageHandler(String deviceId, MessageSender messageSender) {
        this.deviceId = deviceId;
        this.messageSender = messageSender;
    }

    @MessageHandlerMethod
    public void handle(TraceRouteMsg msg) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)msg);
        }
        msg.addHop(this.deviceId);
        if (this.deviceId.equals(msg.getTarget())) {
            this.messageSender.sendMessage(this.createTraceRoutResponseMessage(msg));
        } else {
            Optional<ChannelFuture> channelFuture = this.messageSender.sendMessageNow(msg);
            if (channelFuture.isPresent()) {
                channelFuture.get().addListener(future -> {
                    if (future.isDone() && future.isCancelled()) {
                        this.messageSender.sendMessage(this.createTraceRoutResponseMessage(msg));
                    }
                });
            } else {
                this.messageSender.sendMessage(this.createTraceRoutResponseMessage(msg));
            }
        }
    }

    private TraceRouteResponseMsg createTraceRoutResponseMessage(TraceRouteMsg msg) {
        TraceRouteResponseMsg responseMsg = new TraceRouteResponseMsg(this.getPreviousHop(msg.getTrace()), msg.getSource(), msg.getTarget(), msg.getOperationId());
        responseMsg.getTimestamps().addAll(msg.getTimestamps());
        responseMsg.getTrace().addAll(msg.getTrace());
        return responseMsg;
    }

    private String getPreviousHop(List<String> hops) {
        String result = null;
        int index = hops.indexOf(this.deviceId);
        if (index > 0) {
            result = hops.get(index - 1);
        }
        return result;
    }

    @MessageHandlerMethod
    public void handle(TraceRouteResponseMsg msg) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)msg);
        }
        msg.addHop(this.deviceId);
        if (this.deviceId.equals(msg.getOriginalSource())) {
            this.logTraceResponse(msg);
        } else {
            msg.setTarget(this.getPreviousHop(msg.getTrace()));
            this.messageSender.sendMessage(msg);
        }
    }

    private void logTraceResponse(TraceRouteResponseMsg msg) {
        String operationId = msg.getOperationId();
        List<String> trace = msg.getTrace();
        List<Long> timestamps = msg.getTimestamps();
        int maxCount = Math.max(trace.size(), timestamps.size());
        LOGGER.debug("Trace operationId {} start trace route from {} to {}", operationId, msg.getTarget(), msg.getOriginalTarget());
        for (int i = 0; i < maxCount; ++i) {
            String hopDeviceId = "";
            String timestamp = "";
            if (i < trace.size()) {
                hopDeviceId = trace.get(i);
            }
            if (i < timestamps.size()) {
                timestamp = String.valueOf(timestamps.get(i));
            }
            LOGGER.debug("Trace operationId {}: {} - {}", operationId, hopDeviceId, timestamp);
        }
        LOGGER.debug("Trace operationId {} end", (Object)operationId);
    }
}

