/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.service.util.msg;

import com.boom.netty.ws.mhf.msg.MessageBase;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class TraceRouteMsg
extends MessageBase {
    private List<String> trace = new ArrayList<String>();
    private List<Long> timestamps = new ArrayList<Long>();

    public TraceRouteMsg(String target, String operationId) {
        super(target, operationId);
    }

    public TraceRouteMsg(String target) {
        this(target, UUID.randomUUID().toString());
    }

    public void addHop(String deviceId) {
        this.trace.add(deviceId);
        this.timestamps.add(System.currentTimeMillis());
    }

    public List<String> getTrace() {
        return this.trace;
    }

    public List<Long> getTimestamps() {
        return this.timestamps;
    }

    @Override
    public String toString() {
        return "TraceRouteMsg{source='" + this.source + '\'' + ", target='" + this.target + '\'' + ", operationId='" + this.operationId + '\'' + '}';
    }
}

