/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.service.util.msg;

import com.boom.netty.ws.mhf.msg.MessageBase;
import java.util.ArrayList;
import java.util.List;

public class TraceRouteResponseMsg
extends MessageBase {
    private String originalSource;
    private String originalTarget;
    private List<String> trace = new ArrayList<String>();
    private List<Long> timestamps = new ArrayList<Long>();

    public TraceRouteResponseMsg(String target, String originalSource, String originalTarget, String operationId) {
        super(target, operationId);
        this.originalSource = originalSource;
        this.originalTarget = originalTarget;
    }

    public void addHop(String deviceId) {
        this.trace.add(deviceId);
        this.timestamps.add(System.currentTimeMillis());
    }

    public List<String> getTrace() {
        return this.trace;
    }

    public List<Long> getTimestamps() {
        return this.timestamps;
    }

    public String getOriginalTarget() {
        return this.originalTarget;
    }

    public void setOriginalTarget(String originalTarget) {
        this.originalTarget = originalTarget;
    }

    public String getOriginalSource() {
        return this.originalSource;
    }

    public void setOriginalSource(String originalSource) {
        this.originalSource = originalSource;
    }

    @Override
    public String toString() {
        return "TraceRouteResponseMsg{originalSource='" + this.originalSource + '\'' + ", originalTarget='" + this.originalTarget + '\'' + ", source='" + this.source + '\'' + ", target='" + this.target + '\'' + ", operationId='" + this.operationId + '\'' + '}';
    }
}

