/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.client;

import com.boom.netty.ws.client.ConnectionException;
import com.boom.netty.ws.common.NettyChannelStateListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelActiveHandler
extends ChannelInboundHandlerAdapter {
    public static final String WS_CHANNEL_DISCONNECTED = "WS_CHANNEL_DISCONNECTED";
    private static final Logger logger = LoggerFactory.getLogger(ChannelActiveHandler.class);
    private final List<NettyChannelStateListener> channelStateListener;
    private Object channelActiveMonitor = new Object();
    private AtomicBoolean channelActive = new AtomicBoolean(false);
    private AtomicBoolean channelDeactivated = new AtomicBoolean(false);
    private Throwable cause;

    public ChannelActiveHandler(List<NettyChannelStateListener> channelStateListener) {
        this.channelStateListener = channelStateListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Object object = this.channelActiveMonitor;
        synchronized (object) {
            this.channelActive.set(true);
            this.channelActiveMonitor.notifyAll();
            this.channelStateListener.forEach(l -> l.channelActive(ctx.channel()));
        }
        super.channelActive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.debug("Connection lost.");
        this.channelStateListener.forEach(l -> l.channelClosed(ctx.channel()));
        ctx.close();
        this.channelDeactivated.set(true);
        Object object = this.channelActiveMonitor;
        synchronized (object) {
            this.channelActiveMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.channelActive.get()) {
            Object object = this.channelActiveMonitor;
            synchronized (object) {
                this.cause = cause;
                this.channelActiveMonitor.notifyAll();
            }
        }
        logger.warn("Exception in pipeline: ", cause);
        logger.info("Closing connection...");
        ctx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillFullyConnected() throws InterruptedException, ConnectionException {
        while (!this.channelActive.get() && !this.channelDeactivated.get()) {
            Object object = this.channelActiveMonitor;
            synchronized (object) {
                this.channelActiveMonitor.wait();
            }
        }
        if (this.cause != null) {
            throw new ConnectionException(this.cause);
        }
    }
}

