/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.client;

import com.boom.netty.ws.client.ChannelActiveHandler;
import com.boom.netty.ws.client.WebSocketClientChannelInitializer;
import com.boom.netty.ws.common.NettyChannelStateListener;
import com.boom.netty.ws.common.WebSocketMessageHandler;
import com.boom.netty.ws.mhf.MessageTypeHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClient
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketClient.class);
    private static final String SENDING_MESSAGE_LOG = "{} | Sending message {}";
    private final MessageTypeHandler messageConsumer;
    private final List<String> addresses;
    private int currentAddress = 0;
    private final int port;
    private final String regionId;
    private final Charset charset;
    private final boolean skipCertificateValidation;
    private final boolean useWss;
    private final KeyStore trustStore;
    private final KeyManagerFactory keyManagerFactory;
    private Channel channel;
    private List<NettyChannelStateListener> channelStateListener = new ArrayList<NettyChannelStateListener>();
    private String endpoint;
    private EventLoopGroup workerGroup = null;
    private int waitMsBeforeReconnect = 5000;
    private String logTag;
    private int connectTimeoutMs = 10000;

    public WebSocketClient(List<String> addresses, int port, int connectTimeoutMs, String regionId, Charset charset, boolean skipCertificateValidation, boolean useWss, KeyStore trustStore, KeyManagerFactory keyManagerFactory, EventLoopGroup workerGroup, String endpoint, MessageTypeHandler messageConsumer, String logTag) {
        this.addresses = addresses;
        this.port = port;
        this.connectTimeoutMs = connectTimeoutMs;
        this.regionId = regionId;
        this.charset = charset;
        this.skipCertificateValidation = skipCertificateValidation;
        this.useWss = useWss;
        this.trustStore = trustStore;
        this.endpoint = endpoint;
        this.logTag = logTag;
        this.messageConsumer = messageConsumer;
        this.keyManagerFactory = keyManagerFactory;
        this.workerGroup = workerGroup;
    }

    public void addNettyChannelStateListener(NettyChannelStateListener listener) {
        this.channelStateListener.add(listener);
    }

    public void removeNettyChannelStateListener(NettyChannelStateListener listener) {
        this.channelStateListener.remove(listener);
    }

    public void connect() {
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            ChannelActiveHandler channelActiveHandler = new ChannelActiveHandler(this.channelStateListener);
            Bootstrap b = new Bootstrap();
            b.group(this.workerGroup);
            b.channel(NioSocketChannel.class);
            b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.connectTimeoutMs);
            b.option(ChannelOption.SO_KEEPALIVE, true);
            b.option(ChannelOption.AUTO_READ, true);
            b.handler(new WebSocketClientChannelInitializer(channelActiveHandler, this.endpoint, this.regionId, this.charset, this.skipCertificateValidation, this.useWss, this.trustStore, this.keyManagerFactory));
            try {
                LOGGER.debug("Starting connection to: {}:{}", (Object)this.addresses.get(this.currentAddress), (Object)this.port);
                ChannelFuture connectFuture = b.connect(this.addresses.get(this.currentAddress), this.port).sync();
                LOGGER.debug("Connected: {}:{}", (Object)this.addresses.get(this.currentAddress), (Object)this.port);
                this.channel = connectFuture.channel();
                this.channel.pipeline().addLast(new WebSocketMessageHandler(this.messageConsumer));
                channelActiveHandler.waitTillFullyConnected();
                LOGGER.info("Confirmed connected to: {}:{}", (Object)this.addresses.get(this.currentAddress), (Object)this.port);
                this.channel.closeFuture().sync();
                Thread.sleep(this.waitMsBeforeReconnect);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) {
                    LOGGER.warn("Could not connect to server {} on port {}", (Object)this.addresses.get(this.currentAddress), (Object)this.port);
                } else {
                    LOGGER.debug("Could not connect to server {} on port {}", this.addresses.get(this.currentAddress), this.port, e);
                }
                this.currentAddress = this.currentAddress < this.addresses.size() - 1 ? ++this.currentAddress : 0;
                try {
                    Thread.sleep(this.waitMsBeforeReconnect);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void shutDown(boolean blocking) {
        LOGGER.info("Shutting down the connection to server {} on port {}", (Object)this.addresses.get(this.currentAddress), (Object)this.port);
        if (blocking) {
            try {
                this.workerGroup.shutdownGracefully().sync();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            this.workerGroup.shutdownGracefully();
        }
        this.interrupt();
    }

    public void sendMessage(Channel channel, Object msg) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(SENDING_MESSAGE_LOG, (Object)this.logTag, msg);
        }
        channel.writeAndFlush(msg);
    }

    public void sendMessage(Channel channel, Object msg, ChannelFutureListener listener) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(SENDING_MESSAGE_LOG, (Object)this.logTag, msg);
        }
        channel.writeAndFlush(msg).addListener((GenericFutureListener)listener);
    }

    public Optional<ChannelFuture> sendMessage(Object msg) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(SENDING_MESSAGE_LOG, (Object)this.logTag, msg);
        }
        return Optional.ofNullable(this.channel.writeAndFlush(msg));
    }

    public String getAddress() {
        return this.addresses.get(this.currentAddress);
    }

    public int getPort() {
        return this.port;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public int getWaitMsBeforeReconnect() {
        return this.waitMsBeforeReconnect;
    }

    public void setWaitMsBeforeReconnect(int waitMsBeforeReconnect) {
        this.waitMsBeforeReconnect = waitMsBeforeReconnect;
    }

    public Channel getChannel() {
        return this.channel;
    }
}

