/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.client;

import com.boom.netty.ws.client.ChannelActiveHandler;
import com.boom.netty.ws.client.WebSocketCloseHandler;
import com.boom.netty.ws.client.WebSocketHandshakeHandler;
import com.boom.netty.ws.client.WebSocketPongHandler;
import com.boom.netty.ws.common.WsConstants;
import com.boom.netty.ws.mhf.MessageCodec;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClientChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketClientChannelInitializer.class);
    private final ChannelActiveHandler channelActiveHandler;
    private final String endpoint;
    private final String regionId;
    private final Charset charset;
    private boolean skipCertificateValidation;
    private boolean useWss;
    private KeyStore trustStore;
    private KeyManagerFactory keyManagerFactory;

    public WebSocketClientChannelInitializer(ChannelActiveHandler channelActiveHandler, String endpoint, String regionId, Charset charset, boolean skipCertificateValidation, boolean useWss, KeyStore trustStore, KeyManagerFactory keyManagerFactory) {
        this.channelActiveHandler = channelActiveHandler;
        this.endpoint = endpoint;
        this.regionId = regionId;
        this.charset = charset;
        this.skipCertificateValidation = skipCertificateValidation;
        this.trustStore = trustStore;
        this.keyManagerFactory = keyManagerFactory;
        this.useWss = useWss;
    }

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.useWss) {
            try {
                SslContext sslContext = SslContextBuilder.forClient().trustManager(this.getTrustManagerFactory(this.skipCertificateValidation)).keyManager(this.keyManagerFactory).build();
                SslHandler sslHandler = sslContext.newHandler(ch.alloc());
                ch.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
            }
            catch (Exception e) {
                logger.warn("An error occurred while trying to initialize sslHandler: ", e);
                ch.close();
                return;
            }
        }
        ch.attr(WsConstants.WS_CHANNEL_ENDPOINT_ATTR).set(this.endpoint);
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        additionalHeaders.put("ACCESS_TOKEN", "123456");
        additionalHeaders.put("CHANNEL_ENDPOINT", this.endpoint);
        additionalHeaders.put("REGION_ID", this.regionId);
        ch.pipeline().addLast(new HttpClientCodec()).addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)}).addLast(new WebSocketHandshakeHandler(URI.create("ws://central-region/" + this.endpoint), additionalHeaders, 30000L)).addLast(new WebSocketCloseHandler(30000L)).addLast(new WebSocketPongHandler("clientSide", 30L, TimeUnit.SECONDS)).addLast(new ChunkedWriteHandler()).addLast(new ChannelHandler[]{new MessageCodec(this.charset)}).addLast(this.channelActiveHandler);
    }

    public TrustManagerFactory getTrustManagerFactory(boolean skipCertificateValidation) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory;
        if (skipCertificateValidation) {
            factory = InsecureTrustManagerFactory.INSTANCE;
        } else {
            factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (this.trustStore != null) {
                factory.init(this.trustStore);
            }
        }
        return factory;
    }
}

