/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.client;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketCloseHandler
extends ChannelDuplexHandler {
    protected static final String WEBSOCKET_CLIENT_CLOSE_TEXT = "Other side has closed the tunnel connection.";
    protected static final int WEBSOCKET_ERROR_CLOSE_STATUS_CODE = 1008;
    protected static final int WEBSOCKET_NORMAL_CLOSE_STATUS_CODE = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketCloseHandler.class);
    protected boolean closing = false;
    protected long closeTimeout;
    private ChannelHandlerContext ctx;
    private CloseTask closeTask = new CloseTask();
    private ScheduledFuture<?> closeTaskFuture;

    public WebSocketCloseHandler(long closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.closeTaskFuture != null && !this.closeTaskFuture.isDone()) {
            this.closeTaskFuture.cancel(false);
        }
        super.channelInactive(ctx);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame receivedCloseFrame = (CloseWebSocketFrame)msg;
            int closeStatusCode = receivedCloseFrame.statusCode();
            String reasonText = receivedCloseFrame.reasonText();
            if (closeStatusCode != 1000) {
                LOGGER.info("Abnormal termination - Received a WebSocketCloseFrame with status code '{}' and reason '{}'", (Object)closeStatusCode, (Object)reasonText);
            } else {
                LOGGER.debug("Normal termination - Received a WebSocketCloseFrame with status code '{}'", (Object)closeStatusCode);
            }
            if (!this.closing) {
                this.answerClosingHandshake(receivedCloseFrame);
            }
            ReferenceCountUtil.release(msg);
            ctx.channel().read();
        } else if (this.closing) {
            LOGGER.debug("Ongoing WS closing handshake, data read from the channel cannot be forwarded and will be ignored");
            ReferenceCountUtil.release(msg);
            ctx.channel().read();
        } else {
            super.channelRead(ctx, msg);
        }
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!this.closing) {
            super.write(ctx, msg, promise);
        } else {
            LOGGER.debug("Ongoing WS closing handshake, data written to the channel cannot be forwarded and will be ignored");
            ReferenceCountUtil.release(msg);
            promise.setSuccess();
        }
    }

    private void answerClosingHandshake(CloseWebSocketFrame closeFrame) {
        LOGGER.debug("WebSocket Close frame received! Replying with the same frame...");
        this.closing = true;
        this.ctx.writeAndFlush(new CloseWebSocketFrame(closeFrame.statusCode(), closeFrame.reasonText()));
        this.closeTaskFuture = this.ctx.executor().schedule(this.closeTask, this.closeTimeout, TimeUnit.MILLISECONDS);
    }

    private class CloseTask
    implements Runnable {
        private CloseTask() {
        }

        @Override
        public void run() {
            if (WebSocketCloseHandler.this.ctx.channel() != null) {
                if (WebSocketCloseHandler.this.ctx.channel().isOpen()) {
                    LOGGER.info("WS close handshake timeout occurred. Server didn't close/respond in time. Closing channel forcefully");
                    WebSocketCloseHandler.this.ctx.channel().close();
                }
            } else {
                LOGGER.warn("WS close handshake timeout elapsed but channel cannot be closed forcefully since ctx.channel() is null!");
            }
        }
    }
}

