/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.client;

import com.boom.netty.ws.common.WebSocketException;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpObject;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.ReferenceCountUtil;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketHandshakeHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketHandshakeHandler.class);
    protected long handshakeTimeout;
    protected WebSocketClientHandshaker handshaker;
    protected HttpHeaders headers;
    private ChannelHandlerContext ctx;
    private TimeoutTask timeoutTask = new TimeoutTask();
    private ScheduledFuture<?> timeoutTaskFuture;

    public WebSocketHandshakeHandler(URI request, Map<String, String> additionalHeaders, long handshakeTimeout) {
        this.headers = new DefaultHttpHeaders();
        if (additionalHeaders != null && !additionalHeaders.isEmpty()) {
            for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                this.headers.add(entry.getKey(), (Object)entry.getValue());
            }
        }
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker(request, WebSocketVersion.V13, "boom-v1", false, this.headers);
        this.handshakeTimeout = handshakeTimeout;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive()) {
            logger.warn("A handshake handler has to be added strictly before connecting the channel");
            throw new IllegalStateException("A handshake handler has to be added strictly before connecting the channel");
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.startHandshake(ctx);
        ctx.read();
    }

    private void startHandshake(ChannelHandlerContext ctx) {
        logger.debug("Starting WebSocket handshake (version: {})", (Object)this.handshaker.version());
        this.handshaker.handshake(ctx.channel());
        this.timeoutTaskFuture = ctx.executor().schedule(this.timeoutTask, this.handshakeTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.timeoutTaskFuture != null && !this.timeoutTaskFuture.isDone()) {
            this.timeoutTaskFuture.cancel(true);
        }
        ctx.fireChannelInactive();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (!this.handshaker.isHandshakeComplete() && msg instanceof FullHttpResponse) {
            this.handshaker.finishHandshake(ctx.channel(), (FullHttpResponse)msg);
            ReferenceCountUtil.release(msg);
            this.timeoutTaskFuture.cancel(true);
            ctx.channel().pipeline().remove(this);
            ctx.fireChannelActive();
            logger.debug("WebSocket handshake finished successfully.");
        } else {
            logger.warn("Received unexpected message before handshake finished: {}", msg);
            ctx.fireExceptionCaught(new WebSocketHandshakeException("Unexpected message received."));
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof WebSocketHandshakeException) {
            logger.warn("WebSocket Handshake failed: {}", (Object)cause.getMessage());
            ctx.fireExceptionCaught(cause);
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof DefaultHttpObject) && !this.handshaker.isHandshakeComplete()) {
            logger.warn("Trying to write data to WebSocket connection before handshake was finished: {}", msg);
            ctx.fireExceptionCaught(new WebSocketException("Unexpected message to be written."));
        } else {
            super.write(ctx, msg, promise);
        }
    }

    private class TimeoutTask
    implements Runnable {
        private TimeoutTask() {
        }

        @Override
        public void run() {
            logger.warn("Websocket handshake timeout expired.");
            WebSocketHandshakeHandler.this.ctx.fireExceptionCaught(new WebSocketException("Websocket handshake timeout expired."));
        }
    }
}

