/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.Charset;

public class WebSocketChunkedInput
implements ChunkedInput<WebSocketFrame> {
    private static final int CHUNK_SIZE = 65536;
    private final ByteBuf buffer;
    private final int length;
    private final boolean isText;
    private int offset;

    public WebSocketChunkedInput(String msg, Charset charset) {
        this.buffer = Unpooled.copiedBuffer(msg, charset);
        this.length = this.buffer.readableBytes();
        this.offset = 0;
        this.isText = true;
    }

    public WebSocketChunkedInput(byte[] msg) {
        this.buffer = Unpooled.copiedBuffer(msg);
        this.length = this.buffer.readableBytes();
        this.offset = 0;
        this.isText = false;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        return this.offset == this.length;
    }

    @Override
    public void close() throws Exception {
        ReferenceCountUtil.release(this.buffer);
    }

    @Override
    public WebSocketFrame readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    @Override
    public WebSocketFrame readChunk(ByteBufAllocator allocator) throws Exception {
        WebSocketFrame frame = null;
        int bytesToRead = Math.min(65536, this.length - this.offset);
        frame = this.offset == 0 ? (this.isText ? new TextWebSocketFrame(false, 0, this.buffer.retainedSlice(0, bytesToRead)) : new BinaryWebSocketFrame(false, 0, this.buffer.retainedSlice(0, bytesToRead))) : new ContinuationWebSocketFrame(this.offset + bytesToRead == this.length, 0, this.buffer.retainedSlice(this.offset, bytesToRead));
        this.offset += bytesToRead;
        return frame;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public long progress() {
        return (long)this.length - (long)this.offset;
    }
}

