/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.common;

import com.boom.netty.ws.mhf.MessageTypeHandler;
import com.boom.netty.ws.mhf.msg.MessageBase;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class WebSocketMessageHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketMessageHandler.class);
    private final MessageTypeHandler messageConsumer;

    public WebSocketMessageHandler(MessageTypeHandler messageConsumer) {
        this.messageConsumer = messageConsumer;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof MessageBase) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Received message {}", msg);
            }
            this.messageConsumer.handle((MessageBase)msg, ctx.channel());
        } else {
            LOGGER.debug("Received message of unknown type: {}", (Object)(msg == null ? null : msg.getClass()));
            ReferenceCountUtil.release(msg);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.warn("Closing channel on exception:", cause);
        }
        this.flushOnClose(ctx.channel());
    }

    private void flushOnClose(Channel channel) {
        if (channel.isActive()) {
            LOGGER.debug("Flushing channel before close {}", (Object)channel);
            channel.write(Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            LOGGER.debug("Channel has been flushed {}", (Object)channel);
        } else {
            LOGGER.debug("Cannot flush channel {}", (Object)channel);
        }
    }
}

