/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.mhf;

import com.boom.netty.ws.common.WebSocketChunkedInput;
import com.boom.netty.ws.mhf.MessageTypesRepository;
import com.boom.netty.ws.mhf.msg.BarrelMessage;
import com.boom.netty.ws.mhf.msg.GsonExclusionStrategy;
import com.boom.netty.ws.mhf.msg.MessageBase;
import com.boom.netty.ws.mhf.msg.RawMessage;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.ReferenceCountUtil;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCodec
extends MessageToMessageCodec<WebSocketFrame, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageCodec.class);
    private final Charset charset;
    private final ByteBuf continuationBuffer;
    private final Gson gson;
    private final Gson gsonOnlyExposed;
    private MessageTypesRepository messageTypesRepository;

    public MessageCodec(Charset charset) {
        this.charset = charset;
        this.continuationBuffer = Unpooled.buffer();
        this.messageTypesRepository = MessageTypesRepository.getInstance();
        this.gson = new GsonBuilder().setDateFormat("yyyyMMdd'T'HHmmss.SSS'Z'").addSerializationExclusionStrategy(new GsonExclusionStrategy()).serializeSpecialFloatingPointValues().create();
        this.gsonOnlyExposed = new GsonBuilder().setDateFormat("yyyyMMdd'T'HHmmss.SSS'Z'").addSerializationExclusionStrategy(new GsonExclusionStrategy()).excludeFieldsWithoutExposeAnnotation().serializeSpecialFloatingPointValues().create();
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, Object inputObject, List<Object> outputObjectList) throws Exception {
        if (inputObject instanceof String) {
            String strMsg = (String)inputObject;
            if (strMsg.length() > 65536) {
                outputObjectList.add(new WebSocketChunkedInput(strMsg, this.charset));
            } else {
                outputObjectList.add(new TextWebSocketFrame(strMsg));
            }
        } else if (inputObject instanceof byte[]) {
            byte[] byteMsg = (byte[])inputObject;
            if (byteMsg.length > 65536) {
                outputObjectList.add(new WebSocketChunkedInput(byteMsg));
            } else {
                outputObjectList.add(new BinaryWebSocketFrame(Unpooled.copiedBuffer(byteMsg)));
            }
        } else if (inputObject instanceof RawMessage) {
            RawMessage messageBase = (RawMessage)inputObject;
            ByteBuf buffer = Unpooled.buffer();
            buffer.writeInt(messageBase.getMessageTypeId());
            String sourceString = this.nullSaveString(messageBase.getSource());
            byte[] source = sourceString.getBytes(StandardCharsets.UTF_8);
            buffer.writeInt(source.length);
            buffer.writeBytes(source);
            String targetString = this.nullSaveString(messageBase.getTarget());
            byte[] target = targetString.getBytes(StandardCharsets.UTF_8);
            buffer.writeInt(target.length);
            buffer.writeBytes(target);
            String operationIdString = this.nullSaveString(messageBase.getOperationId());
            byte[] operationId = operationIdString.getBytes(StandardCharsets.UTF_8);
            buffer.writeInt(operationId.length);
            buffer.writeBytes(operationId);
            String optionalHeaderString = this.nullSaveString(messageBase.getJsonPayload());
            byte[] optionalHeader = optionalHeaderString.getBytes(StandardCharsets.UTF_8);
            buffer.writeInt(optionalHeader.length);
            buffer.writeBytes(optionalHeader);
            buffer.writeInt(messageBase.getBytesPayload().length);
            buffer.writeBytes(Unpooled.copiedBuffer(messageBase.getBytesPayload()));
            byte[] messageBytes = buffer.array();
            if (messageBytes.length > 65536) {
                outputObjectList.add(new WebSocketChunkedInput(messageBytes));
            } else {
                outputObjectList.add(new BinaryWebSocketFrame(buffer));
            }
        } else if (inputObject instanceof MessageBase) {
            this.encodeMessageBaseMsg((MessageBase)inputObject, outputObjectList);
        } else {
            outputObjectList.add(ReferenceCountUtil.retain(inputObject));
        }
    }

    private void encodeMessageBaseMsg(MessageBase messageBase, List<Object> outputObjectList) {
        try {
            ByteBuf buffer = Unpooled.buffer();
            int messageTypeId = messageBase.getMessageTypeId();
            buffer.writeInt(messageTypeId);
            String sourceString = this.nullSaveString(messageBase.getSource());
            byte[] source = sourceString.getBytes(StandardCharsets.UTF_8);
            buffer.writeInt(source.length);
            buffer.writeBytes(source);
            String targetString = this.nullSaveString(messageBase.getTarget());
            byte[] target = targetString.getBytes(StandardCharsets.UTF_8);
            buffer.writeInt(target.length);
            buffer.writeBytes(target);
            String operationIdString = this.nullSaveString(messageBase.getOperationId());
            byte[] operationId = operationIdString.getBytes(StandardCharsets.UTF_8);
            buffer.writeInt(operationId.length);
            buffer.writeBytes(operationId);
            Class<?> messageClass = this.messageTypesRepository.getMessageClass(messageTypeId);
            String jsonPayloadNullable = this.messageTypesRepository.isOnlyExposedFieldsSerialization(messageTypeId) ? this.gsonOnlyExposed.toJson((Object)messageBase, messageClass) : this.gson.toJson((Object)messageBase, messageClass);
            String jsonPayloadString = this.nullSaveString(jsonPayloadNullable);
            byte[] jsonPayload = jsonPayloadString.getBytes(StandardCharsets.UTF_8);
            buffer.writeInt(jsonPayload.length);
            buffer.writeBytes(jsonPayload);
            buffer.writeInt(messageBase.getBytesPayload().length);
            buffer.writeBytes(Unpooled.copiedBuffer(messageBase.getBytesPayload()));
            byte[] messageBytes = buffer.array();
            if (messageBytes.length > 65536) {
                outputObjectList.add(new WebSocketChunkedInput(messageBytes));
            } else {
                outputObjectList.add(new BinaryWebSocketFrame(buffer));
            }
        }
        catch (RuntimeException e) {
            LOGGER.debug("Error encoding msg: {}", (Object)messageBase.getClass());
            throw e;
        }
    }

    private String nullSaveString(String text) {
        return text == null ? "" : text;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> outputObjectList) throws Exception {
        ByteBuf byteBuffer = webSocketFrame.content();
        if (webSocketFrame instanceof TextWebSocketFrame && webSocketFrame.isFinalFragment()) {
            outputObjectList.add(webSocketFrame.content().toString(this.charset));
        } else if (webSocketFrame instanceof BinaryWebSocketFrame && webSocketFrame.isFinalFragment()) {
            this.decodeMessageBaseMsg(outputObjectList, byteBuffer);
        } else if (!webSocketFrame.isFinalFragment() || webSocketFrame instanceof ContinuationWebSocketFrame) {
            this.continuationBuffer.writeBytes(byteBuffer);
            if (webSocketFrame.isFinalFragment()) {
                if (webSocketFrame instanceof TextWebSocketFrame) {
                    outputObjectList.add(this.continuationBuffer.toString(this.charset));
                } else {
                    this.decodeMessageBaseMsg(outputObjectList, this.continuationBuffer);
                }
                this.continuationBuffer.clear();
            }
        }
    }

    private void decodeMessageBaseMsg(List<Object> outputObjectList, ByteBuf byteBuffer) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        MessageBase messageBase = null;
        int messageTypeId = -1;
        try {
            messageTypeId = byteBuffer.readInt();
            int sourceLength = byteBuffer.readInt();
            String source = byteBuffer.readCharSequence(sourceLength, StandardCharsets.UTF_8).toString();
            int targetLength = byteBuffer.readInt();
            String target = byteBuffer.readCharSequence(targetLength, StandardCharsets.UTF_8).toString();
            int operationIdLength = byteBuffer.readInt();
            String operationId = byteBuffer.readCharSequence(operationIdLength, StandardCharsets.UTF_8).toString();
            int jsonPayloadLength = byteBuffer.readInt();
            String jsonPayload = byteBuffer.readCharSequence(jsonPayloadLength, StandardCharsets.UTF_8).toString();
            int bodyLength = byteBuffer.readInt();
            byte[] bytesPayload = new byte[bodyLength];
            byteBuffer.readBytes(bytesPayload, 0, bodyLength);
            Class<?> messageClass = this.messageTypesRepository.getMessageClass(messageTypeId);
            if (messageClass == null) {
                RawMessage message = new RawMessage(target, operationId, jsonPayload);
                message.setSource(source);
                message.setBytesPayload(bytesPayload);
                message.setOriginalMsgCode(messageTypeId);
                messageBase = message;
            } else {
                if (jsonPayloadLength > 0) {
                    if (messageClass == BarrelMessage.class) {
                        Gson gsonBarrel = new GsonBuilder().addDeserializationExclusionStrategy(new ExclusionStrategy(){

                            @Override
                            public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                                return "originalMessage".equals(fieldAttributes.getName());
                            }

                            @Override
                            public boolean shouldSkipClass(Class<?> aClass) {
                                return false;
                            }
                        }).create();
                        BarrelMessage bMsg = gsonBarrel.fromJson(jsonPayload, BarrelMessage.class);
                        JsonObject asJsonObject = JsonParser.parseString(jsonPayload).getAsJsonObject();
                        Class<?> originClass = this.messageTypesRepository.getMessageClass(bMsg.getOrigMessageType());
                        JsonElement originalMessageObject = asJsonObject.get("originalMessage");
                        MessageBase mb = (MessageBase)this.gson.fromJson(originalMessageObject, originClass);
                        messageBase = bMsg.setOriginalMessage(mb).applyAfterDeserialization();
                    } else {
                        messageBase = (MessageBase)this.gson.fromJson(jsonPayload, messageClass);
                    }
                } else {
                    messageBase = (MessageBase)messageClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                messageBase.setMessageTypeId(messageTypeId);
                messageBase.setSource(source);
                messageBase.setTarget(target);
                messageBase.setOperationId(operationId);
                messageBase.setBytesPayload(bytesPayload);
            }
            outputObjectList.add(messageBase);
        }
        catch (RuntimeException e) {
            if (messageBase != null) {
                LOGGER.warn("Error decoding msgtypeid: {}, msg: {}", (Object)messageTypeId, (Object)messageBase);
            } else {
                LOGGER.warn("Error reading bytebuffer for msgtypeid: {}", (Object)messageTypeId);
            }
            throw e;
        }
    }
}

