/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.mhf;

import com.boom.netty.ws.mhf.msg.MessageBase;
import io.netty.channel.Channel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandlerMethodInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageHandlerMethodInvoker.class);
    private Object handlerObject;
    private Method method;
    private boolean channelParameterPresent;

    public MessageHandlerMethodInvoker(Object handlerObject, Method method, boolean channelParameterPresent) {
        this.handlerObject = handlerObject;
        this.method = method;
        this.channelParameterPresent = channelParameterPresent;
    }

    public void invoke(MessageBase messageBase, Channel channel) {
        try {
            if (this.channelParameterPresent) {
                this.method.invoke(this.handlerObject, messageBase, channel);
            } else {
                this.method.invoke(this.handlerObject, messageBase);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.warn("Could not invoke handler method", e);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("Could not invoke message handler. Probably messageId clash. Message {}, handlerMethod {}", messageBase, this.method, ex);
        }
        catch (Exception e) {
            LOGGER.warn("Could not invoke message handler. Message {}, handlerMethod {}", messageBase, this.method, e);
        }
    }

    public Object getHandlerObject() {
        return this.handlerObject;
    }

    public String toString() {
        return "MessageHandlerMethodInvoker{handlerObject=" + this.handlerObject + ", method=" + this.method + ", channelParameterPresent=" + this.channelParameterPresent + '}';
    }
}

