/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.mhf;

import com.boom.netty.ws.mhf.MessageHandlerMethodInvoker;
import com.boom.netty.ws.mhf.MessageTypesRepository;
import com.boom.netty.ws.mhf.annotation.MessageHandlerMethod;
import com.boom.netty.ws.mhf.msg.MessageBase;
import io.netty.channel.Channel;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTypeHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageTypeHandler.class);
    private static final int CATCH_ALL_MESSAGE_ID = 0;
    private Map<Integer, List<MessageHandlerMethodInvoker>> messageTypeIdToHandlerMethodMap = new HashMap<Integer, List<MessageHandlerMethodInvoker>>();
    private Set<Integer> messageTypeHandledExplicitly = new HashSet<Integer>();
    private String logTag = "";

    public MessageTypeHandler(String logTag) {
        this.logTag = logTag;
    }

    public boolean registerHandler(Object handler) {
        boolean registered = false;
        MessageTypesRepository messageTypesRepository = MessageTypesRepository.getInstance();
        ArrayList<Method> candidateMethods = new ArrayList<Method>();
        for (Class<?> currentClass = handler.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            candidateMethods.addAll(Arrays.asList(currentClass.getDeclaredMethods()));
        }
        List methods = candidateMethods.stream().filter(method -> method.isAnnotationPresent(MessageHandlerMethod.class)).filter(method -> method.getParameterCount() == 1 || method.getParameterCount() == 2).collect(Collectors.toList());
        for (Method method2 : methods) {
            List invokers;
            boolean channelParamOk;
            boolean messageParamOk = method2.getParameterCount() > 0 && MessageBase.class.isAssignableFrom(method2.getParameterTypes()[0]);
            boolean bl = channelParamOk = method2.getParameterCount() == 2 && Channel.class.isAssignableFrom(method2.getParameterTypes()[1]);
            if (!messageParamOk) continue;
            Class<?> msgClass = method2.getParameterTypes()[0];
            Integer messageTypeId = messageTypesRepository.getMessageType(msgClass);
            if (messageTypeId == null && MessageBase.class.equals(msgClass)) {
                invokers = this.messageTypeIdToHandlerMethodMap.computeIfAbsent(0, m -> new ArrayList());
                invokers.add(new MessageHandlerMethodInvoker(handler, method2, channelParamOk));
                LOGGER.debug("MessageBase handler registered");
                registered = true;
                continue;
            }
            if (messageTypeId == null) continue;
            invokers = this.messageTypeIdToHandlerMethodMap.computeIfAbsent(messageTypeId, m -> new ArrayList());
            invokers.add(new MessageHandlerMethodInvoker(handler, method2, channelParamOk));
            this.messageTypeHandledExplicitly.add(messageTypeId);
            LOGGER.debug("Message handler registered for messageTypeId: {} method: {}", (Object)messageTypeId, (Object)method2);
            registered = true;
        }
        return registered;
    }

    public boolean isMessageHandledExplicitly(MessageBase messageBase) {
        return this.messageTypeHandledExplicitly.contains(messageBase.getMessageTypeId());
    }

    public boolean handle(MessageBase messageBase, Channel channel) {
        boolean messageHandled = false;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{} | Received Message {}", (Object)this.logTag, (Object)messageBase);
        }
        messageHandled = this.handleMessageUsingInvokers(messageBase, channel, this.messageTypeIdToHandlerMethodMap.getOrDefault(messageBase.getMessageTypeId(), Collections.emptyList()));
        boolean catchAllHandled = this.handleMessageUsingInvokers(messageBase, channel, this.messageTypeIdToHandlerMethodMap.getOrDefault(0, Collections.emptyList()));
        boolean bl = messageHandled = messageHandled || catchAllHandled;
        if (!messageHandled) {
            LOGGER.debug("{} Message handler not found for {}", (Object)this.logTag, (Object)messageBase.getClass());
        }
        return messageHandled;
    }

    private boolean handleMessageUsingInvokers(MessageBase messageBase, Channel channel, List<MessageHandlerMethodInvoker> messageHandlerMethodInvokers) {
        boolean messageHandled = false;
        if (!messageHandlerMethodInvokers.isEmpty()) {
            for (MessageHandlerMethodInvoker invoker : messageHandlerMethodInvokers) {
                invoker.invoke(messageBase, channel);
            }
            messageHandled = true;
        }
        return messageHandled;
    }

    public void registerConsumers(MessageTypeHandler handler) {
        this.messageTypeIdToHandlerMethodMap.putAll(handler.messageTypeIdToHandlerMethodMap);
        this.messageTypeHandledExplicitly.addAll(handler.messageTypeHandledExplicitly);
    }
}

