/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.mhf;

import com.boom.netty.ws.mhf.MessageTypeRegistrationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MessageTypesRepository {
    private final Map<Integer, Class<?>> messageTypeIdToClassMap = new HashMap();
    private final Map<Integer, Boolean> messageTypeToOnlyExposedFlag = new HashMap<Integer, Boolean>();
    private final Map<Class<?>, Integer> classToMessageTypeMap = new HashMap();
    private static final MessageTypesRepository INSTANCE = new MessageTypesRepository();

    private MessageTypesRepository() {
    }

    public static MessageTypesRepository getInstance() {
        return INSTANCE;
    }

    public synchronized void setExposedOnlySerialization(int msgTypeId, boolean isOnlyExposedFieldsSerialization) {
        this.messageTypeToOnlyExposedFlag.put(msgTypeId, isOnlyExposedFieldsSerialization);
    }

    public boolean isOnlyExposedFieldsSerialization(int msgTypeId) {
        return this.messageTypeToOnlyExposedFlag.containsKey(msgTypeId) && this.messageTypeToOnlyExposedFlag.get(msgTypeId) != false;
    }

    public synchronized void registerMessageTypes(Map<Integer, Class<?>> messageTypeIdToClassMap) throws MessageTypeRegistrationException {
        for (Map.Entry<Integer, Class<?>> entry : messageTypeIdToClassMap.entrySet()) {
            Class<?> alreadyRegisteredClass = messageTypeIdToClassMap.get(entry.getKey());
            if (alreadyRegisteredClass == null || alreadyRegisteredClass.equals(entry.getValue())) continue;
            throw new MessageTypeRegistrationException("Message with id " + entry.getKey() + " is already registered for class " + alreadyRegisteredClass.getCanonicalName() + " attempted to register " + entry.getValue() + " for this id");
        }
        this.messageTypeIdToClassMap.putAll(messageTypeIdToClassMap);
        messageTypeIdToClassMap.entrySet().forEach(e -> this.classToMessageTypeMap.put((Class<?>)e.getValue(), (Integer)e.getKey()));
    }

    public Integer getMessageType(Class<?> clazz) {
        return this.classToMessageTypeMap.get(clazz);
    }

    public Class<?> getMessageClass(Integer messageType) {
        return this.messageTypeIdToClassMap.get(messageType);
    }

    public Set<Integer> getRegisteredMessageTypes() {
        return this.messageTypeIdToClassMap.keySet();
    }
}

