/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.mhf.msg;

import com.boom.netty.ws.mhf.msg.MessageBase;

public class BarrelMessage
extends MessageBase {
    private final int msgType;
    private String origSource;
    private String origTarget;
    private String origOperationId;
    private byte[] origPayload;
    private MessageBase originalMessage;

    public BarrelMessage(String target, String operationId, MessageBase originalMessage) {
        super(target, operationId);
        this.originalMessage = originalMessage;
        this.msgType = originalMessage.getMessageTypeId();
        this.origSource = originalMessage.getSource();
        this.origTarget = originalMessage.getTarget();
        this.origOperationId = originalMessage.getOperationId();
        this.origPayload = originalMessage.getBytesPayload();
    }

    public String getOrigSource() {
        return this.origSource;
    }

    public String getOrigTarget() {
        return this.origTarget;
    }

    public String getOrigOperationId() {
        return this.origOperationId;
    }

    public MessageBase getOriginalMessage() {
        return this.originalMessage;
    }

    public BarrelMessage applyAfterDeserialization() {
        this.originalMessage.setMessageTypeId(this.msgType);
        this.originalMessage.setSource(this.origSource);
        this.originalMessage.setTarget(this.origTarget);
        this.originalMessage.setOperationId(this.origOperationId);
        this.originalMessage.setBytesPayload(this.origPayload);
        return this;
    }

    public int getOrigMessageType() {
        return this.msgType;
    }

    public BarrelMessage setOriginalMessage(MessageBase orig) {
        this.originalMessage = orig;
        return this;
    }
}

