/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.server;

import com.boom.netty.ws.server.WebSocketInitializationException;
import com.boom.netty.ws.server.WebSocketServerChannelInitializer;
import com.boom.netty.ws.server.WebSocketServerEventHandler;
import com.boom.netty.ws.server.stats.TrafficStatisticCapturingHandler;
import com.boom.netty.ws.server.stats.TrafficStatistics;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.traffic.TrafficCounter;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServer {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketServer.class);
    private final String address;
    private final int port;
    private final Set<String> allowedRegions;
    private final WebSocketServerEventHandler eventHandler;
    private final EventLoopGroup bossGroup = new NioEventLoopGroup(1);
    private final EventLoopGroup workerGroup = new NioEventLoopGroup(5);
    private final ScheduledExecutorService trafficCounterExecutorServer = Executors.newSingleThreadScheduledExecutor();
    private final ServerBootstrap bootstrap = new ServerBootstrap();
    private final Charset charset;
    private final KeyManagerFactory factory;
    private final boolean skipCertificateValidation;
    private final boolean requireClientCertificates;
    private final KeyStore trustStore;
    private final TrafficStatisticCapturingHandler globalTrafficShapingHandler;

    public WebSocketServer(String address, int port, Set<String> allowedRegions, WebSocketServerEventHandler eventHandler, Charset charset, KeyStore trustStore, KeyManagerFactory factory, boolean skipCertificateValidation, boolean requireClientCertificates, Consumer<TrafficStatistics> trafficStatisticsConsumer) {
        this.address = address;
        this.port = port;
        this.allowedRegions = allowedRegions;
        this.eventHandler = eventHandler;
        this.charset = charset;
        this.factory = factory;
        this.trustStore = trustStore;
        this.skipCertificateValidation = skipCertificateValidation;
        this.requireClientCertificates = requireClientCertificates;
        this.globalTrafficShapingHandler = trafficStatisticsConsumer == null ? null : new TrafficStatisticCapturingHandler(this.trafficCounterExecutorServer, 15000L, trafficStatisticsConsumer);
    }

    public void runServer() throws InterruptedException, WebSocketInitializationException {
        WebSocketServerChannelInitializer channelInitializer = null;
        try {
            channelInitializer = new WebSocketServerChannelInitializer(this, this.allowedRegions, this.charset, this.trustStore, this.factory, this.skipCertificateValidation, this.requireClientCertificates, this.globalTrafficShapingHandler);
            ((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(channelInitializer).childOption(ChannelOption.SO_KEEPALIVE, true).childOption(ChannelOption.AUTO_READ, true);
            this.bootstrap.bind(this.address, this.port).sync();
            logger.info("WebSocketServer listening on {}:{}", (Object)this.address, (Object)this.port);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | SSLException e) {
            throw new WebSocketInitializationException("Could not initialize web socket", e);
        }
    }

    public void connectionOpened(Channel channel) {
        logger.debug("WS connection opened: {}", (Object)channel);
        this.eventHandler.connectionOpened(channel);
    }

    public void wsHandshakeFinished(Channel channel) {
        logger.debug("WS handshake finished: {}", (Object)channel);
        this.eventHandler.handshakeFinished(channel);
    }

    public void connectionClosed(Channel channel) {
        logger.debug("WS connection closed: {}", (Object)channel);
        this.eventHandler.connectionClosed(channel);
    }

    public void shutdownGracefully() {
        logger.info("WebSocketServer graceful shut down...");
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        this.trafficCounterExecutorServer.shutdown();
    }

    public void shutdownNow() throws InterruptedException {
        logger.info("WebSocketServer immediate shut down...");
        this.bossGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS).sync();
        this.workerGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS).sync();
        this.trafficCounterExecutorServer.shutdownNow();
    }

    public TrafficCounter getTrafficCounter() {
        return this.globalTrafficShapingHandler.trafficCounter();
    }
}

