/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.server;

import com.boom.netty.ws.mhf.MessageCodec;
import com.boom.netty.ws.server.WebSocketServer;
import com.boom.netty.ws.server.WebSocketServerCloseHandler;
import com.boom.netty.ws.server.WebSocketServerHandshakeHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

public class WebSocketServerChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final WebSocketServer server;
    private final Set<String> allowedRegions;
    private final Charset charset;
    private SslContext serverSslContext;
    private KeyStore trustStore;
    private final GlobalTrafficShapingHandler globalTrafficShapingHandler;

    public WebSocketServerChannelInitializer(WebSocketServer server, Set<String> allowedRegions, Charset charset, KeyStore trustStore, KeyManagerFactory factory, boolean skipCertificateValidation, boolean requireClientCertificates, GlobalTrafficShapingHandler globalTrafficShapingHandler) throws SSLException, NoSuchAlgorithmException, KeyStoreException {
        this.server = server;
        this.allowedRegions = allowedRegions;
        this.charset = charset;
        this.trustStore = trustStore;
        this.globalTrafficShapingHandler = globalTrafficShapingHandler;
        this.serverSslContext = factory != null ? SslContextBuilder.forServer(factory).trustManager(this.getTrustManagerFactory(skipCertificateValidation)).clientAuth(requireClientCertificates ? ClientAuth.REQUIRE : ClientAuth.NONE).build() : null;
    }

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        this.server.connectionOpened(ch);
        if (this.serverSslContext != null) {
            SslHandler sslHandler = this.serverSslContext.newHandler(ch.alloc());
            ch.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
        }
        ch.pipeline().addLast(new HttpServerCodec()).addLast(new WebSocketServerHandshakeHandler(this.allowedRegions, this.server)).addLast(new WebSocketServerCloseHandler());
        if (this.globalTrafficShapingHandler != null) {
            ch.pipeline().addLast(this.globalTrafficShapingHandler);
        }
        ch.pipeline().addLast(new ChunkedWriteHandler()).addLast(new ChannelHandler[]{new MessageCodec(this.charset)});
        ch.closeFuture().addListener(future -> this.server.connectionClosed(ch));
    }

    public TrustManagerFactory getTrustManagerFactory(boolean skipCertificateValidation) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory;
        if (skipCertificateValidation) {
            factory = InsecureTrustManagerFactory.INSTANCE;
        } else {
            factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (this.trustStore != null) {
                factory.init(this.trustStore);
            }
        }
        return factory;
    }
}

