/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServerCloseHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketServerCloseHandler.class);
    private boolean closeFrameSent = false;

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame frame = (CloseWebSocketFrame)msg;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Close frame received {}: {}", (Object)frame.statusCode(), (Object)frame.reasonText());
            }
            if (!this.closeFrameSent) {
                ctx.writeAndFlush(msg).addListener(future -> {
                    if (!future.isSuccess()) {
                        throw new RuntimeException(future.cause());
                    }
                    LOGGER.debug("Response close frame written");
                }).sync();
            }
            ctx.close();
        } else {
            super.channelRead(ctx, msg);
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object userEvent) {
        if ("WS_CHANNEL_CLOSE_EVENT".equals(userEvent)) {
            this.closeFrameSent = true;
            ctx.writeAndFlush(new CloseWebSocketFrame(1000, "Server close"));
        } else {
            ctx.fireUserEventTriggered(userEvent);
        }
    }
}

