/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.server;

import com.boom.netty.ws.common.WsConstants;
import com.boom.netty.ws.common.WsUtils;
import com.boom.netty.ws.server.WebSocketServer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServerHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketServerHandshakeHandler.class);
    private final Set<String> allowedRegions;
    private final WebSocketServer webSocketServer;

    public WebSocketServerHandshakeHandler(Set<String> allowedRegions, WebSocketServer webSocketServer) {
        this.allowedRegions = allowedRegions;
        this.webSocketServer = webSocketServer;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            HttpHeaders headers = httpRequest.headers();
            if ("Upgrade".equalsIgnoreCase(headers.get(HttpHeaderNames.CONNECTION)) && "WebSocket".equalsIgnoreCase(headers.get(HttpHeaderNames.UPGRADE))) {
                logger.debug("WS Handshake started");
                String regionId = headers.get("REGION_ID");
                String accessToken = headers.get("ACCESS_TOKEN");
                String endpoint = headers.get("CHANNEL_ENDPOINT");
                if (accessToken == null) {
                    logger.warn("WS request headers do not contain access token.");
                    WsUtils.sendUnauthorized(ctx.channel());
                    return;
                }
                if (regionId == null) {
                    logger.warn("Region ID not recognized in access token.");
                    WsUtils.sendUnauthorized(ctx.channel());
                    return;
                }
                if (!this.allowedRegions.contains(regionId)) {
                    logger.warn("Region ID {} is not allowed in central region configuration.", (Object)regionId);
                    WsUtils.sendUnauthorized(ctx.channel());
                    return;
                }
                ctx.channel().attr(WsConstants.WS_REGION_ID_ATTR).set(regionId);
                ctx.channel().attr(WsConstants.WS_CHANNEL_ENDPOINT_ATTR).set(endpoint);
                this.handleHandshake(ctx, httpRequest);
                this.webSocketServer.wsHandshakeFinished(ctx.channel());
                ctx.pipeline().remove(this);
                logger.debug("WS Handshake finished");
                ctx.fireChannelActive();
            } else {
                logger.warn("Unrecognized HTTP request. Websocket handshake not started. {}", msg);
            }
        } else {
            logger.debug("Unexpected incoming data: {}", msg);
        }
    }

    protected void handleHandshake(ChannelHandlerContext ctx, HttpRequest req) {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(req), "boom-v1", true, 65536);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(req);
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(ctx.channel());
        } else {
            handshaker.handshake(ctx.channel(), req);
        }
    }

    protected String getWebSocketURL(HttpRequest req) {
        return "ws://" + req.headers().get(HttpHeaderNames.HOST) + req.uri();
    }
}

