/*
 * Decompiled with CFR 0.152.
 */
package com.boom.netty.ws.server.stats;

import com.boom.netty.ws.server.stats.TrafficStatistics;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.netty.handler.traffic.TrafficCounter;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficStatisticCapturingHandler
extends GlobalTrafficShapingHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrafficStatisticCapturingHandler.class);
    private final Consumer<TrafficStatistics> statisticsConsumer;
    private final long nanoTimeDifference;

    public TrafficStatisticCapturingHandler(ScheduledExecutorService executor, long checkInterval, Consumer<TrafficStatistics> statisticsConsumer) {
        super(executor, checkInterval);
        this.statisticsConsumer = statisticsConsumer;
        this.checkInterval = checkInterval;
        this.nanoTimeDifference = System.currentTimeMillis() - TrafficCounter.milliSecondFromNano();
    }

    @Override
    protected void doAccounting(TrafficCounter counter) {
        super.doAccounting(counter);
        try {
            this.statisticsConsumer.accept(new TrafficStatistics(counter.lastWriteThroughput(), counter.lastReadThroughput(), counter.lastWrittenBytes(), counter.lastReadBytes(), counter.lastTime() + this.nanoTimeDifference, this.getCheckInterval()));
        }
        catch (Exception e) {
            LOGGER.debug("error processing TrafficCounter {}", (Object)this.trafficCounter, (Object)e);
        }
    }
}

