/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import java.util.Queue;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthOption;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.ContextAwareAuthScheme;
import org.apache.http.auth.Credentials;
import org.apache.http.protocol.HttpContext;

abstract class RequestAuthenticationBase
implements HttpRequestInterceptor {
    void process(AuthState authState, HttpRequest request, HttpContext context) throws HttpException, IOException {
        AuthScheme authScheme = authState.getAuthScheme();
        Credentials creds = authState.getCredentials();
        switch (authState.getState()) {
            case FAILURE: {
                return;
            }
            case SUCCESS: {
                this.ensureAuthScheme(authScheme);
                if (!authScheme.isConnectionBased()) break;
                return;
            }
            case CHALLENGED: {
                Queue<AuthOption> authOptions = authState.getAuthOptions();
                if (authOptions != null) {
                    while (!authOptions.isEmpty()) {
                        AuthOption authOption = authOptions.remove();
                        authScheme = authOption.getAuthScheme();
                        creds = authOption.getCredentials();
                        authState.update(authScheme, creds);
                        try {
                            Header header = this.authenticate(authScheme, creds, request, context);
                            request.addHeader(header);
                            break;
                        }
                        catch (AuthenticationException authenticationException) {
                        }
                    }
                    return;
                }
                this.ensureAuthScheme(authScheme);
            }
        }
        if (authScheme != null) {
            try {
                Header header = this.authenticate(authScheme, creds, request, context);
                request.addHeader(header);
            }
            catch (AuthenticationException authenticationException) {
                // empty catch block
            }
        }
    }

    private void ensureAuthScheme(AuthScheme authScheme) {
        if (authScheme == null) {
            throw new IllegalStateException("Auth scheme is not set");
        }
    }

    private Header authenticate(AuthScheme authScheme, Credentials creds, HttpRequest request, HttpContext context) throws AuthenticationException {
        if (authScheme == null) {
            throw new IllegalStateException("Auth state object is null");
        }
        if (authScheme instanceof ContextAwareAuthScheme) {
            return ((ContextAwareAuthScheme)authScheme).authenticate(creds, request, context);
        }
        return authScheme.authenticate(creds, request);
    }
}

