/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteTracker;
import org.apache.http.pool.PoolEntry;

class HttpPoolEntry
extends PoolEntry<HttpRoute, OperatedClientConnection> {
    private final RouteTracker tracker;

    public HttpPoolEntry(String id, HttpRoute route, OperatedClientConnection conn, long timeToLive, TimeUnit tunit) {
        super(id, route, conn, timeToLive, tunit);
        this.tracker = new RouteTracker(route);
    }

    @Override
    public boolean isExpired(long now) {
        boolean expired = super.isExpired(now);
        return expired;
    }

    RouteTracker getTracker() {
        return this.tracker;
    }

    HttpRoute getPlannedRoute() {
        return (HttpRoute)this.getRoute();
    }

    HttpRoute getEffectiveRoute() {
        return this.tracker.toRoute();
    }

    @Override
    public boolean isClosed() {
        OperatedClientConnection conn = (OperatedClientConnection)this.getConnection();
        return !conn.isOpen();
    }

    @Override
    public void close() {
        OperatedClientConnection conn = (OperatedClientConnection)this.getConnection();
        try {
            conn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

