/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.actions;

import com.blixx.agent.actions.AbstractAction;
import com.blixx.agent.monitors.HTTPMonitor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class HttpAction
extends AbstractAction {
    public int m_responseCode = 0;
    public String m_output = "Unknown error";
    public String m_reason = "";

    public static AbstractAction getInstance(String monitor, String[] parameters) {
        HttpAction aa = new HttpAction();
        aa.m_parameters = parameters;
        aa.m_monitor = monitor;
        return aa;
    }

    public String run(String[] parameters, int timeout) {
        if (parameters == null || parameters.length == 0) {
            return "Please specify an URL";
        }
        HTTPMonitor mon = new HTTPMonitor();
        try {
            URL url = new URL(parameters[0]);
            this.m_responseCode = mon.isAvailable(url);
            this.m_output = mon.m_output;
            this.m_reason = mon.m_reason;
        }
        catch (MalformedURLException e) {
            this.m_output = "ERROR: Malformed URL";
        }
        if (this.m_output == null) {
            this.m_output = this.m_reason != null && this.m_reason.length() > 0 ? "Response code: (" + this.m_responseCode + ") " + this.m_reason : (this.m_responseCode != 0 ? "Response code: (" + this.m_responseCode + ")" : "Error");
        }
        return this.m_output;
    }

    @Override
    public String runMonitor() {
        for (String url : this.m_parameters) {
            String result = this.run(new String[]{url}, this.m_interval);
            HashMap<String, String> opts = new HashMap<String, String>(3);
            opts.put("POLICY_NAME", this.m_monitor);
            opts.put("STATUS", "" + this.m_responseCode);
            opts.put("ERROR", "" + this.m_reason);
            this.m_messageSubmitter.sendMessage(null, "", "", url, result, "normal", opts);
            this.m_monitorSubmitter.submitMonitorValue(this.m_monitor, (double)this.m_responseCode, url, null);
        }
        return null;
    }
}

