/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.actions;

import com.blixx.agent.actions.AbstractAction;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JmxAction
extends AbstractAction {
    private String m_url = null;
    private String m_user = null;
    private String m_password = null;
    private String m_ObjectName = "*:*";
    private String m_attribute = null;
    private String m_valueMask = null;
    private Map<String, Object> m_env = new HashMap<String, Object>();
    private JMXConnector m_jmxConnector = null;
    private MBeanServerConnection m_connection = null;

    public static AbstractAction getInstance(String monitor, String[] parameters) {
        JmxAction aa = new JmxAction();
        aa.m_parameters = parameters;
        aa.m_monitor = monitor;
        return aa;
    }

    public void connect(String url, String user, String password) throws IOException, MalformedURLException {
        this.m_env.put("jmx.client.name", "boomJmxAction");
        if (user != null) {
            if (password == null) {
                password = "";
            }
            String[] up = new String[]{user, password};
            this.m_env.put("jmx.remote.credentials", up);
        }
        JMXServiceURL jmxURL = new JMXServiceURL(url);
        this.m_jmxConnector = JMXConnectorFactory.connect(jmxURL, this.m_env);
        this.m_connection = this.m_jmxConnector.getMBeanServerConnection();
    }

    public void close() {
        try {
            this.m_jmxConnector.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public StringBuffer list(String name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException, MalformedObjectNameException {
        QueryExp queryExp = null;
        ObjectName oname = null;
        if (name != null) {
            oname = ObjectName.getInstance(name);
        }
        return this.list(oname, queryExp);
    }

    public StringBuffer list(ObjectName objname, QueryExp query) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        StringBuffer sb = new StringBuffer();
        Set<ObjectName> names = this.m_connection.queryNames(objname, query);
        for (ObjectName name : names) {
            try {
                this.fetchMBean(sb, name);
            }
            catch (Throwable t) {
                System.err.println(name + " " + t.getMessage());
                t.printStackTrace();
            }
        }
        return sb;
    }

    private void fetchMBean(StringBuffer sb, ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        MBeanInfo info = this.m_connection.getMBeanInfo(name);
        MBeanAttributeInfo[] attrs = info.getAttributes();
        String[] attrsNames = new String[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            attrsNames[i] = attrs[i].getName();
        }
        AttributeList list = this.m_connection.getAttributes(name, attrsNames);
        for (Attribute at : list) {
            try {
                String ca;
                Object value = at.getValue();
                if (value instanceof String[]) {
                    String[] arr = (String[])value;
                    value = Arrays.asList(arr);
                } else if (value instanceof CompositeData) {
                    CompositeData cdata = (CompositeData)value;
                    CompositeType ct = cdata.getCompositeType();
                    Set<String> keys = ct.keySet();
                    Iterator<String> it = keys.iterator();
                    StringBuffer sbV = new StringBuffer();
                    while (it.hasNext()) {
                        String key = it.next();
                        Object val = cdata.get(key);
                        sbV.append(key).append("==").append(val).append(" ");
                    }
                    value = sbV.toString();
                } else if (value instanceof ObjectName[]) {
                    ObjectName[] oN = (ObjectName[])value;
                    value = Arrays.asList(oN);
                } else if (value instanceof String && (ca = (String)value).startsWith("<?xml")) continue;
                sb.append(name.getCanonicalName()).append(":").append(at.getName()).append(" -> ").append(value).append("\n");
            }
            catch (Throwable throwable) {}
        }
    }

    public StringBuffer listMBeans(ObjectName objname, QueryExp query) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        StringBuffer sb = new StringBuffer();
        Set<ObjectInstance> names = this.m_connection.queryMBeans(objname, query);
        for (ObjectInstance obj : names) {
            try {
                StringBuffer nn = new StringBuffer();
                this.fetchMBean(nn, obj.getObjectName());
                sb.append(nn);
            }
            catch (Throwable nn) {
                try {
                    MBeanInfo info = this.m_connection.getMBeanInfo(obj.getObjectName());
                    MBeanAttributeInfo[] attrs = info.getAttributes();
                    for (int i = 0; i < attrs.length; ++i) {
                        try {
                            String ca;
                            Object value = this.m_connection.getAttribute(obj.getObjectName(), attrs[i].getName());
                            if (value instanceof String[]) {
                                String[] arr = (String[])value;
                                value = Arrays.asList(arr);
                            } else if (value instanceof CompositeData) {
                                CompositeData cdata = (CompositeData)value;
                                CompositeType ct = cdata.getCompositeType();
                                Set<String> keys = ct.keySet();
                                Iterator<String> it = keys.iterator();
                                StringBuffer sbV = new StringBuffer();
                                while (it.hasNext()) {
                                    String key = it.next();
                                    Object val = cdata.get(key);
                                    sbV.append(key).append("==").append(val).append(" ");
                                }
                                value = sbV.toString();
                            } else if (value instanceof ObjectName[]) {
                                ObjectName[] oN = (ObjectName[])value;
                                value = Arrays.asList(oN);
                            } else if (value instanceof String && (ca = (String)value).startsWith("<?xml")) continue;
                            sb.append(obj.getObjectName().getCanonicalName()).append(":").append(attrs[i].getName()).append(" -> ").append(value).append("\n");
                            continue;
                        }
                        catch (Throwable e) {
                            sb.append(obj.getObjectName().getCanonicalName()).append(":").append(attrs[i].getName()).append(" -> ").append("UNSERIALIZABLE").append("\n");
                        }
                    }
                }
                catch (Throwable e) {
                    sb.append(obj.getObjectName().getCanonicalName()).append(":").append(" -> ").append("NULL").append("\n");
                }
            }
        }
        return sb;
    }

    public String run(String[] parameters, int timeout) {
        String string;
        if (parameters == null || parameters.length == 0) {
            return this.usage();
        }
        try {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].equals("-u")) {
                    this.m_url = parameters[++i];
                    continue;
                }
                if (parameters[i].equals("-l")) {
                    this.m_user = parameters[++i];
                    continue;
                }
                if (parameters[i].equals("-p")) {
                    this.m_password = parameters[++i];
                    continue;
                }
                if (parameters[i].equals("-o")) {
                    this.m_ObjectName = parameters[++i];
                    continue;
                }
                if (parameters[i].equals("-a")) {
                    this.m_attribute = parameters[++i];
                    continue;
                }
                if (parameters[i].equals("-v")) {
                    this.m_valueMask = parameters[++i];
                    continue;
                }
                if (!parameters[i].startsWith("-D")) continue;
                String rr = parameters[i].substring(2);
                String[] pv = rr.split("=");
                if (pv.length == 2) {
                    this.m_env.put(pv[0], pv[1]);
                    continue;
                }
                if (pv.length == 1) {
                    this.m_env.put(rr, "");
                    continue;
                }
                String name = rr.substring(0, rr.indexOf(61));
                String value = rr.substring(name.length() + 2);
                this.m_env.put(name, value);
            }
            if (this.m_url == null) {
                String i = this.usage();
                return i;
            }
            this.connect(this.m_url, this.m_user, this.m_password);
            ObjectName objname = null;
            if (this.m_ObjectName != null) {
                objname = new ObjectName(this.m_ObjectName);
            }
            QueryExp query = null;
            if (this.m_attribute != null && this.m_valueMask != null) {
                query = Query.match(Query.attr(this.m_attribute), Query.value(this.m_valueMask));
            }
            string = this.listMBeans(objname, query).toString();
        }
        catch (Throwable e) {
            RuntimeException re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        finally {
            try {
                this.m_jmxConnector.close();
            }
            catch (Throwable rr) {}
        }
        return string;
    }

    public String usage() {
        StringBuffer sb = new StringBuffer();
        sb.append("Usage:\n");
        sb.append("IAction ").append(JmxAction.class.getCanonicalName()).append(" [options] -u <url>\n");
        sb.append(" where options:\n");
        sb.append("  -l <login>\n");
        sb.append("  -p <password>\n");
        sb.append("  -o <objecName>, like \"java.*:type=Memory\"\n");
        sb.append("  -a <attribute>\n");
        sb.append("  -v <valueMask>\n");
        sb.append("  -D<environment variables>\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        JmxAction jmx1 = new JmxAction();
        try {
            jmx1.connect("service:jmx:rmi:///jndi/rmi://blixx22.blixx.de:7777/jmxrmi", null, null);
            StringBuffer sb1 = jmx1.listMBeans(ObjectName.getInstance("jboss*:*,j2eeType=Servlet"), null);
            System.out.println("******* JBOSS *******");
            FileOutputStream fos = new FileOutputStream("JMX.out");
            fos.write(sb1.toString().getBytes());
            fos.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

