/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.actions;

import com.blixx.agent.actions.AbstractAction;
import com.blixx.ext.IMessage;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.InteractiveCallback;
import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SshAction
extends AbstractAction {
    private AdvancedVerifier VERIFIER = new AdvancedVerifier();
    private static final String WRONG_NUM_PARAMS = "Number of specified parameters is wrong. Expected <hostname> <user> <pass> <cmd>.";
    final String knownHostPath = "sshaction.known_hosts";
    final String idDSAPath = "sshaction.dsa";
    final String idRSAPath = "sshaction.rsa";
    KnownHosts database = new KnownHosts();
    private long m_timeout = 60000L;
    private IMessage m_msgSubmitter = null;
    private String m_monitorName = null;

    public static AbstractAction getInstance(String monitor, String[] parameters) {
        SshAction aa = new SshAction();
        aa.m_parameters = parameters;
        aa.m_monitor = monitor;
        return aa;
    }

    public String run(String[] parameters, int timeout) {
        this.m_timeout = timeout * 1000;
        if (parameters.length < 4) {
            return WRONG_NUM_PARAMS;
        }
        return this.remoteCommand(parameters[0].trim(), parameters[1].trim(), parameters[2].trim(), parameters[3].trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String remoteCommand(String hostname, String username, String password, String command) {
        long start = System.currentTimeMillis();
        Session sess = null;
        Connection conn = null;
        StringBuffer sb = new StringBuffer();
        try {
            String line;
            String line2;
            block46: {
                File knownHostFile = new File("sshaction.known_hosts");
                if (!knownHostFile.exists()) {
                    knownHostFile.createNewFile();
                }
                try {
                    this.database.addHostkeys(knownHostFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                conn = new Connection(hostname);
                String[] hostkeyAlgos = this.database.getPreferredServerHostkeyAlgorithmOrder(hostname);
                if (hostkeyAlgos != null) {
                    conn.setServerHostKeyAlgorithms(hostkeyAlgos);
                }
                conn.connect(this.VERIFIER);
                boolean enableKeyboardInteractive = true;
                boolean enableDSA = true;
                boolean enableRSA = true;
                String lastError = null;
                while (true) {
                    boolean res;
                    if ((enableDSA || enableRSA) && conn.isAuthMethodAvailable(username, "publickey")) {
                        File key;
                        if (enableDSA) {
                            key = new File("sshaction.dsa");
                            if (key.exists()) {
                                res = conn.authenticateWithPublicKey(username, key, username);
                                if (res) break block46;
                                lastError = "DSA authentication failed.";
                            }
                            enableDSA = false;
                        }
                        if (!enableRSA) continue;
                        key = new File("sshaction.rsa");
                        if (key.exists()) {
                            res = conn.authenticateWithPublicKey(username, key, password);
                            if (res) break block46;
                            lastError = "RSA authentication failed.";
                        }
                        enableRSA = false;
                        continue;
                    }
                    if (enableKeyboardInteractive && conn.isAuthMethodAvailable(username, "keyboard-interactive")) {
                        InteractiveLogic il = new InteractiveLogic(lastError, password);
                        res = conn.authenticateWithKeyboardInteractive(username, il);
                        if (!res) {
                            if (il.getPromptCount() == 0) {
                                lastError = "Keyboard-interactive does not work.";
                                enableKeyboardInteractive = false;
                                continue;
                            }
                            lastError = "Keyboard-interactive auth failed.";
                            continue;
                        }
                    } else {
                        if (!conn.isAuthMethodAvailable(username, "password")) break;
                        boolean res2 = conn.authenticateWithPassword(username, password);
                        if (!res2) {
                            lastError = "Password authentication failed.";
                            continue;
                        }
                    }
                    break block46;
                    break;
                }
                throw new IOException("No supported authentication methods available.");
            }
            sess = conn.openSession();
            sess.execCommand(command);
            StreamGobbler stdout = new StreamGobbler(sess.getStdout());
            StreamGobbler stderr = new StreamGobbler(sess.getStderr());
            BufferedReader brStderr = new BufferedReader(new InputStreamReader(stderr));
            BufferedReader brStdout = new BufferedReader(new InputStreamReader(stdout));
            while (System.currentTimeMillis() - start < this.m_timeout && (line2 = brStdout.readLine()) != null) {
                sb.append(line2).append("\n");
            }
            boolean isErrFound = false;
            start = System.currentTimeMillis();
            while (System.currentTimeMillis() - start < 1000L && (line = brStderr.readLine()) != null) {
                if (!isErrFound) {
                    isErrFound = true;
                    sb.append("\nSTDERR:\n");
                }
                sb.append(line).append("\n");
            }
            try {
                brStderr.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                brStdout.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                ((InputStream)stderr).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                ((InputStream)stdout).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (isErrFound && this.m_msgSubmitter != null) {
                this.m_msgSubmitter.sendMessage(null, "AGENT", "MONITOR", "SshAction", "ERROR:" + sb.toString(), "warning", null);
                sb = new StringBuffer();
                sb.append(this.m_monitorName).append("=-1");
            }
        }
        catch (IOException e) {
            sb.append(e.getMessage());
            if (this.m_msgSubmitter != null) {
                this.m_msgSubmitter.sendMessage(null, "AGENT", "MONITOR", "SshAction", "ERROR:" + e.getMessage(), "warning", null);
            }
        }
        finally {
            try {
                sess.close();
            }
            catch (Throwable throwable) {}
            try {
                conn.close();
            }
            catch (Throwable throwable) {}
        }
        return sb.toString();
    }

    static class InteractiveLogic
    implements InteractiveCallback {
        int promptCount = 0;
        String lastError;
        String m_password;

        public InteractiveLogic(String lastError, String password) {
            this.lastError = lastError;
            this.m_password = password;
        }

        @Override
        public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws IOException {
            String[] result = new String[numPrompts];
            for (int i = 0; i < numPrompts; ++i) {
                String[] content = new String[]{this.lastError, name, instruction, prompt[i]};
                if (this.lastError != null) {
                    this.lastError = null;
                }
                result[i] = this.m_password;
                ++this.promptCount;
            }
            return result;
        }

        public int getPromptCount() {
            return this.promptCount;
        }
    }

    class AdvancedVerifier
    implements ServerHostKeyVerifier {
        AdvancedVerifier() {
        }

        @Override
        public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
            String message;
            String host = hostname;
            String algo = serverHostKeyAlgorithm;
            int result = SshAction.this.database.verifyHostkey(hostname, serverHostKeyAlgorithm, serverHostKey);
            switch (result) {
                case 0: {
                    return true;
                }
                case 1: {
                    message = "Do you want to accept the hostkey (type " + algo + ") from " + host + " ?\n";
                    break;
                }
                case 2: {
                    message = "WARNING! Hostkey for " + host + " has changed!\nAccept anyway?\n";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            String hexFingerprint = KnownHosts.createHexFingerprint(serverHostKeyAlgorithm, serverHostKey);
            String bubblebabbleFingerprint = KnownHosts.createBubblebabbleFingerprint(serverHostKeyAlgorithm, serverHostKey);
            message = message + "Hex Fingerprint: " + hexFingerprint + "\nBubblebabble Fingerprint: " + bubblebabbleFingerprint;
            String hashedHostname = KnownHosts.createHashedHostname(hostname);
            SshAction.this.database.addHostkey(new String[]{hashedHostname}, serverHostKeyAlgorithm, serverHostKey);
            try {
                KnownHosts.addHostkeyToFile(new File("sshaction.known_hosts"), new String[]{hashedHostname}, serverHostKeyAlgorithm, serverHostKey);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
    }
}

