/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.actions;

import com.blixx.agent.actions.AbstractAction;
import com.blixx.agent.util.Exec;
import com.blixx.agent.util.ExecResult;
import com.blixx.agent.util.Utils;
import com.blixx.ext.IAction;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StrAction
extends AbstractAction {
    private String LINE_JOIN = " ";
    public Pattern m_startBlockPattern = Pattern.compile(".*");
    public Pattern m_endBlockPattern = null;
    public List<Pattern> m_acceptLinePatterns = new ArrayList<Pattern>();
    public String m_exec = null;
    public IAction m_iaction = null;
    public String[] m_iaction_params = null;
    public String m_preExec = null;
    public List<String> m_result = null;

    public static AbstractAction getInstance(String monitor, String[] parameters) {
        StrAction aa = new StrAction();
        aa.m_parameters = parameters;
        aa.m_monitor = monitor;
        return aa;
    }

    public String run(String[] parameters, int timeout) {
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].equalsIgnoreCase("-sbp")) {
                try {
                    this.m_startBlockPattern = Pattern.compile(parameters[++i], 32);
                    continue;
                }
                catch (Throwable e) {
                    throw new RuntimeException("Invalid pattern: " + parameters[i]);
                }
            }
            if (parameters[i].equalsIgnoreCase("-ebp")) {
                try {
                    this.m_endBlockPattern = Pattern.compile(parameters[++i], 32);
                    continue;
                }
                catch (Throwable e) {
                    throw new RuntimeException("Invalid pattern: " + parameters[i]);
                }
            }
            if (parameters[i].equalsIgnoreCase("-alp")) {
                try {
                    Pattern pattern = Pattern.compile(parameters[++i], 32);
                    this.m_acceptLinePatterns.add(pattern);
                    continue;
                }
                catch (Throwable e) {
                    throw new RuntimeException("Invalid pattern: " + parameters[i]);
                }
            }
            if (parameters[i].equalsIgnoreCase("-exec")) {
                this.m_exec = parameters[++i];
                continue;
            }
            if (parameters[i].equalsIgnoreCase("-ia")) {
                String IAction2 = parameters[++i];
                String[] split = Utils.split(IAction2);
                String className = Utils.removeQuotes(split[0]);
                try {
                    Class<?> actionClass = Class.forName(className);
                    Constructor<?> constr = actionClass.getConstructor(new Class[0]);
                    Object instance = constr.newInstance(new Object[0]);
                    this.m_iaction = (IAction)instance;
                }
                catch (Throwable e) {
                    try {
                        Class<?> actionClass = Class.forName(className + this.getClass().getPackage().getName());
                        Constructor<?> constr = actionClass.getConstructor(new Class[0]);
                        Object instance = constr.newInstance(new Object[0]);
                        this.m_iaction = (IAction)instance;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.m_iaction == null) {
                    throw new RuntimeException("Can't initialize IAction: " + className);
                }
                this.m_iaction_params = new String[split.length - 1];
                for (int j = 0; j < this.m_iaction_params.length; ++j) {
                    this.m_iaction_params[j] = Utils.removeQuotesStrict(split[j + 1]);
                }
                continue;
            }
            if (!parameters[i].equalsIgnoreCase("-sep")) continue;
            this.LINE_JOIN = parameters[++i];
        }
        if (this.m_exec != null) {
            this.runExec(this.m_exec, timeout);
        } else if (this.m_iaction != null) {
            this.runIAction(this.m_iaction, this.m_iaction_params, timeout);
        } else {
            new RuntimeException("Nothing to execute");
        }
        if (this.m_result != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.m_result.size(); ++i) {
                sb.append(this.m_result.get(i)).append('\n');
            }
            return sb.toString();
        }
        return null;
    }

    private void runExec(String execStr, int timeout) {
        File workDir = new File(".");
        File spiDir = new File("spi");
        if (spiDir.exists() && spiDir.isDirectory()) {
            workDir = spiDir;
        }
        try {
            ExecResult er = Exec.exec2(execStr, workDir, timeout);
            if (er.resultCode != 0 && (er.m_errorMessages != null && er.m_errorMessages.size() > 0 || er.m_outMessages == null || er.m_outMessages.size() == 0)) {
                throw new RuntimeException(er.toStringOnError());
            }
            Iterator<String> it = er.m_outMessages.iterator();
            this.processOutput(it);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void runIAction(IAction act, String[] params, int timeout) {
        try {
            String result = act.run(params, timeout);
            String[] lines = result.split("\\r?\\n");
            List<String> outMsgs = Arrays.asList(lines);
            Iterator<String> it = outMsgs.iterator();
            this.processOutput(it);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void processOutput(Iterator<String> it) {
        this.m_result = new ArrayList<String>();
        StringBuffer current = new StringBuffer();
        boolean isStartFound = false;
        block0: while (it.hasNext()) {
            StringBuffer shortNext;
            int gc;
            Matcher matcher;
            String next = it.next();
            if (isStartFound) {
                if (this.m_endBlockPattern != null && this.m_endBlockPattern.matcher(next).matches()) {
                    matcher = this.m_endBlockPattern.matcher(next);
                    matcher.matches();
                    gc = matcher.groupCount();
                    if (gc > 0) {
                        shortNext = this.getGroupsOnly(matcher);
                        current.append(shortNext);
                    } else {
                        current.append(next);
                    }
                    isStartFound = false;
                    this.m_result.add(current.toString());
                    continue;
                }
                matcher = this.m_startBlockPattern.matcher(next);
                if (matcher.matches()) {
                    String resBlock = current.toString();
                    if (resBlock.endsWith(this.LINE_JOIN)) {
                        resBlock = resBlock.substring(0, resBlock.length() - this.LINE_JOIN.length());
                    }
                    this.m_result.add(resBlock);
                    current = new StringBuffer();
                    isStartFound = true;
                    int gc2 = matcher.groupCount();
                    if (gc2 > 0) {
                        StringBuffer shortNext2 = this.getGroupsOnly(matcher);
                        current.append(shortNext2).append(this.LINE_JOIN);
                        continue;
                    }
                    current.append(next).append(this.LINE_JOIN);
                    continue;
                }
                if (this.m_acceptLinePatterns != null && this.m_acceptLinePatterns.size() > 0) {
                    for (Pattern p : this.m_acceptLinePatterns) {
                        Matcher matcher2 = p.matcher(next);
                        if (!matcher2.matches()) continue;
                        int gc3 = matcher2.groupCount();
                        if (gc3 > 0) {
                            StringBuffer shortNext3 = this.getGroupsOnly(matcher2);
                            current.append(shortNext3).append(this.LINE_JOIN);
                            continue block0;
                        }
                        current.append(next).append(this.LINE_JOIN);
                        continue block0;
                    }
                    continue;
                }
                current.append(next).append(this.LINE_JOIN);
                continue;
            }
            matcher = this.m_startBlockPattern.matcher(next);
            if (!matcher.matches()) continue;
            current = new StringBuffer();
            isStartFound = true;
            gc = matcher.groupCount();
            if (gc > 0) {
                shortNext = this.getGroupsOnly(matcher);
                current.append(shortNext).append(this.LINE_JOIN);
                continue;
            }
            current.append(next).append(this.LINE_JOIN);
        }
        if (isStartFound && current != null && current.length() > 0) {
            String resBlock = current.toString();
            if (resBlock.endsWith(this.LINE_JOIN)) {
                resBlock = resBlock.substring(0, resBlock.length() - this.LINE_JOIN.length());
            }
            this.m_result.add(resBlock);
        }
    }

    private StringBuffer getGroupsOnly(Matcher matcher) {
        StringBuffer shortNext = new StringBuffer();
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            shortNext.append(matcher.group(i));
            if (i >= matcher.groupCount()) continue;
            shortNext.append(' ');
        }
        return shortNext;
    }

    public static void main(String[] args) {
        String[] ar = new String[]{"-sbp", "PPA.*", "-alp", "Description.*", "-alp", "Inbound.*", "-alp", "Outbound.*", "-alp", ".*Collision.*", "-ebp", "Internal MAC.*", "-exec", "type f:\\lan_ksh.txt"};
        StrAction action = new StrAction();
        System.out.println(action.run(ar, 20));
    }
}

