/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.actions;

import com.blixx.agent.actions.AbstractAction;
import com.blixx.agent.actions.HttpAction;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLAction
extends HttpAction {
    public static Map<String, Integer> supportedOptions = new HashMap<String, Integer>();
    public static final int URL = 1;
    public static final int MTR = 2;
    public static final int PATH = 3;
    public static final int ATTR = 4;
    public String m_url = null;
    public List<String> m_metrics = new ArrayList<String>();
    public List<String> m_attributes = new ArrayList<String>();
    public boolean m_hierarhy = false;

    public static AbstractAction getInstance(String monitor, String[] parameters) {
        XMLAction aa = new XMLAction();
        aa.m_parameters = parameters;
        aa.m_monitor = monitor;
        return aa;
    }

    @Override
    public String run(String[] args, int timeout) {
        this.initParameters(args);
        String xmlData = super.run(new String[]{this.m_url}, timeout);
        return this.processXmlData(xmlData);
    }

    private String processXmlData(String xmlData) {
        String res = null;
        try {
            byte[] array = xmlData.getBytes();
            ByteArrayInputStream bis = new ByteArrayInputStream(array);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setNamespaceAware(true);
            dbf.setFeature("http://xml.org/sax/features/namespaces", false);
            dbf.setFeature("http://xml.org/sax/features/validation", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document doc = dbf.newDocumentBuilder().parse(bis);
            NodeList nl = doc.getChildNodes();
            if (nl == null || nl.getLength() == 0) {
                throw new RuntimeException("no data available");
            }
            LinkedList<String> records = new LinkedList<String>();
            this.printChildNodes("", nl, records);
            StringBuilder sb = new StringBuilder();
            for (String line : records) {
                sb.append(line).append('\n');
            }
            res = sb.toString();
        }
        catch (Throwable e) {
            if (this.m_responseCode != 200) {
                throw new RuntimeException("Error Getting page. HTTP Error: " + this.m_responseCode);
            }
            throw new RuntimeException("Error parsing output:\n" + xmlData, e);
        }
        return res;
    }

    private void printChildNodes(String parentPath, NodeList nl, List<String> records) {
        for (int i = 0; i < nl.getLength(); ++i) {
            StringBuilder sb;
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            String tagName = n.getNodeName();
            if (this.m_metrics.size() > 0 && this.m_metrics.contains(tagName)) {
                StringBuilder sb2 = new StringBuilder(parentPath);
                sb2.append('/').append(tagName);
                this.printAttributes(sb2, n);
                records.add(sb2.toString());
                continue;
            }
            NodeList nlNextLevel = n.getChildNodes();
            if (nlNextLevel == null || nlNextLevel.getLength() == 0) {
                if (this.m_metrics.size() > 0) continue;
                sb = new StringBuilder(parentPath);
                sb.append('/').append(tagName);
                this.printAttributes(sb, n);
                records.add(sb.toString());
                continue;
            }
            sb = new StringBuilder(parentPath);
            sb.append('/').append(tagName);
            this.printAttributes(sb, n);
            this.printChildNodes(sb.toString(), nlNextLevel, records);
        }
    }

    private void printAttributes(StringBuilder sb, Node n) {
        block4: {
            NamedNodeMap nnm = n.getAttributes();
            if (nnm == null) break block4;
            if (this.m_attributes.size() == 0) {
                for (int j = 0; j < nnm.getLength(); ++j) {
                    Node attr = nnm.item(j);
                    sb.append(' ').append(attr.getNodeName()).append("=\"").append(attr.getNodeValue()).append('\"');
                }
            } else {
                for (String attrName : this.m_attributes) {
                    Node value = nnm.getNamedItem(attrName);
                    if (value == null) continue;
                    sb.append(' ').append(attrName).append("=\"").append(value.getNodeValue()).append('\"');
                }
            }
        }
    }

    public void initParameters(String[] args) {
        block6: for (int i = 0; i < args.length; ++i) {
            String str = args[i];
            Integer integer = supportedOptions.get(str.toLowerCase());
            if (integer == null) continue;
            int param = integer;
            switch (param) {
                case 1: {
                    this.m_url = args[++i];
                    continue block6;
                }
                case 2: {
                    this.m_metrics.add(args[++i]);
                    continue block6;
                }
                case 3: {
                    this.m_hierarhy = true;
                    continue block6;
                }
                case 4: {
                    this.m_attributes.add(args[++i]);
                }
            }
        }
        if (this.m_url == null) {
            throw new RuntimeException("URL is not set");
        }
    }

    public static void main(String[] args) {
        try {
            XMLAction xa = new XMLAction();
            String res = xa.run(new String[]{"-u", "http://root:centwbs@192.168.123.156:9081/wasPerfTool/servlet/perfservlet", "--path", "-m", "CountStatistic", "-m", "TimeStatistic", "-m", "RangeStatistic", "-m", "BoundedRangeStatistic", "-m", "AverageStatistic", "-a", "name", "-a", "count", "-a", "totalTime", "-a", "mean"}, 800);
            System.out.println(res);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        supportedOptions.put("-u", 1);
        supportedOptions.put("--url", 1);
        supportedOptions.put("-m", 2);
        supportedOptions.put("--metric", 2);
        supportedOptions.put("--path", 3);
        supportedOptions.put("-a", 4);
        supportedOptions.put("--attr", 4);
    }
}

