/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.monitors.MultiFileMonitor;
import com.blixx.agent.util.RotatingFile;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.regex.Pattern;

public abstract class AbstractLogMonitor
extends MultiFileMonitor {
    protected final Pattern m_patternSplit;
    protected final boolean multiLine;
    protected boolean resetPosition;

    public AbstractLogMonitor(String monitorName, String pathPattern, String recordSplitPattern) {
        super(monitorName, pathPattern);
        if (recordSplitPattern == null || recordSplitPattern.equals(".*")) {
            this.multiLine = false;
            this.m_patternSplit = null;
        } else {
            this.multiLine = true;
            this.m_patternSplit = Pattern.compile(recordSplitPattern);
        }
    }

    protected abstract class LogMonitoringJob
    extends MultiFileMonitor.FileMonitoringJob {
        public static final String LOGPATH = "LOGPATH";
        protected HashMap<String, String> optParams;
        protected static final long MAXBUFFERSIZE = 65536L;
        protected final Pattern m_lineSplit;
        protected long m_position;
        protected boolean m_isFirst;

        protected LogMonitoringJob(RotatingFile file) {
            super(AbstractLogMonitor.this, file);
            this.m_lineSplit = Pattern.compile("\r*\n");
            this.m_position = 0L;
            this.m_isFirst = true;
            this.optParams = new HashMap();
            this.optParams.put("POLICY_NAME", AbstractLogMonitor.this.monitorName);
            this.updateParams();
            String path = this.optParams.get(LOGPATH);
            AbstractLogMonitor.this.sendMessageInternal(path, "Starting to monitor log file", "normal", this.optParams);
        }

        protected void updateParams() {
            this.optParams.put("LOGFILE", this.file.file.getName());
            try {
                this.optParams.put(LOGPATH, this.file.file.getCanonicalPath());
            }
            catch (Throwable e) {
                this.optParams.put(LOGPATH, this.file.file.getAbsolutePath());
            }
            if (this.file.groups != null) {
                for (int i = 0; i < this.file.groups.length; ++i) {
                    this.optParams.put("GRP_" + (i + 1), this.file.groups[i]);
                }
            }
            this.optParams.put("PATTERN", this.file.pattern);
        }

        protected void reportFileLost() {
            String path = this.optParams.get(LOGPATH);
            AbstractLogMonitor.this.sendError(path, "File(s) suddenly lost", "major", this.optParams);
        }

        @Override
        public void process() {
            try {
                long size = this.file.file.length();
                if (AbstractLogMonitor.this.resetPosition) {
                    this.m_position = 0L;
                } else if (this.m_position > size) {
                    this.m_position = 0L;
                } else if (this.m_isFirst) {
                    this.m_position = Math.max(0L, size);
                }
                long date = this.file.file.lastModified();
                if (date == 0L) {
                    this.reportFileLost();
                } else {
                    this.file.date = date;
                }
                this.m_isFirst = false;
                if (this.m_position < size) {
                    this.readAndProcess(size);
                }
            }
            catch (Throwable e) {
                String path = this.optParams.get(LOGPATH);
                AbstractLogMonitor.this.sendError(path, e.toString(), "major", this.optParams);
            }
        }

        @Override
        public void switchToFile(RotatingFile newFile) {
            try {
                long len = this.file.file.length();
                if (this.file.file.canRead() && this.m_position < len) {
                    this.readAndProcess(len);
                }
            }
            catch (Throwable e) {
                String path = this.optParams.get(LOGPATH);
                AbstractLogMonitor.this.sendError(path, e.toString(), "major", this.optParams);
            }
            String oldPath = this.optParams.get(LOGPATH);
            if (newFile.file.lastModified() < this.file.date) {
                this.reportFileLost();
                this.m_position = newFile.file.length();
            } else {
                this.m_position = 0L;
            }
            this.file = newFile;
            this.m_isFirst = false;
            this.updateParams();
            String name = this.optParams.get(LOGPATH);
            HashMap<String, String> params = new HashMap<String, String>(this.optParams);
            params.put("oldpath=", oldPath);
            AbstractLogMonitor.this.sendMessageInternal(name, AbstractLogMonitor.this.MONITOR_CLASS + " switched to monitor file: " + name, "normal", params);
        }

        @Override
        public void finish() {
            try {
                if (!this.file.file.canRead()) {
                    this.reportFileLost();
                }
            }
            catch (Throwable e) {
                String path = this.optParams.get(LOGPATH);
                AbstractLogMonitor.this.sendError(path, e.toString(), "major", this.optParams);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readAndProcess(long size) throws IOException {
            RandomAccessFile raf = new RandomAccessFile(this.file.file, "r");
            try {
                while (this.m_position < size) {
                    int effectiveSize;
                    raf.seek(this.m_position);
                    int bs = (int)Math.min(65536L, size - this.m_position);
                    byte[] bytes = new byte[bs];
                    raf.read(bytes);
                    String logs = new String(bytes);
                    int lp = logs.lastIndexOf(10);
                    if (lp > 0) {
                        logs = logs.substring(0, lp + 1);
                    }
                    if ((effectiveSize = logs.length()) < 3) {
                        break;
                    }
                    this.m_position += (long)effectiveSize;
                    this.processBuffer(this.m_lineSplit.split(logs));
                }
            }
            finally {
                try {
                    raf.close();
                }
                catch (Throwable throwable) {}
            }
        }

        protected void processBuffer(String[] lines) {
            if (!AbstractLogMonitor.this.multiLine) {
                for (String line : lines) {
                    this.sendMsg(line);
                }
            } else {
                StringBuilder msg = null;
                for (String line : lines) {
                    if (AbstractLogMonitor.this.m_patternSplit.matcher(line).matches()) {
                        if (msg != null) {
                            this.sendMsg(msg.toString());
                        }
                        msg = new StringBuilder();
                        msg.append(line);
                        continue;
                    }
                    if (msg == null) continue;
                    msg.append("\n").append(line);
                }
                if (msg != null) {
                    this.sendMsg(msg.toString());
                }
            }
        }

        protected abstract void sendMsg(String var1);
    }
}

