/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class AgentFreeMemory
implements IMonitorExtPerf {
    IMonitorSubmitter m_submitter = null;
    IMessage m_msgSubmitter = null;
    String m_monitorName = null;
    IPerfLog m_perf = null;
    boolean m_perfOn = false;
    String m_agentHost = null;

    public static AgentFreeMemory getInstance(String monitor, String[] args) {
        AgentFreeMemory mon = new AgentFreeMemory();
        mon.m_monitorName = monitor;
        for (String arg : args) {
            if (!"-perfOn".equals(arg)) continue;
            mon.m_perfOn = true;
        }
        try {
            FileInputStream fis = new FileInputStream("conf/agent.conf");
            Properties m_agentProps = new Properties();
            m_agentProps.load(fis);
            fis.close();
            mon.m_agentHost = m_agentProps.getProperty("AGENT_HOST");
        }
        catch (Throwable fis) {
            // empty catch block
        }
        if (mon.m_agentHost == null) {
            try {
                mon.m_agentHost = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Throwable e) {
                try {
                    mon.m_agentHost = InetAddress.getLocalHost().getHostName();
                }
                catch (Throwable e1) {
                    try {
                        mon.m_agentHost = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return mon;
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perf = submitter;
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    public String runMonitor() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long freeMemoryJava = Runtime.getRuntime().freeMemory();
        long used = total - freeMemoryJava;
        long free = maxMemory - used;
        HashMap<String, String> opts = new HashMap<String, String>();
        double maxMB = Math.round((double)maxMemory / 1048576.0);
        opts.put("MAX", maxMB + "MB");
        double totalMB = Math.round((double)total / 1048576.0);
        opts.put("TOTAL", totalMB + "MB");
        double freeMemJavaMB = Math.round((double)freeMemoryJava / 1048576.0);
        opts.put("FREEINJAVA", freeMemJavaMB + "MB");
        double freeMB = Math.round((double)free / 1048576.0);
        opts.put("FREETOTAL", freeMB + "MB");
        double freePct = freeMB * 100.0 / maxMB;
        opts.put("FREEPCT", freePct + "%");
        this.m_submitter.submitMonitorValue(this.m_monitorName, freeMB, "MB", opts);
        this.m_submitter.submitMonitorValue(this.m_monitorName, freePct, "PCT", opts);
        if (this.m_perfOn) {
            ArrayList<Object> metrics = new ArrayList<Object>(5);
            if (this.m_agentHost != null) {
                metrics.add(new PerfStringMetric("AGENTHOST", this.m_agentHost));
            }
            metrics.add(new PerfDoubleMetric("MAXMB", maxMB));
            metrics.add(new PerfDoubleMetric("TOTALMB", totalMB));
            metrics.add(new PerfDoubleMetric("FREETOTALMB", freeMB));
            metrics.add(new PerfDoubleMetric("FREEINJAVAMB", freeMemJavaMB));
            metrics.add(new PerfDoubleMetric("FREEPCT", freePct));
            this.m_perf.submitPerfRow("AGENTMEM", System.currentTimeMillis(), metrics);
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
    }
}

