/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitor;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class AsyncEventProcessingMonitor<M>
implements IMonitor {
    protected IMessage m_msgSubmitter;
    protected final String m_monitorName;
    protected LinkedBlockingQueue<M> m_queue = new LinkedBlockingQueue(10000);
    protected EventProcessor m_eventProcessor;
    protected Runnable m_eventFiler;
    protected Thread processorThread;
    protected Thread producerThread;
    protected boolean m_stop;

    protected AsyncEventProcessingMonitor(String name) {
        this.m_monitorName = name;
    }

    public final synchronized String runMonitor() {
        if (!this.m_stop) {
            if (this.producerThread == null || !this.producerThread.isAlive()) {
                this.producerThread = new Thread(this.m_eventFiler, "Message Producer " + this.m_monitorName);
                this.producerThread.start();
            }
            if (this.processorThread == null || !this.processorThread.isAlive()) {
                this.processorThread = new Thread((Runnable)this.m_eventProcessor, "Message Processor " + this.m_monitorName);
                this.processorThread.start();
            }
        }
        return this.m_monitorName + "=0";
    }

    public synchronized void stop() {
        this.m_stop = true;
        this.setMessageSubmitter(new IMessage(){

            public void sendMessage(String node, String application, String msggrp, String object, String text, String severity, HashMap optVars) {
            }
        });
        if (this.producerThread != null) {
            this.producerThread.interrupt();
        }
        if (this.processorThread != null) {
            this.processorThread.interrupt();
        }
    }

    public final void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    protected abstract class EventProcessor
    implements Runnable {
        protected EventProcessor() {
        }

        protected abstract void process(M var1);

        @Override
        public final void run() {
            while (!AsyncEventProcessingMonitor.this.m_stop) {
                Object event = null;
                try {
                    event = AsyncEventProcessingMonitor.this.m_queue.take();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (event == null) continue;
                this.process(event);
            }
        }
    }
}

