/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.Utils;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.xbill.DNS.Address;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.SimpleResolver;

public class DNSMonitor
implements IMonitorExtPerf {
    public String m_monitor = "";
    public Cfg[] probes = null;
    public IMonitorSubmitter m_submitter = null;
    public IPerfLog m_perfSubmitter = null;
    public IMessage m_msgSubmitter = null;

    public static DNSMonitor getInstance(String monitor, String[] args) {
        DNSMonitor mon = new DNSMonitor();
        mon.m_monitor = monitor;
        ArrayList<Cfg> cfgs = new ArrayList<Cfg>(args.length);
        for (int i = 0; i < args.length; ++i) {
            Cfg next = new Cfg(args[i]);
            if (next.dnsHost == null) {
                String[] servers = ResolverConfig.getCurrentConfig().servers();
                if (servers == null || servers.length == 0) {
                    throw new RuntimeException("Failed to detect system DNS servers, requested by " + i + "-th arg");
                }
                for (String dns : servers) {
                    cfgs.add(new Cfg(next, dns));
                }
                continue;
            }
            cfgs.add(next);
        }
        mon.probes = cfgs.toArray(new Cfg[cfgs.size()]);
        return mon;
    }

    private void runProbe(Cfg probe, InetAddress dns) {
        int res;
        long responseTime = -1L;
        HashMap<String, String> opVars = probe.toMap(new HashMap<String, String>());
        try {
            SimpleResolver resolver = new SimpleResolver();
            resolver.setAddress(dns);
            resolver.setTimeout(0, probe.timeout);
            resolver.setTCP(probe.tcp);
            Lookup lookup = probe.queryIP ? new Lookup(ReverseMap.fromAddress(probe.queryHost), 12) : new Lookup(probe.queryHost);
            lookup.setResolver(resolver);
            lookup.setCache(null);
            long startTime = System.nanoTime();
            lookup.run();
            int dnsres = lookup.getResult();
            switch (dnsres) {
                case 0: {
                    responseTime = (System.nanoTime() - startTime) / 1000000L;
                    res = 5;
                    Object[] ans = lookup.getAnswers();
                    if (ans.length == 1) {
                        if (probe.queryIP) {
                            opVars.put("ResolvedHost", ((Record)ans[0]).rdataToString());
                            break;
                        }
                        opVars.put("ResolvedIP", ((Record)ans[0]).rdataToString());
                        break;
                    }
                    opVars.put("answers", Arrays.toString(ans));
                    break;
                }
                case 3: 
                case 4: {
                    res = 4;
                    break;
                }
                default: {
                    res = -3;
                    break;
                }
            }
        }
        catch (UnknownHostException e) {
            opVars.put("error", e.getMessage());
            res = -6;
        }
        catch (IOException e) {
            opVars.put("error", e.getMessage());
            res = -5;
        }
        opVars.put("time", "" + responseTime);
        this.m_submitter.submitMonitorValue(this.m_monitor, (double)res, probe.dnsHost + ":AVAILABILITY", opVars);
        this.m_submitter.submitMonitorValue(this.m_monitor, (double)responseTime, probe.dnsHost + ":TIME", opVars);
        if (this.m_perfSubmitter != null) {
            ArrayList<Object> perfMetrics = new ArrayList<Object>();
            perfMetrics.add(new PerfStringMetric("HOST", probe.dnsHost));
            perfMetrics.add(new PerfStringMetric("OBJECT", probe.queryHost));
            perfMetrics.add(new PerfDoubleMetric("TIME", (double)responseTime));
            perfMetrics.add(new PerfDoubleMetric("STATUS", (double)res));
            this.m_perfSubmitter.submitPerfRow("IS_DNS", System.currentTimeMillis(), perfMetrics);
        }
    }

    public String runMonitor() {
        for (Cfg probe : this.probes) {
            try {
                InetAddress serv = probe.dnsIP ? Address.getByAddress(probe.dnsHost) : Address.getByName(probe.dnsHost);
                this.runProbe(probe, serv);
            }
            catch (UnknownHostException e) {
                this.m_submitter.submitMonitorValue(this.m_monitor, -6.0, probe.dnsHost + ":AVAILABILITY", probe.toMap(new HashMap<String, String>()));
            }
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    static class Cfg
    implements Cloneable {
        String dnsHost;
        String queryHost = "www.icann.org";
        boolean dnsIP;
        boolean queryIP;
        boolean tcp;
        int timeout = 3000;

        Cfg(Cfg copy, String dns) {
            this.dnsHost = dns;
            this.dnsIP = Cfg.isIP(dns);
            this.queryHost = copy.queryHost;
            this.queryIP = copy.queryIP;
            this.tcp = copy.tcp;
            this.timeout = copy.timeout;
        }

        static boolean isKey(String s) {
            return s.equalsIgnoreCase("-tcp") || s.equalsIgnoreCase("-udp") || s.equalsIgnoreCase("-timeout") || s.equalsIgnoreCase("-query") || s.equalsIgnoreCase("-dns");
        }

        Cfg(String composite) {
            String[] args = Utils.split(composite);
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-tcp")) {
                    this.tcp = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-udp")) {
                    this.tcp = false;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-timeout")) {
                    if (args.length == ++i || Cfg.isKey(args[i])) {
                        throw new IllegalArgumentException("Missing timeout value: " + composite);
                    }
                    try {
                        this.timeout = Integer.parseInt(args[i]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Failed to parse timeout value", e);
                    }
                }
                if (args[i].equalsIgnoreCase("-dns")) {
                    if (args.length == ++i || Cfg.isKey(args[i])) {
                        throw new IllegalArgumentException("Missing dns value: " + composite);
                    }
                    this.dnsHost = args[i];
                    this.dnsIP = Cfg.isIP(this.dnsHost);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-query")) {
                    if (args.length == ++i || Cfg.isKey(args[i])) {
                        throw new IllegalArgumentException("Missing query value: " + composite);
                    }
                    this.queryHost = args[i];
                    this.queryIP = Cfg.isIP(this.queryHost);
                    continue;
                }
                throw new IllegalArgumentException("Unknown argument: " + args[i]);
            }
        }

        HashMap<String, String> toMap(HashMap<String, String> m) {
            m.put("dnsHost", this.dnsHost);
            m.put("queryHost", this.queryHost);
            m.put("queryTcp", Boolean.toString(this.tcp));
            m.put("timeout", Integer.toString(this.timeout));
            return m;
        }

        static boolean isIP(String s) {
            return Address.toByteArray(s, 1) != null || Address.toByteArray(s, 2) != null;
        }
    }
}

