/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.Exec;
import com.blixx.agent.util.ExecResult;
import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.agent.util.NullMsgSubmitter;
import com.blixx.agent.util.STLogger;
import com.blixx.agent.util.SyntaxException;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitor;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Esxtop
implements IMonitorExtPerf {
    public static final String PERF_ESXVIRTCPU = "ESXVIRTCPU";
    public static final String PERF_ESXDISK = "ESXDISK";
    public static final String PERF_ESXNET = "ESXNET";
    public static final String PERF_ESXGUESTMEM = "ESXGUESTMEM";
    public static final String PERF_ESXGUESTCPU = "ESXGUESTCPU";
    public static final String PERF_ESXPCPU = "ESXPCPU";
    public static final String PERF_ESXPMEM = "ESXPMEM";
    public static final String PERF_ESXCOSMEM = "ESXCOSMEM";
    public static final String PERF_ESXCOSCPU = "ESXCOSCPU";
    private static final String SPI_VMSTAT_TMP = "spi/vmstat.tmp";
    private static final String SPI_ESXTOP_CFG = "spi/esxtop.cfg";
    private static final String SPI_ESXTOP_PROPS = "spi/esxtop.props";
    public static Map<String, Double> m_lines = new HashMap<String, Double>();
    public static int m_refreshInterval = 60000;
    public static int m_perfInterval = 300000;
    public static long m_lastExstopRun = 0L;
    public static long m_lastPerfRun = 0L;
    public static boolean m_propFileProcessed = false;
    public static List<String> m_perfIncludesClesses = null;
    public static File outputFile = new File("spi/vmstat.tmp");
    private static Exec m_ex = new Exec();
    protected IMonitorSubmitter m_submitter = null;
    protected IMessage m_msgSubmitter = null;
    protected String m_monitorName = null;
    protected Pattern m_pattern = null;
    protected String m_opt = null;
    protected String m_metric = null;
    public static boolean is_cfgMessageSent = false;
    public static Pattern m_digitsPattern = null;
    public static Pattern m_operand = null;
    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int DIV = 2;
    public static final int MUL = 3;
    public static final int DIV1 = 4;
    public static HashMap<String, String> m_mapDirect;
    public static HashMap<String, String> m_mapReverse;
    public static String S_PCPUL;
    public static String S_PCPU;
    public static String P_PCPUL_1M;
    public static String P_PCPUL_15M;
    public static String P_PCPUL_5M;
    public static String P_PCPU_TOTAL;
    public static String P_PCPU_PRE;
    public static String P_PCPU_SUF;
    public static String PCPU;
    public static String PCPU_NUM;
    public static String PCPU_1M;
    public static String PCPU_5M;
    public static String PCPU_15M;
    public static String PCPU_TOTAL;
    private static int m_numcpu;
    public static double m_avg1min;
    public static double m_avg5min;
    public static double m_avg15min;
    public static double m_PTotal;
    public static List<Double> m_pcpu;
    public static String S_COSMEM;
    public static String P_COSMEM_FREE;
    public static String P_COSMEM_SWFREE;
    public static String P_COSMEM_SWREAD;
    public static String P_COSMEM_SWWRITE;
    public static String P_COSMEM_SWTOTAL;
    public static String COSMEM_;
    public static String COSMEM_FREE;
    public static String COSMEM_SWFREE;
    public static String COSMEM_SWREAD;
    public static String COSMEM_SWWRITE;
    public static String COSMEM_SWTOTAL;
    public static double m_cosmem_free;
    public static double m_cosmem_swfree;
    public static double m_cosmem_swread;
    public static double m_cosmem_swwrite;
    public static double m_cosmem_swtotal;
    public static String S_CCPU;
    public static String P_CCPU_IOWAIT;
    public static String P_CCPU_IDLE;
    public static String P_CCPU_SYS;
    public static String P_CCPU_USR;
    public static String P_CCPU_SWITCH;
    public static String CCPU_;
    public static String CCPU_IOWAIT;
    public static String CCPU_IDLE;
    public static String CCPU_SYS;
    public static String CCPU_USR;
    public static String CCPU_SWITCH;
    public static double m_ccpu_iowait;
    public static double m_ccpu_idle;
    public static double m_ccpu_sys;
    public static double m_ccpu_usr;
    public static double m_ccpu_switch;
    public static String S_GCPU;
    public static Pattern P_GCPU;
    public static String P_GCPU_NAME;
    public static String P_GCPU_BUSYWAIT;
    public static String P_GCPU_CORUN;
    public static String P_GCPU_COSTOP;
    public static String P_GCPU_EXTRA;
    public static String P_GCPU_IDLE;
    public static String P_GCPU_MAXLIM;
    public static String P_GCPU_OVERLAP;
    public static String P_GCPU_READY;
    public static String P_GCPU_RUN;
    public static String P_GCPU_SYS;
    public static String P_GCPU_TOTALWAIT;
    public static String P_GCPU_USED;
    public static String P_GCPU_WAIT;
    public static String P_GCPU_ALLOCMAX;
    public static String P_GCPU_ALLOCMINLIM;
    public static String P_GCPU_ALLOCMIN;
    public static String P_GCPU_ALLOCSHARES;
    public static String P_GCPU_CELLMIG;
    public static String P_GCPU_MIG;
    public static String P_GCPU_CPUMIG;
    public static String P_GCPU_QEXP;
    public static String P_GCPU_SWITCH;
    public static String P_GCPU_WAKEUPMI;
    public static String P_GCPU_WAKEUPS;
    public static String GCPU_;
    public static String GCPU_NAME;
    public static String GCPU_BUSYWAIT;
    public static String GCPU_CORUN;
    public static String GCPU_COSTOP;
    public static String GCPU_EXTRA;
    public static String GCPU_IDLE;
    public static String GCPU_MAXLIM;
    public static String GCPU_OVERLAP;
    public static String GCPU_READY;
    public static String GCPU_RUN;
    public static String GCPU_SYS;
    public static String GCPU_TOTALWAIT;
    public static String GCPU_USED;
    public static String GCPU_WAIT;
    public static String GCPU_ALLOCMAX;
    public static String GCPU_ALLOCMINLIM;
    public static String GCPU_ALLOCMIN;
    public static String GCPU_ALLOCSHARES;
    public static String GCPU_CELLMIG;
    public static String GCPU_MIG;
    public static String GCPU_CPUMIG;
    public static String GCPU_QEXP;
    public static String GCPU_SWITCH;
    public static String GCPU_WAKEUPMI;
    public static String GCPU_WAKEUPS;
    public static HashMap<String, HashMap> m_gcpu;
    public static HashMap<String, String> m_mapDirectGCPU;
    public static HashMap<String, String> m_mapReverseGCPU;
    public static String S_GMEM;
    public static Pattern P_GMEM;
    public static String P_GMEM_NAME;
    public static String P_GMEM_ACTEST;
    public static String P_GMEM_ACTFEST;
    public static String P_GMEM_ACTNEST;
    public static String P_GMEM_ACTSEST;
    public static String P_GMEM_ALLOCMAX;
    public static String P_GMEM_ALLOCMINLIM;
    public static String P_GMEM_ALLOCMIN;
    public static String P_GMEM_ALLOCSHARES;
    public static String P_GMEM_CPREAD;
    public static String P_GMEM_CPTARGET;
    public static String P_GMEM_CLR;
    public static String P_GMEM_COMMCHARGED;
    public static String P_GMEM_COMMPPS;
    public static String P_GMEM_COMMTARGET;
    public static String P_GMEM_COWH;
    public static String P_GMEM_MEMBERS;
    public static String P_GMEM_MEMCTLMAX;
    public static String P_GMEM_MEMCTL;
    public static String P_GMEM_MEMCTLTARGET;
    public static String P_GMEM_MEMCTLB;
    public static String P_GMEM_MEMSIZE;
    public static String P_GMEM_MINCOMMTARGET;
    public static String P_GMEM_NUMAP;
    public static String P_GMEM_NUMAHOME;
    public static String P_GMEM_NUMAMEM;
    public static String P_GMEM_NUMAREBALANCE;
    public static String P_GMEM_NUMAREMOTEMEM;
    public static String P_GMEM_OVERHEADMAX;
    public static String P_GMEM_OVERHEAD;
    public static String P_GMEM_OVERHEADUW;
    public static String P_GMEM_SHARED;
    public static String P_GMEM_SHAREDSAVED;
    public static String P_GMEM_SWREAD;
    public static String P_GMEM_SWTARGET;
    public static String P_GMEM_SWWRITE;
    public static String P_GMEM_SWAPPED;
    public static String P_GMEM_TARGETSIZE;
    public static String P_GMEM_TOUCHED;
    public static String P_GMEM_ZERO;
    public static String GMEM_;
    public static String GMEM_NAME;
    public static String GMEM_ACTEST;
    public static String GMEM_ACTFEST;
    public static String GMEM_ACTNEST;
    public static String GMEM_ACTSEST;
    public static String GMEM_ALLOCMAX;
    public static String GMEM_ALLOCMINLIM;
    public static String GMEM_ALLOCMIN;
    public static String GMEM_ALLOCSHARES;
    public static String GMEM_CPREAD;
    public static String GMEM_CPTARGET;
    public static String GMEM_CLR;
    public static String GMEM_COMMCHARGED;
    public static String GMEM_COMMPPS;
    public static String GMEM_COMMTARGET;
    public static String GMEM_COWH;
    public static String GMEM_MEMBERS;
    public static String GMEM_MEMCTLMAX;
    public static String GMEM_MEMCTL;
    public static String GMEM_MEMCTLTARGET;
    public static String GMEM_MEMCTLB;
    public static String GMEM_MEMSIZE;
    public static String GMEM_MINCOMMTARGET;
    public static String GMEM_NUMAP;
    public static String GMEM_NUMAHOME;
    public static String GMEM_NUMAMEM;
    public static String GMEM_NUMAREBALANCE;
    public static String GMEM_NUMAREMOTEMEM;
    public static String GMEM_OVERHEADMAX;
    public static String GMEM_OVERHEAD;
    public static String GMEM_OVERHEADUW;
    public static String GMEM_SHARED;
    public static String GMEM_SHAREDSAVED;
    public static String GMEM_SWREAD;
    public static String GMEM_SWTARGET;
    public static String GMEM_SWWRITE;
    public static String GMEM_SWAPPED;
    public static String GMEM_TARGETSIZE;
    public static String GMEM_TOUCHED;
    public static String GMEM_ZERO;
    public static HashMap<String, HashMap> m_gmem;
    public static HashMap<String, String> m_mapDirectGMEM;
    public static HashMap<String, String> m_mapReverseGMEM;
    public static String S_MEM;
    public static String P_MEM_COS;
    public static String P_MEM_FREE;
    public static String P_MEM_KERNELMANAGED;
    public static String P_MEM_KERNEL;
    public static String P_MEM_KERNELMINFREE;
    public static String P_MEM_KERNELRESERVED;
    public static String P_MEM_KERNELSTATE;
    public static String P_MEM_KERNELUNRESERVED;
    public static String P_MEM_MACHINE;
    public static String P_MEM_CTLCURR;
    public static String P_MEM_CTLMAX;
    public static String P_MEM_CTLTARGET;
    public static String P_MEM_OVERCOMM1M;
    public static String P_MEM_OVERCOMM15M;
    public static String P_MEM_OVERCOMM5M;
    public static String P_MEM_NONKERNEL;
    public static String P_MEM_PSHARECOMMON;
    public static String P_MEM_PSHARESAVINGS;
    public static String P_MEM_PSHARESHARED;
    public static String P_MEM_SWREAD;
    public static String P_MEM_SWWRITE;
    public static String P_MEM_SWTARGET;
    public static String P_MEM_SWUSED;
    public static String MEM_;
    public static String MEM_COS;
    public static String MEM_FREE;
    public static String MEM_KERNELMANAGED;
    public static String MEM_KERNEL;
    public static String MEM_KERNELMINFREE;
    public static String MEM_KERNELRESERVED;
    public static String MEM_KERNELSTATE;
    public static String MEM_KERNELUNRESERVED;
    public static String MEM_MACHINE;
    public static String MEM_CTLCURR;
    public static String MEM_CTLMAX;
    public static String MEM_CTLTARGET;
    public static String MEM_OVERCOMM1M;
    public static String MEM_OVERCOMM15M;
    public static String MEM_OVERCOMM5M;
    public static String MEM_NONKERNEL;
    public static String MEM_PSHARECOMMON;
    public static String MEM_PSHARESAVINGS;
    public static String MEM_PSHARESHARED;
    public static String MEM_SWREAD;
    public static String MEM_SWWRITE;
    public static String MEM_SWTARGET;
    public static String MEM_SWUSED;
    public static double m_mem_COS;
    public static double m_mem_FREE;
    public static double m_mem_KERNELMANAGED;
    public static double m_mem_KERNEL;
    public static double m_mem_KERNELMINFREE;
    public static double m_mem_KERNELRESERVED;
    public static double m_mem_KERNELSTATE;
    public static double m_mem_KERNELUNRESERVED;
    public static double m_mem_MACHINE;
    public static double m_mem_CTLCURR;
    public static double m_mem_CTLMAX;
    public static double m_mem_CTLTARGET;
    public static double m_mem_OVERCOMM1M;
    public static double m_mem_OVERCOMM15M;
    public static double m_mem_OVERCOMM5M;
    public static double m_mem_NONKERNEL;
    public static double m_mem_PSHARECOMMON;
    public static double m_mem_PSHARESAVINGS;
    public static double m_mem_PSHARESHARED;
    public static double m_mem_SWREAD;
    public static double m_mem_SWWRITE;
    public static double m_mem_SWTARGET;
    public static double m_mem_SWUSED;
    public static String S_NET;
    public static Pattern P_NET;
    public static String P_NET_NAME;
    public static String P_NET_POUTDROP;
    public static String P_NET_PINDROP;
    public static String P_NET_ACTPOST;
    public static String P_NET_FULLDUPLEX;
    public static String P_NET_SPEED;
    public static String P_NET_UP;
    public static String P_NET_RECV;
    public static String P_NET_TRAN;
    public static String P_NET_PACKETRECV;
    public static String P_NET_PACKETTRAN;
    public static String NET_;
    public static String NET_NAME;
    public static String NET_POUTDROP;
    public static String NET_PINDROP;
    public static String NET_ACTPOST;
    public static String NET_FULLDUPLEX;
    public static String NET_SPEED;
    public static String NET_UP;
    public static String NET_RECV;
    public static String NET_TRAN;
    public static String NET_PACKETRECV;
    public static String NET_PACKETTRAN;
    public static HashMap<String, HashMap> m_net;
    public static HashMap<String, String> m_mapDirectNET;
    public static HashMap<String, String> m_mapReverseNET;
    public static String S_NUNO;
    public static String S_PDISK;
    public static Pattern P_DISK;
    public static String P_PDISK_NAME;
    public static String P_PDISK_USED;
    public static String P_PDISK_ABORTS;
    public static String P_PDISK_ACTIVECMD;
    public static String P_PDISK_ADPTQDEPTH;
    public static String P_PDISK_AVGDRVMS;
    public static String P_PDISK_AVGGUESTMS;
    public static String P_PDISK_AVGKERNMS;
    public static String P_PDISK_CHANNELS;
    public static String P_PDISK_CMDS;
    public static String P_PDISK_LOAD;
    public static String P_PDISK_LUNQDEPTH;
    public static String P_PDISK_LUNS;
    public static String P_PDISK_MBREADS;
    public static String P_PDISK_MBWRITES;
    public static String P_PDISK_COMS;
    public static String P_PDISK_COPYS;
    public static String P_PDISK_QCMD;
    public static String P_PDISK_READS;
    public static String P_PDISK_RESETS;
    public static String P_PDISK_SHARES;
    public static String P_PDISK_SPLITS;
    public static String P_PDISK_SPLITCOPIES;
    public static String P_PDISK_TARGETS;
    public static String P_PDISK_WORDQDEPTH;
    public static String P_PDISK_WORDS;
    public static String P_PDISK_WRITES;
    public static String PDISK_;
    public static String PDISK_NAME;
    public static String PDISK_USED;
    public static String PDISK_ABORTS;
    public static String PDISK_ACTIVECMD;
    public static String PDISK_ADPTQDEPTH;
    public static String PDISK_AVGDRVMS;
    public static String PDISK_AVGGUESTMS;
    public static String PDISK_AVGKERNMS;
    public static String PDISK_CHANNELS;
    public static String PDISK_CMDS;
    public static String PDISK_LOAD;
    public static String PDISK_LUNQDEPTH;
    public static String PDISK_LUNS;
    public static String PDISK_MBREADS;
    public static String PDISK_MBWRITES;
    public static String PDISK_COMS;
    public static String PDISK_COPYS;
    public static String PDISK_QCMD;
    public static String PDISK_READS;
    public static String PDISK_RESETS;
    public static String PDISK_SHARES;
    public static String PDISK_SPLITS;
    public static String PDISK_SPLITCOPIES;
    public static String PDISK_TARGETS;
    public static String PDISK_WORDQDEPTH;
    public static String PDISK_WORDS;
    public static String PDISK_WRITES;
    public static HashMap<String, HashMap> m_disk;
    public static HashMap<String, String> m_mapDirectPDISK;
    public static HashMap<String, String> m_mapReversePDISK;
    public static String S_VCPU;
    public static Pattern P_VCPU;
    public static String P_VCPU_NAME;
    public static String P_VCPU_BUSYWAIT;
    public static String P_VCPU_CORUN;
    public static String P_VCPU_COSTOP;
    public static String P_VCPU_EXTRA;
    public static String P_VCPU_IDLE;
    public static String P_VCPU_MAXLIM;
    public static String P_VCPU_OVERLAP;
    public static String P_VCPU_READY;
    public static String P_VCPU_RUN;
    public static String P_VCPU_SYSTEM;
    public static String P_VCPU_TOTALWAIT;
    public static String P_VCPU_USED;
    public static String P_VCPU_WAIT;
    public static String P_VCPU_ALLOCMAX;
    public static String P_VCPU_ALLOCMINLIM;
    public static String P_VCPU_ALLOCMIN;
    public static String P_VCPU_ALLOCSHARES;
    public static String P_VCPU_CELLMIG;
    public static String P_VCPU_EFFMIN;
    public static String P_VCPU_HTQUARANTINE;
    public static String P_VCPU_MIG;
    public static String P_VCPU_PCPU;
    public static String P_VCPU_CPUMIG;
    public static String P_VCPU_QEXP;
    public static String P_VCPU_SWITCH;
    public static String P_VCPU_TIMERS;
    public static String P_VCPU_WAKEUPMI;
    public static String P_VCPU_WAKEUPS;
    public static String VCPU_;
    public static String VCPU_NAME;
    public static String VCPU_BUSYWAIT;
    public static String VCPU_CORUN;
    public static String VCPU_COSTOP;
    public static String VCPU_EXTRA;
    public static String VCPU_IDLE;
    public static String VCPU_MAXLIM;
    public static String VCPU_OVERLAP;
    public static String VCPU_READY;
    public static String VCPU_RUN;
    public static String VCPU_SYSTEM;
    public static String VCPU_TOTALWAIT;
    public static String VCPU_USED;
    public static String VCPU_WAIT;
    public static String VCPU_ALLOCMAX;
    public static String VCPU_ALLOCMINLIM;
    public static String VCPU_ALLOCMIN;
    public static String VCPU_ALLOCSHARES;
    public static String VCPU_CELLMIG;
    public static String VCPU_EFFMIN;
    public static String VCPU_HTQUARANTINE;
    public static String VCPU_MIG;
    public static String VCPU_PCPU;
    public static String VCPU_CPUMIG;
    public static String VCPU_QEXP;
    public static String VCPU_SWITCH;
    public static String VCPU_TIMERS;
    public static String VCPU_WAKEUPMI;
    public static String VCPU_WAKEUPS;
    public static HashMap<String, HashMap> m_vcpu;
    public static HashMap<String, String> m_mapDirectVCPU;
    public static HashMap<String, String> m_mapReverseVCPU;
    public static STLogger logger;
    IPerfLog m_perfSubmitter = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMonitor getInstance(String monitorName, String[] parameters) {
        File props;
        Esxtop instance = new Esxtop();
        instance.m_monitorName = monitorName;
        String pattern = parameters[0];
        if (pattern.equals("") || pattern.equals("METRIC")) {
            instance.m_pattern = null;
            instance.m_metric = pattern.substring(1);
        } else {
            instance.m_pattern = Pattern.compile(pattern);
        }
        if (!outputFile.exists()) {
            try {
                outputFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!m_propFileProcessed && (props = new File(SPI_ESXTOP_PROPS)).exists()) {
            try {
                Properties p = new Properties();
                FileInputStream fis = new FileInputStream(props);
                p.load(fis);
                fis.close();
                try {
                    m_refreshInterval = Integer.parseInt(p.getProperty("REFRESH_SEC")) * 1000;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    m_perfInterval = Integer.parseInt(p.getProperty("PERFDATA_SEC")) * 1000;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                String classes = p.getProperty("PERFCLASSES");
                if (classes != null) {
                    m_perfIncludesClesses = new ArrayList<String>();
                    String[] cl = classes.split(",");
                    for (int i = 0; i < cl.length; ++i) {
                        m_perfIncludesClesses.add(cl[i].trim().toUpperCase());
                    }
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                m_propFileProcessed = true;
            }
        }
        instance.m_opt = parameters[1];
        return instance;
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    public String runMonitor() {
        Esxtop.parseEsxtop(this, false);
        if (this.m_pattern != null) {
            StringBuffer sb = new StringBuffer();
            String main = this.m_monitorName + "=";
            for (String key : m_lines.keySet()) {
                Matcher m = this.m_pattern.matcher(key);
                if (!m.matches()) continue;
                String opts = this.m_opt;
                for (int i = 1; i <= m.groupCount(); ++i) {
                    String str = m.group(i).trim();
                    opts = opts.replace("svar" + i, str);
                }
                Double value = m_lines.get(key);
                sb.append(main).append(value).append(" ").append(opts).append("\n");
            }
            return sb.toString();
        }
        this.submitValue(this.m_opt);
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
    }

    public static synchronized void parseEsxtop(Esxtop jmon, boolean test) {
        if (m_lastExstopRun + (long)m_refreshInterval < System.currentTimeMillis()) {
            try {
                m_gcpu.clear();
                m_gmem.clear();
                m_net.clear();
                m_disk.clear();
                m_vcpu.clear();
                boolean wrongInput = false;
                String[] fields = null;
                String[] values = null;
                ExecResult er = null;
                if (!test) {
                    File config = new File(SPI_ESXTOP_CFG);
                    if (config.exists()) {
                        String err0;
                        er = Exec.exec2("sh -c \"esxtop -b -d 5 -n 2 -c " + config.getCanonicalPath() + " > " + outputFile.getName() + "\"", outputFile.getParentFile(), 60);
                        if (er.resultCode != 0 && er.m_errorMessages.size() > 0 && (err0 = er.m_errorMessages.get(0)).indexOf("-- c") != -1) {
                            String msg = "Parameter '-c' doesn't supported by this version of 'esxtop'\nSome of esxtop related monitors can fail.";
                            jmon.m_msgSubmitter.sendMessage(null, "ESXTOP", "VMWARE", "MONITOR", msg, "warning", null);
                            is_cfgMessageSent = true;
                            config.delete();
                            er = Exec.exec2("sh -c \"esxtop -b -d 5 -n 2 > " + outputFile.getName() + "\"", outputFile.getParentFile(), 60);
                        }
                    } else {
                        if (!is_cfgMessageSent) {
                            String msg = "The esxtop.cfg file not found in " + new File(".").getCanonicalPath() + "\nSome of esxtop related monitors can fail.";
                            jmon.m_msgSubmitter.sendMessage(null, "ESXTOP", "VMWARE", "MONITOR", msg, "warning", null);
                            is_cfgMessageSent = true;
                        }
                        er = Exec.exec2("sh -c \"esxtop -b -d 5 -n 2 > " + outputFile.getName() + "\"", outputFile.getParentFile(), 60);
                    }
                } else {
                    er = new ExecResult();
                }
                if (er.resultCode != 0) {
                    wrongInput = true;
                    jmon.m_msgSubmitter.sendMessage(null, "ESXTOP", "VMWARE", "MONITOR", "Failed to execute esxtop\n" + er.toStringOnError(), "warning", null);
                } else {
                    FileInputStream fis = new FileInputStream(outputFile);
                    byte[] buff = new byte[16000];
                    int count = -1;
                    StringBuffer sb = new StringBuffer();
                    while ((count = fis.read(buff)) > 0) {
                        sb.append(new String(buff, 0, count));
                    }
                    String res = sb.toString();
                    String[] linex2 = (res = res.replace("\r", "")).split("\r*\n");
                    if (linex2.length < 3) {
                        return;
                    }
                    m_lastExstopRun = System.currentTimeMillis();
                    fields = linex2[0].substring(1, linex2[0].length() - 2).split("\\Q\",\"\\E");
                    if (fields.length != (values = linex2[2].substring(1, linex2[2].length() - 2).split("\\Q\",\"\\E")).length) {
                        wrongInput = true;
                        jmon.m_msgSubmitter.sendMessage(null, "ESXTOP", "VMWARE", "MONITOR", "Wrong output from esxtop. Number of fields does not match with number of values", "warning", null);
                    }
                }
                for (int i = 0; i < fields.length; ++i) {
                    Double val;
                    block20: {
                        val = new Double(-1.0);
                        if (!wrongInput) {
                            try {
                                val = Double.valueOf((String)values[i]);
                            }
                            catch (NumberFormatException e) {
                                if (values[i].indexOf(44) == -1) break block20;
                                try {
                                    val = Double.valueOf(values[i].replace(',', '.'));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    String fshort = fields[i].substring(fields[i].indexOf(92, 2) + 1);
                    Esxtop.fillMetrics(val, fshort);
                    m_lines.put(fields[i], val);
                }
                Esxtop.submitPerf(jmon);
            }
            catch (Throwable e) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bos);
                e.printStackTrace(ps);
                String stack = new String(bos.toByteArray());
                jmon.m_msgSubmitter.sendMessage(null, "ESXTOP", "VMWARE", "MONITOR", "Failed to execute esxtop\n" + e.getMessage() + "\n" + stack, "warning", null);
            }
        }
    }

    protected static void submitPerf(Esxtop jmon) {
        if (m_lastPerfRun + (long)m_perfInterval < System.currentTimeMillis()) {
            final Esxtop jmon1 = jmon;
            Thread perfSubmitter = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        jmon1.submitPerfData(System.currentTimeMillis());
                    }
                    catch (Throwable e) {
                        logger.print(1, "", e);
                    }
                }
            });
            perfSubmitter.start();
            m_lastPerfRun = System.currentTimeMillis();
        }
    }

    protected void submitPerfData(long time) {
        String hostname = "<$AGENT_HOST>";
        ArrayList<Object> metrics = new ArrayList<Object>();
        if (m_perfIncludesClesses != null && m_perfIncludesClesses.contains(PERF_ESXCOSCPU)) {
            metrics.add(new PerfStringMetric("HOST", hostname));
            metrics.add(new PerfDoubleMetric(CCPU_IOWAIT, m_ccpu_iowait));
            metrics.add(new PerfDoubleMetric(CCPU_IDLE, m_ccpu_idle));
            metrics.add(new PerfDoubleMetric(CCPU_SWITCH, m_ccpu_switch));
            metrics.add(new PerfDoubleMetric(CCPU_SYS, m_ccpu_sys));
            metrics.add(new PerfDoubleMetric(CCPU_USR, m_ccpu_usr));
            this.m_perfSubmitter.submitPerfRow(PERF_ESXCOSCPU, time, metrics);
        }
        if (m_perfIncludesClesses != null && m_perfIncludesClesses.contains(PERF_ESXCOSMEM)) {
            metrics = new ArrayList();
            metrics.add(new PerfStringMetric("HOST", hostname));
            metrics.add(new PerfDoubleMetric(COSMEM_FREE, m_cosmem_free));
            metrics.add(new PerfDoubleMetric(COSMEM_SWFREE, m_cosmem_swfree));
            metrics.add(new PerfDoubleMetric(COSMEM_SWREAD, m_cosmem_swread));
            metrics.add(new PerfDoubleMetric(COSMEM_SWWRITE, m_cosmem_swwrite));
            metrics.add(new PerfDoubleMetric(COSMEM_SWTOTAL, m_cosmem_swtotal));
            this.m_perfSubmitter.submitPerfRow(PERF_ESXCOSMEM, time, metrics);
        }
        if (m_perfIncludesClesses != null && m_perfIncludesClesses.contains(PERF_ESXPMEM)) {
            metrics = new ArrayList();
            metrics.add(new PerfStringMetric("HOST", hostname));
            metrics.add(new PerfDoubleMetric(MEM_COS, m_mem_COS));
            metrics.add(new PerfDoubleMetric(MEM_CTLCURR, m_mem_CTLCURR));
            metrics.add(new PerfDoubleMetric(MEM_CTLMAX, m_mem_CTLMAX));
            metrics.add(new PerfDoubleMetric(MEM_CTLTARGET, m_mem_CTLTARGET));
            metrics.add(new PerfDoubleMetric(MEM_FREE, m_mem_FREE));
            metrics.add(new PerfDoubleMetric(MEM_KERNEL, m_mem_KERNEL));
            metrics.add(new PerfDoubleMetric(MEM_KERNELMANAGED, m_mem_KERNELMANAGED));
            metrics.add(new PerfDoubleMetric(MEM_KERNELMINFREE, m_mem_KERNELMINFREE));
            metrics.add(new PerfDoubleMetric(MEM_KERNELRESERVED, m_mem_KERNELRESERVED));
            metrics.add(new PerfDoubleMetric(MEM_KERNELSTATE, m_mem_KERNELSTATE));
            metrics.add(new PerfDoubleMetric(MEM_KERNELUNRESERVED, m_mem_KERNELUNRESERVED));
            metrics.add(new PerfDoubleMetric(MEM_MACHINE, m_mem_MACHINE));
            metrics.add(new PerfDoubleMetric(MEM_NONKERNEL, m_mem_NONKERNEL));
            metrics.add(new PerfDoubleMetric(MEM_OVERCOMM1M, m_mem_OVERCOMM1M));
            metrics.add(new PerfDoubleMetric(MEM_OVERCOMM5M, m_mem_OVERCOMM5M));
            metrics.add(new PerfDoubleMetric(MEM_PSHARECOMMON, m_mem_PSHARECOMMON));
            metrics.add(new PerfDoubleMetric(MEM_PSHARESAVINGS, m_mem_PSHARESAVINGS));
            metrics.add(new PerfDoubleMetric(MEM_PSHARESHARED, m_mem_PSHARESHARED));
            metrics.add(new PerfDoubleMetric(MEM_SWREAD, m_mem_SWREAD));
            metrics.add(new PerfDoubleMetric(MEM_SWTARGET, m_mem_SWTARGET));
            metrics.add(new PerfDoubleMetric(MEM_SWUSED, m_mem_SWUSED));
            metrics.add(new PerfDoubleMetric(MEM_SWWRITE, m_mem_SWWRITE));
            this.m_perfSubmitter.submitPerfRow(PERF_ESXPMEM, time, metrics);
        }
        if (m_perfIncludesClesses != null && m_perfIncludesClesses.contains(PERF_ESXPCPU)) {
            metrics = new ArrayList();
            metrics.add(new PerfStringMetric("HOST", hostname));
            int size = m_pcpu.size();
            metrics.add(new PerfDoubleMetric("PCPUN", (double)size));
            for (int i = 0; i < size; ++i) {
                Double v = m_pcpu.get(i);
                metrics.add(new PerfDoubleMetric("PCPU" + i, v.doubleValue()));
            }
            metrics.add(new PerfDoubleMetric(PCPU_TOTAL, m_PTotal));
            metrics.add(new PerfDoubleMetric(PCPU_1M, m_avg1min));
            metrics.add(new PerfDoubleMetric(PCPU_5M, m_avg5min));
            this.m_perfSubmitter.submitPerfRow(PERF_ESXPCPU, time, metrics);
        }
        HashMap<String, HashMap> instances = m_gcpu;
        String className = PERF_ESXGUESTCPU;
        this.submitPerfDataForGuests(time, hostname, instances, className);
        instances = m_gmem;
        className = PERF_ESXGUESTMEM;
        this.submitPerfDataForGuests(time, hostname, instances, className);
        instances = m_net;
        className = PERF_ESXNET;
        this.submitPerfDataForGuests(time, hostname, instances, className);
        instances = m_disk;
        className = PERF_ESXDISK;
        this.submitPerfDataForGuests(time, hostname, instances, className);
        instances = m_vcpu;
        className = PERF_ESXVIRTCPU;
        this.submitPerfDataForGuests(time, hostname, instances, className);
    }

    private void submitPerfDataForGuests(long time, String hostname, Map instances, String className) {
        if (m_perfIncludesClesses != null && !m_perfIncludesClesses.contains(className)) {
            return;
        }
        try {
            for (String guestName : instances.keySet()) {
                HashMap values = (HashMap)instances.get(guestName);
                if (values == null || values.size() == 0) continue;
                ArrayList<Object> metrics = new ArrayList<Object>();
                metrics.add(new PerfStringMetric("HOST", hostname));
                metrics.add(new PerfStringMetric("GUESTHOST", guestName));
                for (String field : values.keySet()) {
                    if (field == null) continue;
                    Double val = (Double)values.get(field);
                    if (val == null) {
                        val = new Double(-1.0);
                    }
                    metrics.add(new PerfDoubleMetric(field, val.doubleValue()));
                }
                this.m_perfSubmitter.submitPerfRow(className, time, metrics);
            }
        }
        catch (Throwable e) {
            logger.print(1, "", e);
        }
    }

    private static void fillMetrics(Double val, String fshort) {
        block97: {
            if (fshort.startsWith(S_CCPU)) {
                if (fshort.endsWith(P_CCPU_IOWAIT)) {
                    m_ccpu_iowait = val;
                } else if (fshort.endsWith(P_CCPU_IDLE)) {
                    m_ccpu_idle = val;
                } else if (fshort.endsWith(P_CCPU_SWITCH)) {
                    m_ccpu_switch = val;
                } else if (fshort.endsWith(P_CCPU_SYS)) {
                    m_ccpu_sys = val;
                } else if (fshort.endsWith(P_CCPU_USR)) {
                    m_ccpu_usr = val;
                }
            } else if (fshort.startsWith(S_COSMEM)) {
                if (fshort.endsWith(P_COSMEM_FREE)) {
                    m_cosmem_free = val;
                } else if (fshort.endsWith(P_COSMEM_SWFREE)) {
                    m_cosmem_swfree = val;
                } else if (fshort.endsWith(P_COSMEM_SWREAD)) {
                    m_cosmem_swread = val;
                } else if (fshort.endsWith(P_COSMEM_SWTOTAL)) {
                    m_cosmem_swtotal = val;
                } else if (fshort.endsWith(P_COSMEM_SWWRITE)) {
                    m_cosmem_swwrite = val;
                }
            } else if (fshort.startsWith(S_MEM)) {
                if (fshort.endsWith(P_MEM_COS)) {
                    m_mem_COS = val;
                } else if (fshort.endsWith(P_MEM_CTLCURR)) {
                    m_mem_CTLCURR = val;
                } else if (fshort.endsWith(P_MEM_CTLMAX)) {
                    m_mem_CTLMAX = val;
                } else if (fshort.endsWith(P_MEM_CTLTARGET)) {
                    m_mem_CTLTARGET = val;
                } else if (fshort.endsWith(P_MEM_FREE)) {
                    m_mem_FREE = val;
                } else if (fshort.endsWith(P_MEM_KERNEL)) {
                    m_mem_KERNEL = val;
                } else if (fshort.endsWith(P_MEM_KERNELMANAGED)) {
                    m_mem_KERNELMANAGED = val;
                } else if (fshort.endsWith(P_MEM_KERNELMINFREE)) {
                    m_mem_KERNELMINFREE = val;
                } else if (fshort.endsWith(P_MEM_KERNELRESERVED)) {
                    m_mem_KERNELRESERVED = val;
                } else if (fshort.endsWith(P_MEM_KERNELSTATE)) {
                    m_mem_KERNELSTATE = val;
                } else if (fshort.endsWith(P_MEM_KERNELUNRESERVED)) {
                    m_mem_KERNELUNRESERVED = val;
                } else if (fshort.endsWith(P_MEM_MACHINE)) {
                    m_mem_MACHINE = val;
                } else if (fshort.endsWith(P_MEM_NONKERNEL)) {
                    m_mem_NONKERNEL = val;
                } else if (fshort.endsWith(P_MEM_OVERCOMM15M)) {
                    m_mem_OVERCOMM15M = val;
                } else if (fshort.endsWith(P_MEM_OVERCOMM1M)) {
                    m_mem_OVERCOMM1M = val;
                } else if (fshort.endsWith(P_MEM_OVERCOMM5M)) {
                    m_mem_OVERCOMM5M = val;
                } else if (fshort.endsWith(P_MEM_PSHARECOMMON)) {
                    m_mem_PSHARECOMMON = val;
                } else if (fshort.endsWith(P_MEM_PSHARESAVINGS)) {
                    m_mem_PSHARESAVINGS = val;
                } else if (fshort.endsWith(P_MEM_PSHARESHARED)) {
                    m_mem_PSHARESHARED = val;
                } else if (fshort.endsWith(P_MEM_SWREAD)) {
                    m_mem_SWREAD = val;
                } else if (fshort.endsWith(P_MEM_SWTARGET)) {
                    m_mem_SWTARGET = val;
                } else if (fshort.endsWith(P_MEM_SWUSED)) {
                    m_mem_SWUSED = val;
                } else if (fshort.endsWith(P_MEM_SWWRITE)) {
                    m_mem_SWWRITE = val;
                }
            } else if (fshort.startsWith(S_PCPU)) {
                if (fshort.startsWith(S_PCPUL)) {
                    if (fshort.endsWith(P_PCPU_TOTAL)) {
                        m_PTotal = val;
                    } else if (fshort.endsWith(P_PCPUL_15M)) {
                        m_avg15min = val;
                    } else if (fshort.endsWith(P_PCPUL_1M)) {
                        m_avg1min = val;
                    } else if (fshort.endsWith(P_PCPUL_5M)) {
                        m_avg5min = val;
                    }
                } else {
                    String cpuNumber = fshort.replace(P_PCPU_PRE, "");
                    if ((cpuNumber = cpuNumber.replace(P_PCPU_SUF, "")).equalsIgnoreCase("_Total")) {
                        m_PTotal = val;
                    } else {
                        int num = -1;
                        try {
                            num = Integer.parseInt(cpuNumber);
                            if (num >= m_pcpu.size()) {
                                if (num == m_pcpu.size()) {
                                    m_pcpu.add(val);
                                } else {
                                    for (int i = 0; i < num - m_pcpu.size(); ++i) {
                                        m_pcpu.add(0.0);
                                    }
                                }
                                break block97;
                            }
                            m_pcpu.set(num, val);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                Matcher m = P_GCPU.matcher(fshort);
                if (m.matches()) {
                    HashMap<String, HashMap> curr = m_gcpu;
                    Esxtop.processInstanceBased(val, m, curr, 2, m_mapReverseGCPU);
                } else {
                    m = P_GMEM.matcher(fshort);
                    if (m.matches()) {
                        HashMap<String, HashMap> curr = m_gmem;
                        Esxtop.processInstanceBased(val, m, curr, 2, m_mapReverseGMEM);
                    } else {
                        m = P_NET.matcher(fshort);
                        if (m.matches()) {
                            HashMap<String, HashMap> curr = m_net;
                            Esxtop.processInstanceBased(val, m, curr, 3, m_mapReverseNET);
                        } else {
                            m = P_DISK.matcher(fshort);
                            if (m.matches()) {
                                HashMap<String, HashMap> curr = m_disk;
                                Esxtop.processInstanceBased(val, m, curr, 2, m_mapReversePDISK);
                            } else {
                                m = P_VCPU.matcher(fshort);
                                if (m.matches()) {
                                    HashMap<String, HashMap> curr = m_vcpu;
                                    Esxtop.processInstanceBased(val, m, curr, 3, m_mapReverseVCPU);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static void processInstanceBased(Double val, Matcher m, HashMap curr, int varGroupNumber, HashMap reverseMap) {
        String image = "";
        for (int i = 1; i < varGroupNumber; ++i) {
            if (i > 1) {
                image = image + "_";
            }
            image = image + m.group(i);
        }
        String varName = m.group(varGroupNumber);
        String metricName = (String)reverseMap.get(varName);
        HashMap<String, Double> values = (HashMap<String, Double>)curr.get(image);
        if (values == null) {
            values = new HashMap<String, Double>();
        }
        values.put(metricName, val);
        curr.put(image, values);
    }

    public void submitValue(String metricName) {
        double res = -1.0;
        if (metricName.startsWith(MEM_)) {
            if (metricName.equalsIgnoreCase(MEM_KERNELSTATE)) {
                double rr = m_mem_FREE * 100.0 / (m_mem_KERNEL - m_mem_COS);
                this.m_submitter.submitMonitorValue(this.m_monitorName, rr, "MEM", null);
            } else {
                try {
                    Field f = this.getClass().getDeclaredField(metricName.replace(MEM_, "m_mem_"));
                    Double val = (Double)f.get(this);
                    this.m_submitter.submitMonitorValue(this.m_monitorName, val.doubleValue(), "MEM", null);
                }
                catch (Throwable f) {}
            }
        } else if (metricName.startsWith(PCPU)) {
            if (metricName.equals(PCPU)) {
                for (int i = 0; i < m_pcpu.size(); ++i) {
                    Double v = m_pcpu.get(i);
                    this.m_submitter.submitMonitorValue(this.m_monitorName, v.doubleValue(), "CPU" + i, null);
                }
            } else if (metricName.equals(PCPU_15M)) {
                this.m_submitter.submitMonitorValue(this.m_monitorName, m_avg15min, "CPU", null);
            } else if (metricName.equals(PCPU_1M)) {
                this.m_submitter.submitMonitorValue(this.m_monitorName, m_avg1min, "CPU", null);
            } else if (metricName.equals(PCPU_5M)) {
                this.m_submitter.submitMonitorValue(this.m_monitorName, m_avg5min, "CPU", null);
            } else if (metricName.equals(PCPU_TOTAL)) {
                this.m_submitter.submitMonitorValue(this.m_monitorName, m_PTotal, "CPU", null);
            }
        } else if (metricName.startsWith(COSMEM_)) {
            if (metricName.equals(COSMEM_FREE)) {
                this.m_submitter.submitMonitorValue(this.m_monitorName, m_cosmem_free, "COSMEM", null);
            } else if (metricName.equals(COSMEM_SWFREE)) {
                this.m_submitter.submitMonitorValue(this.m_monitorName, m_cosmem_swfree, "COSMEM", null);
            } else if (metricName.equals(COSMEM_SWREAD)) {
                this.m_submitter.submitMonitorValue(this.m_monitorName, m_cosmem_swread, "COSMEM", null);
            } else if (metricName.equals(COSMEM_SWTOTAL)) {
                this.m_submitter.submitMonitorValue(this.m_monitorName, m_cosmem_swtotal, "COSMEM", null);
            } else if (metricName.equals(COSMEM_SWWRITE)) {
                this.m_submitter.submitMonitorValue(this.m_monitorName, m_cosmem_swwrite, "COSMEM", null);
            }
        } else if (metricName.startsWith(CCPU_)) {
            if (metricName.equals(CCPU_IDLE)) {
                this.m_submitter.submitMonitorValue(this.m_monitorName, m_ccpu_idle, "CCPU", null);
            } else if (metricName.equals(CCPU_IOWAIT)) {
                this.m_submitter.submitMonitorValue(this.m_monitorName, m_ccpu_iowait, "CCPU", null);
            } else if (metricName.equals(CCPU_SWITCH)) {
                this.m_submitter.submitMonitorValue(this.m_monitorName, m_ccpu_switch, "CCPU", null);
            } else if (metricName.equals(CCPU_SYS)) {
                this.m_submitter.submitMonitorValue(this.m_monitorName, m_ccpu_sys, "CCPU", null);
            } else if (metricName.equals(CCPU_USR)) {
                this.m_submitter.submitMonitorValue(this.m_monitorName, m_ccpu_usr, "CCPU", null);
            }
        } else {
            HashMap<String, HashMap> instances = null;
            if (metricName.startsWith(GCPU_)) {
                instances = m_gcpu;
            } else if (metricName.startsWith(GMEM_)) {
                instances = m_gmem;
            } else if (metricName.startsWith(NET_)) {
                instances = m_net;
            } else if (metricName.startsWith(PDISK_)) {
                instances = m_disk;
            } else if (metricName.startsWith(VCPU_)) {
                instances = m_vcpu;
            }
            if (instances != null) {
                for (String objName : instances.keySet()) {
                    HashMap values = instances.get(objName);
                    String[] arr = metricName.split("\\s+");
                    try {
                        double value = this.calculateLine(values, arr);
                        this.m_submitter.submitMonitorValue(this.m_monitorName, value, objName, null);
                    }
                    catch (Throwable throwable) {}
                }
            } else {
                this.m_submitter.submitMonitorValue(this.m_monitorName, -1.0, null, null);
                this.m_msgSubmitter.sendMessage(null, "ESXTOP", "VMWARE", this.m_monitorName, "Unsupported metric name: \"" + metricName + "\".", "warning", null);
            }
        }
    }

    public double getGlobalValue(String metricName) {
        double res = -1.0;
        if (metricName.startsWith(MEM_)) {
            try {
                Field f = this.getClass().getDeclaredField(metricName.replace(MEM_, "m_mem_"));
                Double val = (Double)f.get(this);
                res = val;
            }
            catch (Throwable f) {}
        } else if (metricName.startsWith(PCPU)) {
            if (metricName.equals(PCPU)) {
                for (int i = 0; i < m_pcpu.size(); ++i) {
                    Double v = m_pcpu.get(i);
                    res = v;
                }
            } else if (metricName.equals(PCPU_15M)) {
                res = m_avg15min;
            } else if (metricName.equals(PCPU_1M)) {
                res = m_avg1min;
            } else if (metricName.equals(PCPU_5M)) {
                res = m_avg5min;
            } else if (metricName.equals(PCPU_TOTAL)) {
                res = m_PTotal;
            } else if (metricName.equals(PCPU_NUM)) {
                res = m_pcpu.size();
            }
        } else if (metricName.startsWith(COSMEM_)) {
            if (metricName.equals(COSMEM_FREE)) {
                res = m_cosmem_free;
            } else if (metricName.equals(COSMEM_SWFREE)) {
                res = m_cosmem_swfree;
            } else if (metricName.equals(COSMEM_SWREAD)) {
                res = m_cosmem_swread;
            } else if (metricName.equals(COSMEM_SWTOTAL)) {
                res = m_cosmem_swtotal;
            } else if (metricName.equals(COSMEM_SWWRITE)) {
                res = m_cosmem_swwrite;
            }
        } else if (metricName.startsWith(CCPU_)) {
            if (metricName.equals(CCPU_IDLE)) {
                res = m_ccpu_idle;
            } else if (metricName.equals(CCPU_IOWAIT)) {
                res = m_ccpu_iowait;
            } else if (metricName.equals(CCPU_SWITCH)) {
                res = m_ccpu_switch;
            } else if (metricName.equals(CCPU_SYS)) {
                res = m_ccpu_sys;
            } else if (metricName.equals(CCPU_USR)) {
                res = m_ccpu_usr;
            }
        }
        return res;
    }

    public double calculateLine(HashMap values, String[] calcs) {
        double temp = 0.0;
        int operand = 0;
        for (int j = 0; j < calcs.length; ++j) {
            Double dd;
            String c = calcs[j];
            if (values.containsKey(c)) {
                dd = (Double)values.get(c);
                if (dd == null) continue;
                temp = this.oper(operand, temp, dd);
                continue;
            }
            if (m_mapDirect.containsKey(c)) {
                double dd2 = this.getGlobalValue(c);
                if (dd2 == -1.0) continue;
                temp = this.oper(operand, temp, dd2);
                continue;
            }
            if (m_digitsPattern.matcher(c).matches()) {
                try {
                    dd = Double.parseDouble(c.trim().replace(',', '.'));
                    temp = this.oper(operand, temp, dd);
                }
                catch (NumberFormatException dd3) {}
                continue;
            }
            if (m_operand.matcher(c).matches()) {
                String operandNew = c.trim();
                if (operandNew.equals("+")) {
                    operand = 0;
                    continue;
                }
                if (operandNew.equals("-")) {
                    operand = 1;
                    continue;
                }
                if (operandNew.equals("/")) {
                    operand = 2;
                    continue;
                }
                if (operandNew.equals("*")) {
                    operand = 3;
                    continue;
                }
                if (!operandNew.equals("\\")) continue;
                operand = 4;
                continue;
            }
            throw new SyntaxException("function has wrong syntax: ");
        }
        return temp;
    }

    public double oper(int operand, double d1, double d2) {
        double res = 0.0;
        switch (operand) {
            case 0: {
                res = d1 + d2;
                break;
            }
            case 1: {
                res = d1 - d2;
                break;
            }
            case 2: {
                if (d2 == 0.0) {
                    throw new SyntaxException("Division by 0.");
                }
                res = d1 / d2;
                break;
            }
            case 3: {
                res = d1 * d2;
                break;
            }
            case 4: {
                if (d1 == 0.0) {
                    throw new SyntaxException("Division by 0.");
                }
                res = d2 / d1;
                break;
            }
        }
        return res;
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public static void main(String[] args) {
        Esxtop et = new Esxtop();
        et.m_monitorName = "test";
        et.setMonitorSubmitter(new NullMonSubmitter());
        et.setMessageSubmitter(new NullMsgSubmitter());
        outputFile = new File("vmstat.tmp");
        Esxtop.parseEsxtop(et, true);
        et.submitValue("MEM_KERNELSTATE");
        et.submitValue(MEM_FREE);
        et.submitValue(NET_UP);
        et.submitValue("GCPU_USED / PCPU_NUM");
    }

    static {
        m_digitsPattern = Pattern.compile("\\s*[-]*\\d+.*");
        m_operand = Pattern.compile("\\s*[\\*+-/]+\\s*");
        m_mapDirect = new HashMap();
        m_mapReverse = new HashMap();
        S_PCPUL = "Physical Cpu Load";
        S_PCPU = "Physical Cpu";
        P_PCPUL_1M = "Physical Cpu Load\\Cpu Load (1 Minute Avg)";
        P_PCPUL_15M = "Physical Cpu Load\\Cpu Load (15 Minute Avg)";
        P_PCPUL_5M = "Physical Cpu Load\\Cpu Load (5 Minute Avg)";
        P_PCPU_TOTAL = "Physical Cpu(_Total)\\% Processor Time";
        P_PCPU_PRE = "Physical Cpu(";
        P_PCPU_SUF = ")\\% Processor Time";
        PCPU = "PCPU";
        PCPU_NUM = "PCPU_NUM";
        PCPU_1M = "PCPU_1M";
        PCPU_5M = "PCPU_5M";
        PCPU_15M = "PCPU_15M";
        PCPU_TOTAL = "PCPU_TOTAL";
        m_numcpu = 0;
        m_avg1min = 0.0;
        m_avg5min = 0.0;
        m_avg15min = 0.0;
        m_PTotal = 0.0;
        m_pcpu = new ArrayList<Double>();
        m_mapDirect.put(PCPU_NUM, PCPU_NUM);
        S_COSMEM = "Console Memory";
        P_COSMEM_FREE = "Free MBytes";
        P_COSMEM_SWFREE = "Swap Free MBytes";
        P_COSMEM_SWREAD = "Swap MBytes Read/sec";
        P_COSMEM_SWWRITE = "Swap MBytes Write/sec";
        P_COSMEM_SWTOTAL = "Swap Total MBytes";
        COSMEM_ = "COSMEM_";
        COSMEM_FREE = "COSMEM_FREE";
        COSMEM_SWFREE = "COSMEM_SWFREE";
        COSMEM_SWREAD = "COSMEM_SWREAD";
        COSMEM_SWWRITE = "COSMEM_SWWRITE";
        COSMEM_SWTOTAL = "COSMEM_SWTOTAL";
        m_cosmem_free = 0.0;
        m_cosmem_swfree = 0.0;
        m_cosmem_swread = 0.0;
        m_cosmem_swwrite = 0.0;
        m_cosmem_swtotal = 0.0;
        m_mapDirect.put(COSMEM_FREE, P_COSMEM_FREE);
        m_mapDirect.put(COSMEM_SWFREE, P_COSMEM_SWFREE);
        m_mapDirect.put(COSMEM_SWREAD, P_COSMEM_SWREAD);
        m_mapDirect.put(COSMEM_SWWRITE, P_COSMEM_SWWRITE);
        m_mapDirect.put(COSMEM_SWTOTAL, P_COSMEM_SWTOTAL);
        m_mapReverse.put(P_COSMEM_FREE, COSMEM_FREE);
        m_mapReverse.put(P_COSMEM_SWFREE, COSMEM_SWFREE);
        m_mapReverse.put(P_COSMEM_SWREAD, COSMEM_SWREAD);
        m_mapReverse.put(P_COSMEM_SWWRITE, COSMEM_SWWRITE);
        m_mapReverse.put(P_COSMEM_SWTOTAL, COSMEM_SWTOTAL);
        S_CCPU = "Console Physical Cpu";
        P_CCPU_IOWAIT = "% I/O Wait Time";
        P_CCPU_IDLE = "% Idle Time";
        P_CCPU_SYS = "% System Time";
        P_CCPU_USR = "% User Time";
        P_CCPU_SWITCH = "Context Switches/sec";
        CCPU_ = "CCPU_";
        CCPU_IOWAIT = "CCPU_IOWAIT";
        CCPU_IDLE = "CCPU_IDLE";
        CCPU_SYS = "CCPU_SYS";
        CCPU_USR = "CCPU_USR";
        CCPU_SWITCH = "CCPU_SWITCH";
        m_ccpu_iowait = 0.0;
        m_ccpu_idle = 0.0;
        m_ccpu_sys = 0.0;
        m_ccpu_usr = 0.0;
        m_ccpu_switch = 0.0;
        m_mapDirect.put(CCPU_IOWAIT, P_CCPU_IOWAIT);
        m_mapDirect.put(CCPU_IDLE, P_CCPU_IDLE);
        m_mapDirect.put(CCPU_SYS, P_CCPU_SYS);
        m_mapDirect.put(CCPU_USR, P_CCPU_USR);
        m_mapDirect.put(CCPU_SWITCH, P_CCPU_SWITCH);
        m_mapReverse.put(P_CCPU_IOWAIT, CCPU_IOWAIT);
        m_mapReverse.put(P_CCPU_IDLE, CCPU_IDLE);
        m_mapReverse.put(P_CCPU_SYS, CCPU_SYS);
        m_mapReverse.put(P_CCPU_USR, CCPU_USR);
        m_mapReverse.put(P_CCPU_SWITCH, CCPU_SWITCH);
        S_GCPU = "Group Cpu";
        P_GCPU = Pattern.compile(S_GCPU + "\\(\\d+:(\\S+)\\)\\\\(.*)");
        P_GCPU_NAME = "NAME";
        P_GCPU_BUSYWAIT = "% Busy Wait";
        P_GCPU_CORUN = "% CoRun";
        P_GCPU_COSTOP = "% CoStop";
        P_GCPU_EXTRA = "% Extra";
        P_GCPU_IDLE = "% Idle";
        P_GCPU_MAXLIM = "% Max Limited";
        P_GCPU_OVERLAP = "% Overlap";
        P_GCPU_READY = "% Ready";
        P_GCPU_RUN = "% Run";
        P_GCPU_SYS = "% System";
        P_GCPU_TOTALWAIT = "% Total Wait";
        P_GCPU_USED = "% Used";
        P_GCPU_WAIT = "% Wait";
        P_GCPU_ALLOCMAX = "Alloc Max";
        P_GCPU_ALLOCMINLIM = "Alloc Min Limited";
        P_GCPU_ALLOCMIN = "Alloc Min";
        P_GCPU_ALLOCSHARES = "Alloc Shares";
        P_GCPU_CELLMIG = "Cell Migrations/sec";
        P_GCPU_MIG = "Migrates/sec";
        P_GCPU_CPUMIG = "Processor Migrations/sec";
        P_GCPU_QEXP = "Quantum Expires/sec";
        P_GCPU_SWITCH = "Switches/sec";
        P_GCPU_WAKEUPMI = "Wakeup Migrate Idle/sec";
        P_GCPU_WAKEUPS = "Wakeups/sec";
        GCPU_ = "GCPU_";
        GCPU_NAME = "NAME";
        GCPU_BUSYWAIT = "GCPU_BUSYWAIT";
        GCPU_CORUN = "GCPU_CORUN";
        GCPU_COSTOP = "GCPU_COSTOP";
        GCPU_EXTRA = "GCPU_EXTRA";
        GCPU_IDLE = "GCPU_IDLE";
        GCPU_MAXLIM = "GCPU_MAXLIM";
        GCPU_OVERLAP = "GCPU_OVERLAP";
        GCPU_READY = "GCPU_READY";
        GCPU_RUN = "GCPU_RUN";
        GCPU_SYS = "GCPU_SYS";
        GCPU_TOTALWAIT = "GCPU_TOTALWAIT";
        GCPU_USED = "GCPU_USED";
        GCPU_WAIT = "GCPU_WAIT";
        GCPU_ALLOCMAX = "GCPU_ALLOCMAX";
        GCPU_ALLOCMINLIM = "GCPU_ALLOCMINLIM";
        GCPU_ALLOCMIN = "GCPU_ALLOCMIN";
        GCPU_ALLOCSHARES = "GCPU_ALLOCSHARES";
        GCPU_CELLMIG = "GCPU_CELLMIG";
        GCPU_MIG = "GCPU_MIG";
        GCPU_CPUMIG = "GCPU_CPUMIG";
        GCPU_QEXP = "GCPU_QEXP";
        GCPU_SWITCH = "GCPU_SWITCH";
        GCPU_WAKEUPMI = "GCPU_WAKEUPMI";
        GCPU_WAKEUPS = "GCPU_WAKEUPS";
        m_gcpu = new HashMap();
        m_mapDirectGCPU = new HashMap();
        m_mapReverseGCPU = new HashMap();
        m_mapDirectGCPU.put(GCPU_BUSYWAIT, P_GCPU_BUSYWAIT);
        m_mapDirectGCPU.put(GCPU_CORUN, P_GCPU_CORUN);
        m_mapDirectGCPU.put(GCPU_COSTOP, P_GCPU_COSTOP);
        m_mapDirectGCPU.put(GCPU_EXTRA, P_GCPU_EXTRA);
        m_mapDirectGCPU.put(GCPU_IDLE, P_GCPU_IDLE);
        m_mapDirectGCPU.put(GCPU_MAXLIM, P_GCPU_MAXLIM);
        m_mapDirectGCPU.put(GCPU_OVERLAP, P_GCPU_OVERLAP);
        m_mapDirectGCPU.put(GCPU_READY, P_GCPU_READY);
        m_mapDirectGCPU.put(GCPU_RUN, P_GCPU_RUN);
        m_mapDirectGCPU.put(GCPU_SYS, P_GCPU_SYS);
        m_mapDirectGCPU.put(GCPU_TOTALWAIT, P_GCPU_TOTALWAIT);
        m_mapDirectGCPU.put(GCPU_USED, P_GCPU_USED);
        m_mapDirectGCPU.put(GCPU_WAIT, P_GCPU_WAIT);
        m_mapDirectGCPU.put(GCPU_ALLOCMAX, P_GCPU_ALLOCMAX);
        m_mapDirectGCPU.put(GCPU_ALLOCMINLIM, P_GCPU_ALLOCMINLIM);
        m_mapDirectGCPU.put(GCPU_ALLOCMIN, P_GCPU_ALLOCMIN);
        m_mapDirectGCPU.put(GCPU_ALLOCSHARES, P_GCPU_ALLOCSHARES);
        m_mapDirectGCPU.put(GCPU_CELLMIG, P_GCPU_CELLMIG);
        m_mapDirectGCPU.put(GCPU_MIG, P_GCPU_MIG);
        m_mapDirectGCPU.put(GCPU_CPUMIG, P_GCPU_CPUMIG);
        m_mapDirectGCPU.put(GCPU_QEXP, P_GCPU_QEXP);
        m_mapDirectGCPU.put(GCPU_SWITCH, P_GCPU_SWITCH);
        m_mapDirectGCPU.put(GCPU_WAKEUPMI, P_GCPU_WAKEUPMI);
        m_mapDirectGCPU.put(GCPU_WAKEUPS, P_GCPU_WAKEUPS);
        m_mapReverseGCPU.put(P_GCPU_BUSYWAIT, GCPU_BUSYWAIT);
        m_mapReverseGCPU.put(P_GCPU_CORUN, GCPU_CORUN);
        m_mapReverseGCPU.put(P_GCPU_COSTOP, GCPU_COSTOP);
        m_mapReverseGCPU.put(P_GCPU_EXTRA, GCPU_EXTRA);
        m_mapReverseGCPU.put(P_GCPU_IDLE, GCPU_IDLE);
        m_mapReverseGCPU.put(P_GCPU_MAXLIM, GCPU_MAXLIM);
        m_mapReverseGCPU.put(P_GCPU_OVERLAP, GCPU_OVERLAP);
        m_mapReverseGCPU.put(P_GCPU_READY, GCPU_READY);
        m_mapReverseGCPU.put(P_GCPU_RUN, GCPU_RUN);
        m_mapReverseGCPU.put(P_GCPU_SYS, GCPU_SYS);
        m_mapReverseGCPU.put(P_GCPU_TOTALWAIT, GCPU_TOTALWAIT);
        m_mapReverseGCPU.put(P_GCPU_USED, GCPU_USED);
        m_mapReverseGCPU.put(P_GCPU_WAIT, GCPU_WAIT);
        m_mapReverseGCPU.put(P_GCPU_ALLOCMAX, GCPU_ALLOCMAX);
        m_mapReverseGCPU.put(P_GCPU_ALLOCMINLIM, GCPU_ALLOCMINLIM);
        m_mapReverseGCPU.put(P_GCPU_ALLOCMIN, GCPU_ALLOCMIN);
        m_mapReverseGCPU.put(P_GCPU_ALLOCSHARES, GCPU_ALLOCSHARES);
        m_mapReverseGCPU.put(P_GCPU_CELLMIG, GCPU_CELLMIG);
        m_mapReverseGCPU.put(P_GCPU_MIG, GCPU_MIG);
        m_mapReverseGCPU.put(P_GCPU_CPUMIG, GCPU_CPUMIG);
        m_mapReverseGCPU.put(P_GCPU_QEXP, GCPU_QEXP);
        m_mapReverseGCPU.put(P_GCPU_SWITCH, GCPU_SWITCH);
        m_mapReverseGCPU.put(P_GCPU_WAKEUPMI, GCPU_WAKEUPMI);
        m_mapReverseGCPU.put(P_GCPU_WAKEUPS, GCPU_WAKEUPS);
        S_GMEM = "Group Memory";
        P_GMEM = Pattern.compile(S_GMEM + "\\(\\d+:(\\S+)\\)\\\\(.*)");
        P_GMEM_NAME = "NAME";
        P_GMEM_ACTEST = "% Active Estimate";
        P_GMEM_ACTFEST = "% Active Fast Estimate";
        P_GMEM_ACTNEST = "% Active Next Estimate";
        P_GMEM_ACTSEST = "% Active Slow Estimate";
        P_GMEM_ALLOCMAX = "Alloc Max";
        P_GMEM_ALLOCMINLIM = "Alloc Min Limited";
        P_GMEM_ALLOCMIN = "Alloc Min";
        P_GMEM_ALLOCSHARES = "Alloc Shares";
        P_GMEM_CPREAD = "Checkpoint Read MBytes";
        P_GMEM_CPTARGET = "Checkpoint Target MBytes";
        P_GMEM_CLR = "Client Responsive?";
        P_GMEM_COMMCHARGED = "Commit Charged MBytes";
        P_GMEM_COMMPPS = "Commit Pages Per Share";
        P_GMEM_COMMTARGET = "Commit Target MBytes";
        P_GMEM_COWH = "Copy On Write Hint MBytes";
        P_GMEM_MEMBERS = "Members";
        P_GMEM_MEMCTLMAX = "Memctl Max MBytes";
        P_GMEM_MEMCTL = "Memctl MBytes";
        P_GMEM_MEMCTLTARGET = "Memctl Target MBytes";
        P_GMEM_MEMCTLB = "Memctl?";
        P_GMEM_MEMSIZE = "Memory Size MBytes";
        P_GMEM_MINCOMMTARGET = "Min Commit Target MBytes";
        P_GMEM_NUMAP = "Numa % Local";
        P_GMEM_NUMAHOME = "Numa Home Node";
        P_GMEM_NUMAMEM = "Numa Local Memory MBytes";
        P_GMEM_NUMAREBALANCE = "Numa Rebalance Count Delta";
        P_GMEM_NUMAREMOTEMEM = "Numa Remote Memory MBytes";
        P_GMEM_OVERHEADMAX = "Overhead Max MBytes";
        P_GMEM_OVERHEAD = "Overhead MBytes";
        P_GMEM_OVERHEADUW = "Overhead UW MBytes";
        P_GMEM_SHARED = "Shared MBytes";
        P_GMEM_SHAREDSAVED = "Shared Saved MBytes";
        P_GMEM_SWREAD = "Swap Read MBytes/sec";
        P_GMEM_SWTARGET = "Swap Target MBytes";
        P_GMEM_SWWRITE = "Swap Written MBytes/sec";
        P_GMEM_SWAPPED = "Swapped MBytes";
        P_GMEM_TARGETSIZE = "Target Size MBytes";
        P_GMEM_TOUCHED = "Touched MBytes";
        P_GMEM_ZERO = "Zero MBytes";
        GMEM_ = "GMEM_";
        GMEM_NAME = "NAME";
        GMEM_ACTEST = "GMEM_ACTEST";
        GMEM_ACTFEST = "GMEM_ACTFEST";
        GMEM_ACTNEST = "GMEM_ACTNEST";
        GMEM_ACTSEST = "GMEM_ACTSEST";
        GMEM_ALLOCMAX = "GMEM_ALLOCMAX";
        GMEM_ALLOCMINLIM = "GMEM_ALLOCMINLIM";
        GMEM_ALLOCMIN = "GMEM_ALLOCMIN";
        GMEM_ALLOCSHARES = "GMEM_ALLOCSHARES";
        GMEM_CPREAD = "GMEM_CPREAD";
        GMEM_CPTARGET = "GMEM_CPTARGET";
        GMEM_CLR = "GMEM_CLR";
        GMEM_COMMCHARGED = "GMEM_COMMCHARGED";
        GMEM_COMMPPS = "GMEM_COMMPPS";
        GMEM_COMMTARGET = "GMEM_COMMTARGET";
        GMEM_COWH = "GMEM_COWH";
        GMEM_MEMBERS = "GMEM_MEMBERS";
        GMEM_MEMCTLMAX = "GMEM_MEMCTLMAX";
        GMEM_MEMCTL = "GMEM_MEMCTL";
        GMEM_MEMCTLTARGET = "GMEM_MEMCTLTARGET";
        GMEM_MEMCTLB = "GMEM_MEMCTLB";
        GMEM_MEMSIZE = "GMEM_MEMSIZE";
        GMEM_MINCOMMTARGET = "GMEM_MINCOMMTARGET";
        GMEM_NUMAP = "GMEM_NUMAP";
        GMEM_NUMAHOME = "GMEM_NUMAHOME";
        GMEM_NUMAMEM = "GMEM_NUMAMEM";
        GMEM_NUMAREBALANCE = "GMEM_NUMAREBALANCE";
        GMEM_NUMAREMOTEMEM = "GMEM_NUMAREMOTEMEM";
        GMEM_OVERHEADMAX = "GMEM_OVERHEADMAX";
        GMEM_OVERHEAD = "GMEM_OVERHEAD";
        GMEM_OVERHEADUW = "GMEM_OVERHEADUW";
        GMEM_SHARED = "GMEM_SHARED";
        GMEM_SHAREDSAVED = "GMEM_SHAREDSAVED";
        GMEM_SWREAD = "GMEM_SWREAD";
        GMEM_SWTARGET = "GMEM_SWTARGET";
        GMEM_SWWRITE = "GMEM_SWWRITE";
        GMEM_SWAPPED = "GMEM_SWAPPED";
        GMEM_TARGETSIZE = "GMEM_TARGETSIZE";
        GMEM_TOUCHED = "GMEM_TOUCHED";
        GMEM_ZERO = "GMEM_ZERO";
        m_gmem = new HashMap();
        m_mapDirectGMEM = new HashMap();
        m_mapReverseGMEM = new HashMap();
        m_mapDirectGMEM.put(GMEM_ACTEST, P_GMEM_ACTEST);
        m_mapDirectGMEM.put(GMEM_ACTFEST, P_GMEM_ACTFEST);
        m_mapDirectGMEM.put(GMEM_ACTNEST, P_GMEM_ACTNEST);
        m_mapDirectGMEM.put(GMEM_ACTSEST, P_GMEM_ACTSEST);
        m_mapDirectGMEM.put(GMEM_ALLOCMAX, P_GMEM_ALLOCMAX);
        m_mapDirectGMEM.put(GMEM_ALLOCMINLIM, P_GMEM_ALLOCMINLIM);
        m_mapDirectGMEM.put(GMEM_ALLOCMIN, P_GMEM_ALLOCMIN);
        m_mapDirectGMEM.put(GMEM_ALLOCSHARES, P_GMEM_ALLOCSHARES);
        m_mapDirectGMEM.put(GMEM_CPREAD, P_GMEM_CPREAD);
        m_mapDirectGMEM.put(GMEM_CPTARGET, P_GMEM_CPTARGET);
        m_mapDirectGMEM.put(GMEM_CLR, P_GMEM_CLR);
        m_mapDirectGMEM.put(GMEM_COMMCHARGED, P_GMEM_COMMCHARGED);
        m_mapDirectGMEM.put(GMEM_COMMPPS, P_GMEM_COMMPPS);
        m_mapDirectGMEM.put(GMEM_COMMTARGET, P_GMEM_COMMTARGET);
        m_mapDirectGMEM.put(GMEM_COWH, P_GMEM_COWH);
        m_mapDirectGMEM.put(GMEM_MEMBERS, P_GMEM_MEMBERS);
        m_mapDirectGMEM.put(GMEM_MEMCTLMAX, P_GMEM_MEMCTLMAX);
        m_mapDirectGMEM.put(GMEM_MEMCTL, P_GMEM_MEMCTL);
        m_mapDirectGMEM.put(GMEM_MEMCTLTARGET, P_GMEM_MEMCTLTARGET);
        m_mapDirectGMEM.put(GMEM_MEMCTLB, P_GMEM_MEMCTLB);
        m_mapDirectGMEM.put(GMEM_MEMSIZE, P_GMEM_MEMSIZE);
        m_mapDirectGMEM.put(GMEM_MINCOMMTARGET, P_GMEM_MINCOMMTARGET);
        m_mapDirectGMEM.put(GMEM_NUMAP, P_GMEM_NUMAP);
        m_mapDirectGMEM.put(GMEM_NUMAHOME, P_GMEM_NUMAHOME);
        m_mapDirectGMEM.put(GMEM_NUMAMEM, P_GMEM_NUMAMEM);
        m_mapDirectGMEM.put(GMEM_NUMAREBALANCE, P_GMEM_NUMAREBALANCE);
        m_mapDirectGMEM.put(GMEM_NUMAREMOTEMEM, P_GMEM_NUMAREMOTEMEM);
        m_mapDirectGMEM.put(GMEM_OVERHEADMAX, P_GMEM_OVERHEADMAX);
        m_mapDirectGMEM.put(GMEM_OVERHEAD, P_GMEM_OVERHEAD);
        m_mapDirectGMEM.put(GMEM_OVERHEADUW, P_GMEM_OVERHEADUW);
        m_mapDirectGMEM.put(GMEM_SHARED, P_GMEM_SHARED);
        m_mapDirectGMEM.put(GMEM_SHAREDSAVED, P_GMEM_SHAREDSAVED);
        m_mapDirectGMEM.put(GMEM_SWREAD, P_GMEM_SWREAD);
        m_mapDirectGMEM.put(GMEM_SWTARGET, P_GMEM_SWTARGET);
        m_mapDirectGMEM.put(GMEM_SWWRITE, P_GMEM_SWWRITE);
        m_mapDirectGMEM.put(GMEM_SWAPPED, P_GMEM_SWAPPED);
        m_mapDirectGMEM.put(GMEM_TARGETSIZE, P_GMEM_TARGETSIZE);
        m_mapDirectGMEM.put(GMEM_TOUCHED, P_GMEM_TOUCHED);
        m_mapDirectGMEM.put(GMEM_ZERO, P_GMEM_ZERO);
        m_mapReverseGMEM.put(P_GMEM_ACTEST, GMEM_ACTEST);
        m_mapReverseGMEM.put(P_GMEM_ACTFEST, GMEM_ACTFEST);
        m_mapReverseGMEM.put(P_GMEM_ACTNEST, GMEM_ACTNEST);
        m_mapReverseGMEM.put(P_GMEM_ACTSEST, GMEM_ACTSEST);
        m_mapReverseGMEM.put(P_GMEM_ALLOCMAX, GMEM_ALLOCMAX);
        m_mapReverseGMEM.put(P_GMEM_ALLOCMINLIM, GMEM_ALLOCMINLIM);
        m_mapReverseGMEM.put(P_GMEM_ALLOCMIN, GMEM_ALLOCMIN);
        m_mapReverseGMEM.put(P_GMEM_ALLOCSHARES, GMEM_ALLOCSHARES);
        m_mapReverseGMEM.put(P_GMEM_CPREAD, GMEM_CPREAD);
        m_mapReverseGMEM.put(P_GMEM_CPTARGET, GMEM_CPTARGET);
        m_mapReverseGMEM.put(P_GMEM_CLR, GMEM_CLR);
        m_mapReverseGMEM.put(P_GMEM_COMMCHARGED, GMEM_COMMCHARGED);
        m_mapReverseGMEM.put(P_GMEM_COMMPPS, GMEM_COMMPPS);
        m_mapReverseGMEM.put(P_GMEM_COMMTARGET, GMEM_COMMTARGET);
        m_mapReverseGMEM.put(P_GMEM_COWH, GMEM_COWH);
        m_mapReverseGMEM.put(P_GMEM_MEMBERS, GMEM_MEMBERS);
        m_mapReverseGMEM.put(P_GMEM_MEMCTLMAX, GMEM_MEMCTLMAX);
        m_mapReverseGMEM.put(P_GMEM_MEMCTL, GMEM_MEMCTL);
        m_mapReverseGMEM.put(P_GMEM_MEMCTLTARGET, GMEM_MEMCTLTARGET);
        m_mapReverseGMEM.put(P_GMEM_MEMCTLB, GMEM_MEMCTLB);
        m_mapReverseGMEM.put(P_GMEM_MEMSIZE, GMEM_MEMSIZE);
        m_mapReverseGMEM.put(P_GMEM_MINCOMMTARGET, GMEM_MINCOMMTARGET);
        m_mapReverseGMEM.put(P_GMEM_NUMAP, GMEM_NUMAP);
        m_mapReverseGMEM.put(P_GMEM_NUMAHOME, GMEM_NUMAHOME);
        m_mapReverseGMEM.put(P_GMEM_NUMAMEM, GMEM_NUMAMEM);
        m_mapReverseGMEM.put(P_GMEM_NUMAREBALANCE, GMEM_NUMAREBALANCE);
        m_mapReverseGMEM.put(P_GMEM_NUMAREMOTEMEM, GMEM_NUMAREMOTEMEM);
        m_mapReverseGMEM.put(P_GMEM_OVERHEADMAX, GMEM_OVERHEADMAX);
        m_mapReverseGMEM.put(P_GMEM_OVERHEAD, GMEM_OVERHEAD);
        m_mapReverseGMEM.put(P_GMEM_OVERHEADUW, GMEM_OVERHEADUW);
        m_mapReverseGMEM.put(P_GMEM_SHARED, GMEM_SHARED);
        m_mapReverseGMEM.put(P_GMEM_SHAREDSAVED, GMEM_SHAREDSAVED);
        m_mapReverseGMEM.put(P_GMEM_SWREAD, GMEM_SWREAD);
        m_mapReverseGMEM.put(P_GMEM_SWTARGET, GMEM_SWTARGET);
        m_mapReverseGMEM.put(P_GMEM_SWWRITE, GMEM_SWWRITE);
        m_mapReverseGMEM.put(P_GMEM_SWAPPED, GMEM_SWAPPED);
        m_mapReverseGMEM.put(P_GMEM_TARGETSIZE, GMEM_TARGETSIZE);
        m_mapReverseGMEM.put(P_GMEM_TOUCHED, GMEM_TOUCHED);
        m_mapReverseGMEM.put(P_GMEM_ZERO, GMEM_ZERO);
        S_MEM = "Memory";
        P_MEM_COS = "Console MBytes";
        P_MEM_FREE = "Free MBytes";
        P_MEM_KERNELMANAGED = "Kernel Managed MBytes";
        P_MEM_KERNEL = "Kernel MBytes";
        P_MEM_KERNELMINFREE = "Kernel MinFree MBytes";
        P_MEM_KERNELRESERVED = "Kernel Reserved MBytes";
        P_MEM_KERNELSTATE = "Kernel State";
        P_MEM_KERNELUNRESERVED = "Kernel Unreserved MBytes";
        P_MEM_MACHINE = "Machine MBytes";
        P_MEM_CTLCURR = "Memctl Current MBytes";
        P_MEM_CTLMAX = "Memctl Max MBytes";
        P_MEM_CTLTARGET = "Memctl Target MBytes";
        P_MEM_OVERCOMM1M = "Memory Overcommit (1 Minute Avg)";
        P_MEM_OVERCOMM15M = "Memory Overcommit (15 Minute Avg)";
        P_MEM_OVERCOMM5M = "Memory Overcommit (5 Minute Avg)";
        P_MEM_NONKERNEL = "NonKernel MBytes";
        P_MEM_PSHARECOMMON = "PShare Common MBytes";
        P_MEM_PSHARESAVINGS = "PShare Savings MBytes";
        P_MEM_PSHARESHARED = "PShare Shared MBytes";
        P_MEM_SWREAD = "Swap MBytes Read/sec";
        P_MEM_SWWRITE = "Swap MBytes Write/sec";
        P_MEM_SWTARGET = "Swap Target MBytes";
        P_MEM_SWUSED = "Swap Used MBytes";
        MEM_ = "MEM_";
        MEM_COS = "MEM_COS";
        MEM_FREE = "MEM_FREE";
        MEM_KERNELMANAGED = "MEM_KERNELMANAGED";
        MEM_KERNEL = "MEM_KERNEL";
        MEM_KERNELMINFREE = "MEM_KERNELMINFREE";
        MEM_KERNELRESERVED = "MEM_KERNELRESERVED";
        MEM_KERNELSTATE = "MEM_KERNELSTATE";
        MEM_KERNELUNRESERVED = "MEM_KERNELUNRESERVED";
        MEM_MACHINE = "MEM_MACHINE";
        MEM_CTLCURR = "MEM_CTLCURR";
        MEM_CTLMAX = "MEM_CTLMAX";
        MEM_CTLTARGET = "MEM_CTLTARGET";
        MEM_OVERCOMM1M = "MEM_OVERCOMM1M";
        MEM_OVERCOMM15M = "MEM_OVERCOMM15M";
        MEM_OVERCOMM5M = "MEM_OVERCOMM5M";
        MEM_NONKERNEL = "MEM_NONKERNEL";
        MEM_PSHARECOMMON = "MEM_PSHARECOMMON";
        MEM_PSHARESAVINGS = "MEM_PSHARESAVINGS";
        MEM_PSHARESHARED = "MEM_PSHARESHARED";
        MEM_SWREAD = "MEM_SWREAD";
        MEM_SWWRITE = "MEM_SWWRITE";
        MEM_SWTARGET = "MEM_SWTARGET";
        MEM_SWUSED = "MEM_SWUSED";
        m_mem_COS = 0.0;
        m_mem_FREE = 0.0;
        m_mem_KERNELMANAGED = 0.0;
        m_mem_KERNEL = 0.0;
        m_mem_KERNELMINFREE = 0.0;
        m_mem_KERNELRESERVED = 0.0;
        m_mem_KERNELSTATE = 0.0;
        m_mem_KERNELUNRESERVED = 0.0;
        m_mem_MACHINE = 0.0;
        m_mem_CTLCURR = 0.0;
        m_mem_CTLMAX = 0.0;
        m_mem_CTLTARGET = 0.0;
        m_mem_OVERCOMM1M = 0.0;
        m_mem_OVERCOMM15M = 0.0;
        m_mem_OVERCOMM5M = 0.0;
        m_mem_NONKERNEL = 0.0;
        m_mem_PSHARECOMMON = 0.0;
        m_mem_PSHARESAVINGS = 0.0;
        m_mem_PSHARESHARED = 0.0;
        m_mem_SWREAD = 0.0;
        m_mem_SWWRITE = 0.0;
        m_mem_SWTARGET = 0.0;
        m_mem_SWUSED = 0.0;
        m_mapDirect.put(MEM_COS, P_MEM_COS);
        m_mapDirect.put(MEM_FREE, P_MEM_FREE);
        m_mapDirect.put(MEM_KERNELMANAGED, P_MEM_KERNELMANAGED);
        m_mapDirect.put(MEM_KERNEL, P_MEM_KERNEL);
        m_mapDirect.put(MEM_KERNELMINFREE, P_MEM_KERNELMINFREE);
        m_mapDirect.put(MEM_KERNELRESERVED, P_MEM_KERNELRESERVED);
        m_mapDirect.put(MEM_KERNELSTATE, P_MEM_KERNELSTATE);
        m_mapDirect.put(MEM_KERNELUNRESERVED, P_MEM_KERNELUNRESERVED);
        m_mapDirect.put(MEM_MACHINE, P_MEM_MACHINE);
        m_mapDirect.put(MEM_CTLCURR, P_MEM_CTLCURR);
        m_mapDirect.put(MEM_CTLMAX, P_MEM_CTLMAX);
        m_mapDirect.put(MEM_CTLTARGET, P_MEM_CTLTARGET);
        m_mapDirect.put(MEM_OVERCOMM1M, P_MEM_OVERCOMM1M);
        m_mapDirect.put(MEM_OVERCOMM15M, P_MEM_OVERCOMM15M);
        m_mapDirect.put(MEM_OVERCOMM5M, P_MEM_OVERCOMM5M);
        m_mapDirect.put(MEM_NONKERNEL, P_MEM_NONKERNEL);
        m_mapDirect.put(MEM_PSHARECOMMON, P_MEM_PSHARECOMMON);
        m_mapDirect.put(MEM_PSHARESAVINGS, P_MEM_PSHARESAVINGS);
        m_mapDirect.put(MEM_PSHARESHARED, P_MEM_PSHARESHARED);
        m_mapDirect.put(MEM_SWREAD, P_MEM_SWREAD);
        m_mapDirect.put(MEM_SWWRITE, P_MEM_SWWRITE);
        m_mapDirect.put(MEM_SWTARGET, P_MEM_SWTARGET);
        m_mapDirect.put(MEM_SWUSED, P_MEM_SWUSED);
        m_mapReverse.put(P_MEM_COS, MEM_COS);
        m_mapReverse.put(P_MEM_FREE, MEM_FREE);
        m_mapReverse.put(P_MEM_KERNELMANAGED, MEM_KERNELMANAGED);
        m_mapReverse.put(P_MEM_KERNEL, MEM_KERNEL);
        m_mapReverse.put(P_MEM_KERNELMINFREE, MEM_KERNELMINFREE);
        m_mapReverse.put(P_MEM_KERNELRESERVED, MEM_KERNELRESERVED);
        m_mapReverse.put(P_MEM_KERNELSTATE, MEM_KERNELSTATE);
        m_mapReverse.put(P_MEM_KERNELUNRESERVED, MEM_KERNELUNRESERVED);
        m_mapReverse.put(P_MEM_MACHINE, MEM_MACHINE);
        m_mapReverse.put(P_MEM_CTLCURR, MEM_CTLCURR);
        m_mapReverse.put(P_MEM_CTLMAX, MEM_CTLMAX);
        m_mapReverse.put(P_MEM_CTLTARGET, MEM_CTLTARGET);
        m_mapReverse.put(P_MEM_OVERCOMM1M, MEM_OVERCOMM1M);
        m_mapReverse.put(P_MEM_OVERCOMM15M, MEM_OVERCOMM15M);
        m_mapReverse.put(P_MEM_OVERCOMM5M, MEM_OVERCOMM5M);
        m_mapReverse.put(P_MEM_NONKERNEL, MEM_NONKERNEL);
        m_mapReverse.put(P_MEM_PSHARECOMMON, MEM_PSHARECOMMON);
        m_mapReverse.put(P_MEM_PSHARESAVINGS, MEM_PSHARESAVINGS);
        m_mapReverse.put(P_MEM_PSHARESHARED, MEM_PSHARESHARED);
        m_mapReverse.put(P_MEM_SWREAD, MEM_SWREAD);
        m_mapReverse.put(P_MEM_SWWRITE, MEM_SWWRITE);
        m_mapReverse.put(P_MEM_SWTARGET, MEM_SWTARGET);
        m_mapReverse.put(P_MEM_SWUSED, MEM_SWUSED);
        S_NET = "Network Port";
        P_NET = Pattern.compile(S_NET + "\\((vSwitch\\d+):.*:(.*)\\)\\\\(.*)");
        P_NET_NAME = "NAME";
        P_NET_POUTDROP = "% Outbound Packets Dropped";
        P_NET_PINDROP = "% Received Packets Dropped";
        P_NET_ACTPOST = "Actions Posted/sec";
        P_NET_FULLDUPLEX = "Full Duplex?";
        P_NET_SPEED = "Link Speed (Mb/s)";
        P_NET_UP = "Link Up?";
        P_NET_RECV = "MBits Received/sec";
        P_NET_TRAN = "MBits Transmitted/sec";
        P_NET_PACKETRECV = "Packets Received/sec";
        P_NET_PACKETTRAN = "Packets Transmitted/sec";
        NET_ = "NET_";
        NET_NAME = "NAME";
        NET_POUTDROP = "NET_POUTDROP";
        NET_PINDROP = "NET_PINDROP";
        NET_ACTPOST = "NET_ACTPOST";
        NET_FULLDUPLEX = "NET_FULLDUPLEX";
        NET_SPEED = "NET_SPEED";
        NET_UP = "NET_UP";
        NET_RECV = "NET_RECV";
        NET_TRAN = "NET_TRAN";
        NET_PACKETRECV = "NET_PACKETRECV";
        NET_PACKETTRAN = "NET_PACKETTRAN";
        m_net = new HashMap();
        m_mapDirectNET = new HashMap();
        m_mapReverseNET = new HashMap();
        m_mapDirectNET.put(NET_POUTDROP, P_NET_POUTDROP);
        m_mapDirectNET.put(NET_PINDROP, P_NET_PINDROP);
        m_mapDirectNET.put(NET_ACTPOST, P_NET_ACTPOST);
        m_mapDirectNET.put(NET_FULLDUPLEX, P_NET_FULLDUPLEX);
        m_mapDirectNET.put(NET_SPEED, P_NET_SPEED);
        m_mapDirectNET.put(NET_UP, P_NET_UP);
        m_mapDirectNET.put(NET_RECV, P_NET_RECV);
        m_mapDirectNET.put(NET_TRAN, P_NET_TRAN);
        m_mapDirectNET.put(NET_PACKETRECV, P_NET_PACKETRECV);
        m_mapDirectNET.put(NET_PACKETTRAN, P_NET_PACKETTRAN);
        m_mapReverseNET.put(P_NET_POUTDROP, NET_POUTDROP);
        m_mapReverseNET.put(P_NET_PINDROP, NET_PINDROP);
        m_mapReverseNET.put(P_NET_ACTPOST, NET_ACTPOST);
        m_mapReverseNET.put(P_NET_FULLDUPLEX, NET_FULLDUPLEX);
        m_mapReverseNET.put(P_NET_SPEED, NET_SPEED);
        m_mapReverseNET.put(P_NET_UP, NET_UP);
        m_mapReverseNET.put(P_NET_RECV, NET_RECV);
        m_mapReverseNET.put(P_NET_TRAN, NET_TRAN);
        m_mapReverseNET.put(P_NET_PACKETRECV, NET_PACKETRECV);
        m_mapReverseNET.put(P_NET_PACKETTRAN, NET_PACKETTRAN);
        S_NUNO = "Numa Node";
        S_PDISK = "Physical Disk";
        P_DISK = Pattern.compile(S_PDISK + "\\((.+)\\)\\\\(.*)");
        P_PDISK_NAME = "NAME";
        P_PDISK_USED = "% Used";
        P_PDISK_ABORTS = "Aborts/sec";
        P_PDISK_ACTIVECMD = "Active Commands";
        P_PDISK_ADPTQDEPTH = "Adapter Q Depth";
        P_PDISK_AVGDRVMS = "Average Driver MilliSec/Command";
        P_PDISK_AVGGUESTMS = "Average Guest MilliSec/Command";
        P_PDISK_AVGKERNMS = "Average Kernel MilliSec/Command";
        P_PDISK_CHANNELS = "Channels";
        P_PDISK_CMDS = "Commands/sec";
        P_PDISK_LOAD = "Load";
        P_PDISK_LUNQDEPTH = "Lun Q Depth";
        P_PDISK_LUNS = "Luns";
        P_PDISK_MBREADS = "MBytes Read/sec";
        P_PDISK_MBWRITES = "MBytes Written/sec";
        P_PDISK_COMS = "PAE Commands/sec";
        P_PDISK_COPYS = "PAE Copies/sec";
        P_PDISK_QCMD = "Queued Commands";
        P_PDISK_READS = "Reads/sec";
        P_PDISK_RESETS = "Resets/sec";
        P_PDISK_SHARES = "Shares";
        P_PDISK_SPLITS = "Split Commands/sec";
        P_PDISK_SPLITCOPIES = "Split Copies/sec";
        P_PDISK_TARGETS = "Targets";
        P_PDISK_WORDQDEPTH = "World Q Depth";
        P_PDISK_WORDS = "Worlds";
        P_PDISK_WRITES = "Writes/sec";
        PDISK_ = "PDISK_";
        PDISK_NAME = "NAME";
        PDISK_USED = "PDISK_USED";
        PDISK_ABORTS = "PDISK_ABORTS";
        PDISK_ACTIVECMD = "PDISK_ACTIVECMD";
        PDISK_ADPTQDEPTH = "PDISK_ADPTQDEPTH";
        PDISK_AVGDRVMS = "PDISK_AVGDRVMS";
        PDISK_AVGGUESTMS = "PDISK_AVGGUESTMS";
        PDISK_AVGKERNMS = "PDISK_AVGKERNMS";
        PDISK_CHANNELS = "PDISK_CHANNELS";
        PDISK_CMDS = "PDISK_CMDS";
        PDISK_LOAD = "PDISK_LOAD";
        PDISK_LUNQDEPTH = "PDISK_LUNQDEPTH";
        PDISK_LUNS = "PDISK_LUNS";
        PDISK_MBREADS = "PDISK_MBREADS";
        PDISK_MBWRITES = "PDISK_MBWRITES";
        PDISK_COMS = "PDISK_COMS";
        PDISK_COPYS = "PDISK_COPYS";
        PDISK_QCMD = "PDISK_QCMD";
        PDISK_READS = "PDISK_READS";
        PDISK_RESETS = "PDISK_RESETS";
        PDISK_SHARES = "PDISK_SHARES";
        PDISK_SPLITS = "PDISK_SPLITS";
        PDISK_SPLITCOPIES = "PDISK_SPLITCOPIES";
        PDISK_TARGETS = "PDISK_TARGETS";
        PDISK_WORDQDEPTH = "PDISK_WORDQDEPTH";
        PDISK_WORDS = "PDISK_WORDS";
        PDISK_WRITES = "PDISK_WRITES";
        m_disk = new HashMap();
        m_mapDirectPDISK = new HashMap();
        m_mapReversePDISK = new HashMap();
        m_mapDirectPDISK.put(PDISK_USED, P_PDISK_USED);
        m_mapDirectPDISK.put(PDISK_ABORTS, P_PDISK_ABORTS);
        m_mapDirectPDISK.put(PDISK_ACTIVECMD, P_PDISK_ACTIVECMD);
        m_mapDirectPDISK.put(PDISK_ADPTQDEPTH, P_PDISK_ADPTQDEPTH);
        m_mapDirectPDISK.put(PDISK_AVGDRVMS, P_PDISK_AVGDRVMS);
        m_mapDirectPDISK.put(PDISK_AVGGUESTMS, P_PDISK_AVGGUESTMS);
        m_mapDirectPDISK.put(PDISK_AVGKERNMS, P_PDISK_AVGKERNMS);
        m_mapDirectPDISK.put(PDISK_CHANNELS, P_PDISK_CHANNELS);
        m_mapDirectPDISK.put(PDISK_CMDS, P_PDISK_CMDS);
        m_mapDirectPDISK.put(PDISK_LOAD, P_PDISK_LOAD);
        m_mapDirectPDISK.put(PDISK_LUNQDEPTH, P_PDISK_LUNQDEPTH);
        m_mapDirectPDISK.put(PDISK_LUNS, P_PDISK_LUNS);
        m_mapDirectPDISK.put(PDISK_MBREADS, P_PDISK_MBREADS);
        m_mapDirectPDISK.put(PDISK_MBWRITES, P_PDISK_MBWRITES);
        m_mapDirectPDISK.put(PDISK_COMS, P_PDISK_COMS);
        m_mapDirectPDISK.put(PDISK_COPYS, P_PDISK_COPYS);
        m_mapDirectPDISK.put(PDISK_QCMD, P_PDISK_QCMD);
        m_mapDirectPDISK.put(PDISK_READS, P_PDISK_READS);
        m_mapDirectPDISK.put(PDISK_RESETS, P_PDISK_RESETS);
        m_mapDirectPDISK.put(PDISK_SHARES, P_PDISK_SHARES);
        m_mapDirectPDISK.put(PDISK_SPLITS, P_PDISK_SPLITS);
        m_mapDirectPDISK.put(PDISK_SPLITCOPIES, P_PDISK_SPLITCOPIES);
        m_mapDirectPDISK.put(PDISK_TARGETS, P_PDISK_TARGETS);
        m_mapDirectPDISK.put(PDISK_WORDQDEPTH, P_PDISK_WORDQDEPTH);
        m_mapDirectPDISK.put(PDISK_WORDS, P_PDISK_WORDS);
        m_mapDirectPDISK.put(PDISK_WRITES, P_PDISK_WRITES);
        m_mapReversePDISK.put(P_PDISK_USED, PDISK_USED);
        m_mapReversePDISK.put(P_PDISK_ABORTS, PDISK_ABORTS);
        m_mapReversePDISK.put(P_PDISK_ACTIVECMD, PDISK_ACTIVECMD);
        m_mapReversePDISK.put(P_PDISK_ADPTQDEPTH, PDISK_ADPTQDEPTH);
        m_mapReversePDISK.put(P_PDISK_AVGDRVMS, PDISK_AVGDRVMS);
        m_mapReversePDISK.put(P_PDISK_AVGGUESTMS, PDISK_AVGGUESTMS);
        m_mapReversePDISK.put(P_PDISK_AVGKERNMS, PDISK_AVGKERNMS);
        m_mapReversePDISK.put(P_PDISK_CHANNELS, PDISK_CHANNELS);
        m_mapReversePDISK.put(P_PDISK_CMDS, PDISK_CMDS);
        m_mapReversePDISK.put(P_PDISK_LOAD, PDISK_LOAD);
        m_mapReversePDISK.put(P_PDISK_LUNQDEPTH, PDISK_LUNQDEPTH);
        m_mapReversePDISK.put(P_PDISK_LUNS, PDISK_LUNS);
        m_mapReversePDISK.put(P_PDISK_MBREADS, PDISK_MBREADS);
        m_mapReversePDISK.put(P_PDISK_MBWRITES, PDISK_MBWRITES);
        m_mapReversePDISK.put(P_PDISK_COMS, PDISK_COMS);
        m_mapReversePDISK.put(P_PDISK_COPYS, PDISK_COPYS);
        m_mapReversePDISK.put(P_PDISK_QCMD, PDISK_QCMD);
        m_mapReversePDISK.put(P_PDISK_READS, PDISK_READS);
        m_mapReversePDISK.put(P_PDISK_RESETS, PDISK_RESETS);
        m_mapReversePDISK.put(P_PDISK_SHARES, PDISK_SHARES);
        m_mapReversePDISK.put(P_PDISK_SPLITS, PDISK_SPLITS);
        m_mapReversePDISK.put(P_PDISK_SPLITCOPIES, PDISK_SPLITCOPIES);
        m_mapReversePDISK.put(P_PDISK_TARGETS, PDISK_TARGETS);
        m_mapReversePDISK.put(P_PDISK_WORDQDEPTH, PDISK_WORDQDEPTH);
        m_mapReversePDISK.put(P_PDISK_WORDS, PDISK_WORDS);
        m_mapReversePDISK.put(P_PDISK_WRITES, PDISK_WRITES);
        S_VCPU = "Vcpu";
        P_VCPU = Pattern.compile(S_VCPU + "\\(\\d+:(.+):\\d+:(.+)\\)\\\\(.*)");
        P_VCPU_NAME = "NAME";
        P_VCPU_BUSYWAIT = "% Busy Wait";
        P_VCPU_CORUN = "% CoRun";
        P_VCPU_COSTOP = "% CoStop";
        P_VCPU_EXTRA = "% Extra";
        P_VCPU_IDLE = "% Idle";
        P_VCPU_MAXLIM = "% Max Limited";
        P_VCPU_OVERLAP = "% Overlap";
        P_VCPU_READY = "% Ready";
        P_VCPU_RUN = "% Run";
        P_VCPU_SYSTEM = "% System";
        P_VCPU_TOTALWAIT = "% Total Wait";
        P_VCPU_USED = "% Used";
        P_VCPU_WAIT = "% Wait";
        P_VCPU_ALLOCMAX = "Alloc Max";
        P_VCPU_ALLOCMINLIM = "Alloc Min Limited";
        P_VCPU_ALLOCMIN = "Alloc Min";
        P_VCPU_ALLOCSHARES = "Alloc Shares";
        P_VCPU_CELLMIG = "Cell Migrations/sec";
        P_VCPU_EFFMIN = "Effective Min";
        P_VCPU_HTQUARANTINE = "HT Quarantine";
        P_VCPU_MIG = "Migrates/sec";
        P_VCPU_PCPU = "Physical Cpu";
        P_VCPU_CPUMIG = "Processor Migrations/sec";
        P_VCPU_QEXP = "Quantum Expires/sec";
        P_VCPU_SWITCH = "Switches/sec";
        P_VCPU_TIMERS = "Timers/sec";
        P_VCPU_WAKEUPMI = "Wakeup Migrate Idle/sec";
        P_VCPU_WAKEUPS = "Wakeups/sec";
        VCPU_ = "VCPU_";
        VCPU_NAME = "NAME";
        VCPU_BUSYWAIT = "VCPU_BUSYWAIT";
        VCPU_CORUN = "VCPU_CORUN";
        VCPU_COSTOP = "VCPU_COSTOP";
        VCPU_EXTRA = "VCPU_EXTRA";
        VCPU_IDLE = "VCPU_IDLE";
        VCPU_MAXLIM = "VCPU_MAXLIM";
        VCPU_OVERLAP = "VCPU_OVERLAP";
        VCPU_READY = "VCPU_READY";
        VCPU_RUN = "VCPU_RUN";
        VCPU_SYSTEM = "VCPU_SYSTEM";
        VCPU_TOTALWAIT = "VCPU_TOTALWAIT";
        VCPU_USED = "VCPU_USED";
        VCPU_WAIT = "VCPU_WAIT";
        VCPU_ALLOCMAX = "VCPU_ALLOCMAX";
        VCPU_ALLOCMINLIM = "VCPU_ALLOCMINLIM";
        VCPU_ALLOCMIN = "VCPU_ALLOCMIN";
        VCPU_ALLOCSHARES = "VCPU_ALLOCSHARES";
        VCPU_CELLMIG = "VCPU_CELLMIG";
        VCPU_EFFMIN = "VCPU_EFFMIN";
        VCPU_HTQUARANTINE = "VCPU_HTQUARANTINE";
        VCPU_MIG = "VCPU_MIG";
        VCPU_PCPU = "VCPU_PCPU";
        VCPU_CPUMIG = "VCPU_CPUMIG";
        VCPU_QEXP = "VCPU_QEXP";
        VCPU_SWITCH = "VCPU_SWITCH";
        VCPU_TIMERS = "VCPU_TIMERS";
        VCPU_WAKEUPMI = "VCPU_WAKEUPMI";
        VCPU_WAKEUPS = "VCPU_WAKEUPS";
        m_vcpu = new HashMap();
        m_mapDirectVCPU = new HashMap();
        m_mapReverseVCPU = new HashMap();
        m_mapDirectVCPU.put(VCPU_BUSYWAIT, P_VCPU_BUSYWAIT);
        m_mapDirectVCPU.put(VCPU_CORUN, P_VCPU_CORUN);
        m_mapDirectVCPU.put(VCPU_COSTOP, P_VCPU_COSTOP);
        m_mapDirectVCPU.put(VCPU_EXTRA, P_VCPU_EXTRA);
        m_mapDirectVCPU.put(VCPU_IDLE, P_VCPU_IDLE);
        m_mapDirectVCPU.put(VCPU_MAXLIM, P_VCPU_MAXLIM);
        m_mapDirectVCPU.put(VCPU_OVERLAP, P_VCPU_OVERLAP);
        m_mapDirectVCPU.put(VCPU_READY, P_VCPU_READY);
        m_mapDirectVCPU.put(VCPU_RUN, P_VCPU_RUN);
        m_mapDirectVCPU.put(VCPU_SYSTEM, P_VCPU_SYSTEM);
        m_mapDirectVCPU.put(VCPU_TOTALWAIT, P_VCPU_TOTALWAIT);
        m_mapDirectVCPU.put(VCPU_USED, P_VCPU_USED);
        m_mapDirectVCPU.put(VCPU_WAIT, P_VCPU_WAIT);
        m_mapDirectVCPU.put(VCPU_ALLOCMAX, P_VCPU_ALLOCMAX);
        m_mapDirectVCPU.put(VCPU_ALLOCMINLIM, P_VCPU_ALLOCMINLIM);
        m_mapDirectVCPU.put(VCPU_ALLOCMIN, P_VCPU_ALLOCMIN);
        m_mapDirectVCPU.put(VCPU_ALLOCSHARES, P_VCPU_ALLOCSHARES);
        m_mapDirectVCPU.put(VCPU_CELLMIG, P_VCPU_CELLMIG);
        m_mapDirectVCPU.put(VCPU_EFFMIN, P_VCPU_EFFMIN);
        m_mapDirectVCPU.put(VCPU_HTQUARANTINE, P_VCPU_HTQUARANTINE);
        m_mapDirectVCPU.put(VCPU_MIG, P_VCPU_MIG);
        m_mapDirectVCPU.put(VCPU_PCPU, P_VCPU_PCPU);
        m_mapDirectVCPU.put(VCPU_CPUMIG, P_VCPU_CPUMIG);
        m_mapDirectVCPU.put(VCPU_QEXP, P_VCPU_QEXP);
        m_mapDirectVCPU.put(VCPU_SWITCH, P_VCPU_SWITCH);
        m_mapDirectVCPU.put(VCPU_TIMERS, P_VCPU_TIMERS);
        m_mapDirectVCPU.put(VCPU_WAKEUPMI, P_VCPU_WAKEUPMI);
        m_mapDirectVCPU.put(VCPU_WAKEUPS, P_VCPU_WAKEUPS);
        m_mapReverseVCPU.put(P_VCPU_BUSYWAIT, VCPU_BUSYWAIT);
        m_mapReverseVCPU.put(P_VCPU_CORUN, VCPU_CORUN);
        m_mapReverseVCPU.put(P_VCPU_COSTOP, VCPU_COSTOP);
        m_mapReverseVCPU.put(P_VCPU_EXTRA, VCPU_EXTRA);
        m_mapReverseVCPU.put(P_VCPU_IDLE, VCPU_IDLE);
        m_mapReverseVCPU.put(P_VCPU_MAXLIM, VCPU_MAXLIM);
        m_mapReverseVCPU.put(P_VCPU_OVERLAP, VCPU_OVERLAP);
        m_mapReverseVCPU.put(P_VCPU_READY, VCPU_READY);
        m_mapReverseVCPU.put(P_VCPU_RUN, VCPU_RUN);
        m_mapReverseVCPU.put(P_VCPU_SYSTEM, VCPU_SYSTEM);
        m_mapReverseVCPU.put(P_VCPU_TOTALWAIT, VCPU_TOTALWAIT);
        m_mapReverseVCPU.put(P_VCPU_USED, VCPU_USED);
        m_mapReverseVCPU.put(P_VCPU_WAIT, VCPU_WAIT);
        m_mapReverseVCPU.put(P_VCPU_ALLOCMAX, VCPU_ALLOCMAX);
        m_mapReverseVCPU.put(P_VCPU_ALLOCMINLIM, VCPU_ALLOCMINLIM);
        m_mapReverseVCPU.put(P_VCPU_ALLOCMIN, VCPU_ALLOCMIN);
        m_mapReverseVCPU.put(P_VCPU_ALLOCSHARES, VCPU_ALLOCSHARES);
        m_mapReverseVCPU.put(P_VCPU_CELLMIG, VCPU_CELLMIG);
        m_mapReverseVCPU.put(P_VCPU_EFFMIN, VCPU_EFFMIN);
        m_mapReverseVCPU.put(P_VCPU_HTQUARANTINE, VCPU_HTQUARANTINE);
        m_mapReverseVCPU.put(P_VCPU_MIG, VCPU_MIG);
        m_mapReverseVCPU.put(P_VCPU_PCPU, VCPU_PCPU);
        m_mapReverseVCPU.put(P_VCPU_CPUMIG, VCPU_CPUMIG);
        m_mapReverseVCPU.put(P_VCPU_QEXP, VCPU_QEXP);
        m_mapReverseVCPU.put(P_VCPU_SWITCH, VCPU_SWITCH);
        m_mapReverseVCPU.put(P_VCPU_TIMERS, VCPU_TIMERS);
        m_mapReverseVCPU.put(P_VCPU_WAKEUPMI, VCPU_WAKEUPMI);
        m_mapReverseVCPU.put(P_VCPU_WAKEUPS, VCPU_WAKEUPS);
        logger = new STLogger(".", "ESXTOP_");
    }
}

