/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.NullMonSubmitter;
import com.blixx.agent.util.Utils;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.net.MalformedServerReplyException;
import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;

public class FTPSMonitor
implements IMonitorExtPerf {
    public String[] m_hostnames = null;
    public String m_monitor = "";
    public long m_connectTime = -1L;
    public long m_responseTime = -1L;
    public IMonitorSubmitter m_submitter = null;
    public IPerfLog m_perfSubmitter = null;

    public static FTPSMonitor getInstance(String monitor, String[] hostnames) {
        FTPSMonitor mon = new FTPSMonitor();
        mon.m_hostnames = hostnames;
        mon.m_monitor = monitor;
        return mon;
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runMonitor() {
        for (int i = 0; i < this.m_hostnames.length; ++i) {
            double speed = -1.0;
            double totalTime = -1.0;
            double status = -7.0;
            HashMap<String, Object> opts = new HashMap<String, Object>();
            String[] args = Utils.split(this.m_hostnames[i]);
            String user = "anonymous";
            String pass = "FTPSMonitor@boom";
            String auth = null;
            String hostname = null;
            String path = null;
            int port = 21;
            try {
                String up;
                URL url = new URL(args[0]);
                hostname = url.getHost();
                if (url.getPort() != -1) {
                    port = url.getPort();
                }
                if ((up = url.getUserInfo()) != null) {
                    int eop;
                    String[] upa = up.split(":");
                    user = upa[0];
                    if (upa.length == 2 && (eop = (pass = upa[1]).indexOf(59)) != -1) {
                        pass = pass.substring(0, eop);
                    }
                }
                path = url.getPath();
                opts.put("path", url.getPath());
                opts.put("host", hostname);
                opts.put("user", user);
            }
            catch (MalformedURLException e1) {
                opts.put("error", "Invalid FTP URL");
                this.m_submitter.submitMonitorValue(this.m_monitor, -7.0, "parameter #" + i, opts);
                return null;
            }
            if (args.length > 1) {
                auth = args[1];
            }
            long start = System.currentTimeMillis();
            FTP client = null;
            try {
                client = auth == null ? new FTPClient() : new FTPSClient(auth);
                ((FTPClient)client).setDataTimeout(10000);
                client.connect(hostname, port);
                int replyCode = client.getReplyCode();
                if (FTPReply.isPositiveCompletion(replyCode)) {
                    boolean isOK = ((FTPClient)client).login(user, pass);
                    this.m_connectTime = System.currentTimeMillis() - start + 1L;
                    status = client.getReplyCode();
                    if (isOK) {
                        long bytes = 0L;
                        start = System.currentTimeMillis();
                        if (path != null && !path.endsWith("/")) {
                            ((FTPClient)client).setFileType(2);
                            ((FTPClient)client).enterLocalPassiveMode();
                            NullStream bos = new NullStream();
                            ((FTPClient)client).retrieveFile(path, bos);
                            status = client.getReplyCode();
                            bytes = bos.m_count;
                        } else {
                            String[] arr = ((FTPClient)client).listNames();
                            for (int j = 0; j < arr.length; ++j) {
                                bytes += (long)arr[j].length();
                            }
                        }
                        this.m_responseTime = System.currentTimeMillis() - start + 1L;
                        opts.put("bytes", bytes);
                        if (bytes > 0L) {
                            double bd = bytes;
                            double t = this.m_responseTime;
                            speed = bd * 1000.0 / t / 1024.0;
                            opts.put("speed", speed);
                        } else {
                            opts.put("speed", -1);
                        }
                    } else {
                        this.m_responseTime = 0L;
                        if (status == 550.0) {
                            status = 2.0;
                        }
                    }
                } else {
                    status = replyCode;
                    opts.put("error", client.getReplyString());
                }
                totalTime = this.m_connectTime + this.m_responseTime;
                if (totalTime <= 0.0) {
                    this.m_responseTime = -1L;
                    this.m_connectTime = -1L;
                    totalTime = -1L;
                }
                opts.put("time", totalTime);
                opts.put("ctime", this.m_connectTime);
                opts.put("rtime", this.m_responseTime);
            }
            catch (NoSuchAlgorithmException e) {
                status = -1.0;
            }
            catch (UnknownHostException e) {
                status = -6.0;
            }
            catch (SocketException e) {
                status = -4.0;
                try {
                    InetAddress addr = InetAddress.getByName(hostname);
                    if (addr.isReachable(3000)) {
                        status = -3.0;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            catch (MalformedServerReplyException e) {
                status = -2.0;
            }
            catch (IOException e) {
                status = client.getReplyCode();
                opts.put("error", client.getReplyString());
            }
            finally {
                try {
                    ((FTPClient)client).logout();
                }
                catch (Throwable e) {}
                try {
                    ((FTPClient)client).disconnect();
                }
                catch (Throwable e) {}
            }
            this.m_submitter.submitMonitorValue(this.m_monitor, totalTime, hostname + path + ":TIME", opts);
            this.m_submitter.submitMonitorValue(this.m_monitor, status, hostname + path + ":AVAILABILITY", opts);
            if (this.m_perfSubmitter == null) continue;
            ArrayList<Object> perfMetrics = new ArrayList<Object>();
            perfMetrics.add(new PerfStringMetric("HOST", hostname));
            perfMetrics.add(new PerfDoubleMetric("PORT", (double)port));
            perfMetrics.add(new PerfStringMetric("OBJECT", path));
            perfMetrics.add(new PerfDoubleMetric("RTIME", (double)this.m_responseTime));
            perfMetrics.add(new PerfDoubleMetric("CTIME", (double)this.m_connectTime));
            perfMetrics.add(new PerfDoubleMetric("TTIME", totalTime));
            perfMetrics.add(new PerfDoubleMetric("SPEED", speed));
            perfMetrics.add(new PerfDoubleMetric("STATUS", status));
            this.m_perfSubmitter.submitPerfRow("IS_FTP", System.currentTimeMillis(), perfMetrics);
        }
        return null;
    }

    public void setMessageSubmitter(IMessage submitter) {
    }

    public void stop() {
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    public static void main(String[] args) {
        String monitor = "FTP_NOSSL5";
        String url = "ftp://root:sunny@sunny/";
        FTPSMonitor.check(monitor, url);
        monitor = "WrongProtocol_-2";
        url = "ftp://rhel4.blixx.de:22/";
        FTPSMonitor.check(monitor, url);
        monitor = "UnknownHost_-6";
        url = "ftp://rhel444444.blixx.de/";
        FTPSMonitor.check(monitor, url);
        monitor = "localhost_-6";
        url = "ftp://localhost/";
        FTPSMonitor.check(monitor, url);
        monitor = "Privileges_2";
        url = "ftp://rhel4.blixx.de/";
        FTPSMonitor.check(monitor, url);
        monitor = "NotExistingFile_550";
        url = "ftp://root:sunny@sunny.blixx.de/NotExistingFile";
        FTPSMonitor.check(monitor, url);
        monitor = "MALFORMED_-7";
        url = "rhel4.blixx.de/";
        FTPSMonitor.check(monitor, url);
        monitor = "LOGINFAILED_530";
        url = "ftp://root:wrongPassTest@sunny.blixx.de/";
        FTPSMonitor.check(monitor, url);
        monitor = "LOGINFAILED_530";
        url = "ftp://wrongUserTest:wrongPassTest@sunny.blixx.de/";
        FTPSMonitor.check(monitor, url);
        monitor = "FTPNOTRUNNING_-4";
        url = "ftp://root:sunny@blixx22.blixx.de/";
        FTPSMonitor.check(monitor, url);
        monitor = "OK";
        url = "ftp://boris:4boris@blixx26.blixx.de/";
        FTPSMonitor.check(monitor, url);
        monitor = "OK_SSL";
        url = "ftp://boris:4boris@blixx26.blixx.de/ SSL";
        FTPSMonitor.check(monitor, url);
        monitor = "OK_TLS";
        url = "ftp://boris:4boris@blixx26.blixx.de/ TLS";
        FTPSMonitor.check(monitor, url);
    }

    private static void check(String monitor, String url) {
        FTPSMonitor fm = new FTPSMonitor();
        fm.m_hostnames = new String[]{url};
        fm.m_monitor = monitor;
        fm.setMonitorSubmitter(new NullMonSubmitter());
        fm.runMonitor();
    }

    public class NullStream
    extends OutputStream {
        public long m_count = 0L;

        @Override
        public void write(int b) throws IOException {
            ++this.m_count;
        }
    }
}

