/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.util.FileHash;
import com.blixx.agent.util.GlobScanner;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitor;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorSubmitter;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class FileChangeMonitor
implements IMonitorExt {
    public static int FILE_NOTHING_FOUND = -1;
    public static int FILE_NEW = 0;
    public static int FILE_UNCHANGED = 1;
    public static int FILE_CHANGED = 2;
    public static int FILE_DELETED = 3;
    public String m_monitorName = null;
    public File m_hashesStored = new File("spi/FileChangeMonitor.dat");
    public Map<String, HashMap<String, FileHash>> m_filemask = new LinkedHashMap<String, HashMap<String, FileHash>>();
    protected IMonitorSubmitter m_monitorSubmitter = null;
    protected IMessage m_messageSubmitter = null;
    protected HashMap<String, FileHash> m_files = new HashMap();

    public static IMonitor getInstance(String monitorName, String[] parameters) {
        FileChangeMonitor fcm = new FileChangeMonitor();
        fcm.m_monitorName = monitorName;
        for (String filemask : parameters) {
            fcm.m_filemask.put(filemask, new HashMap());
        }
        return fcm;
    }

    public String runMonitor() {
        boolean isFoundFile = false;
        for (Map.Entry<String, HashMap<String, FileHash>> en : this.m_filemask.entrySet()) {
            String fileMask = en.getKey();
            HashMap<String, FileHash> previuos = en.getValue();
            HashMap<String, FileHash> currentStateMap = GlobScanner.findAllFiles(fileMask);
            for (Map.Entry<String, FileHash> enCurr : currentStateMap.entrySet()) {
                if (!previuos.containsKey(enCurr.getKey())) {
                    previuos.put(enCurr.getKey(), enCurr.getValue());
                    this.sendMonitorValue(enCurr.getKey(), enCurr.getValue(), FILE_NEW);
                    isFoundFile = true;
                    continue;
                }
                FileHash prev_FH = previuos.get(enCurr.getKey());
                if (!prev_FH.equals(enCurr.getValue())) {
                    previuos.put(enCurr.getKey(), enCurr.getValue());
                    this.sendMonitorValue(enCurr.getKey(), enCurr.getValue(), FILE_CHANGED);
                } else {
                    this.sendMonitorValue(enCurr.getKey(), enCurr.getValue(), FILE_UNCHANGED);
                }
                isFoundFile = true;
            }
            HashSet<String> pr = new HashSet<String>(previuos.keySet());
            pr.removeAll(currentStateMap.keySet());
            for (String deleted : pr) {
                this.sendMonitorValue(deleted, previuos.get(deleted), FILE_DELETED);
                previuos.remove(deleted);
                isFoundFile = true;
            }
        }
        if (!isFoundFile) {
            this.m_monitorSubmitter.submitMonitorValue(this.m_monitorName, (double)FILE_NOTHING_FOUND, null, null);
        }
        return null;
    }

    protected void sendMonitorValue(String path, FileHash fh, int code) {
        if (this.m_monitorSubmitter != null) {
            HashMap<String, String> optVars = new HashMap<String, String>();
            optVars.put("SIZE", "" + fh.getSize());
            optVars.put("DIGEST", fh.getDigestString());
            optVars.put("LMT", fh.getLastModifiedTime());
            this.m_monitorSubmitter.submitMonitorValue(this.m_monitorName, (double)code, path, optVars);
        }
    }

    public void setInterval(long ms) {
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_messageSubmitter = submitter;
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_monitorSubmitter = submitter;
    }

    public void stop() {
    }
}

