/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorSubmitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;

public class FileSystemSpaceMonitor
implements IMonitorExt,
Runnable {
    public String[] m_hostnames = null;
    public String m_monitor = "";
    public IMonitorSubmitter m_submitter = null;
    public HashMap m_optVars = new HashMap();

    public static FileSystemSpaceMonitor getInstance(String monitor, String[] hostnames) {
        FileSystemSpaceMonitor mon = new FileSystemSpaceMonitor();
        mon.m_hostnames = hostnames;
        mon.m_monitor = monitor;
        return mon;
    }

    public String runMonitor() {
        if (this.m_hostnames != null) {
            for (int i = 0; i < this.m_hostnames.length; ++i) {
                long bytes = this.getFreeDiskspace(this.m_hostnames[i]);
                long res = bytes / 0x100000L;
                this.m_submitter.submitMonitorValue(this.m_monitor, (double)res, this.m_hostnames[i], this.m_optVars);
            }
        }
        return null;
    }

    public long getFreeDiskspace(String hostname) {
        try {
            String line;
            String os = System.getProperty("os.name");
            this.m_optVars.put("os", os);
            String command = "cmd.exe /c dir C:\\";
            Runtime runtime = Runtime.getRuntime();
            Process process = null;
            process = runtime.exec(command);
            if (process == null) {
                return -1L;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String freeSpace = null;
            while ((line = in.readLine()) != null) {
                freeSpace = line;
            }
            if (freeSpace == null) {
                return -1L;
            }
            process.destroy();
            String str = null;
            freeSpace = freeSpace.trim();
            freeSpace = freeSpace.replaceAll("\\.", "");
            freeSpace = freeSpace.replaceAll(",", "");
            String[] items = freeSpace.split(" ");
            for (int i = 0; i < items.length; ++i) {
                str = items[i];
                if (!str.equalsIgnoreCase("Bytes")) continue;
                str = items[i - 1];
                break;
            }
            if (str != null) {
                try {
                    long bytes = Long.valueOf(str);
                    return bytes;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return -1L;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    public void setMessageSubmitter(IMessage submitter) {
    }

    public void stop() {
    }

    @Override
    public void run() {
    }
}

